/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.sql.http.enricher.PaginationService;
import ai.digital.deploy.sql.model.ReportLine;
import ai.digital.deploy.tasker.common.TaskType;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineConverter$;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentTaskReportLineConverter$;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.ReportGenerator;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.util.TaskFilterUtils$;
import com.xebialabs.deployit.engine.api.ReportService;
import com.xebialabs.deployit.engine.api.dto.AuditPreviewRow;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.report.AppEnvStatusReport;
import com.xebialabs.deployit.engine.api.dto.report.DeploymentsStatusOverview;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.TaskKind;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.report.audit.AuditPreviewReport;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.ConfigurationItemDataWithInternalId;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.core.Context;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.stream.Stream;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.ReadableInstant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0005\r%h\u0001B\u000f\u001f\u0001-B\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!A\u0007A!A!\u0002\u0013I\u0007\"\u00027\u0001\t\u0003i\u0007\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0003v\u0011-\t)\u0001\u0001a\u0001\u0002\u0004%I!a\u0002\t\u0015\u0005e\u0001\u00011A\u0001B\u0003&a\u000fC\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<!9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0004bBAX\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0005O\u0001A\u0011\tB\u0015\u0011\u001d\u0011\u0019\u0005\u0001C!\u0005\u000bBqA!(\u0001\t\u0013\u0011y\nC\u0004\u0003L\u0002!\tE!4\t\u000f\t\u0015\b\u0001\"\u0011\u0003h\"9!q \u0001\u0005\n\r\u0005\u0001bBB!\u0001\u0011%11\t\u0005\b\u0007#\u0002A\u0011IB*\u0011\u001d\u0019)\u0006\u0001C!\u0007'Bqaa\u0016\u0001\t\u0003\u001aI\u0006C\u0004\u0004X\u0001!\tea\u0018\t\u000f\r%\u0004\u0001\"\u0011\u0004l!911\u0011\u0001\u0005B\r\u0015\u0005bBBL\u0001\u0011\u00053\u0011\u0014\u0005\b\u0007O\u0003A\u0011IBU\u0005E\u0011V\r]8siN+'O^5dK&k\u0007\u000f\u001c\u0006\u0003?\u0001\n1!\u00199j\u0015\t\t#%\u0001\u0003sKN$(BA\u0012%\u0003\u0011\u0019wN]3\u000b\u0005\u00152\u0013\u0001\u00033fa2|\u00170\u001b;\u000b\u0005\u001dB\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0013aA2p[\u000e\u00011\u0003\u0002\u0001-ee\u0002\"!\f\u0019\u000e\u00039R!a\f\u0011\u0002\u000fM,7-\u001e:fI&\u0011\u0011G\f\u0002\u0018\u0003\n\u001cHO]1diN+7-\u001e:fIJ+7o\\;sG\u0016\u0004\"aM\u001c\u000e\u0003QR!aH\u001b\u000b\u0005Y\"\u0013AB3oO&tW-\u0003\u00029i\ti!+\u001a9peR\u001cVM\u001d<jG\u0016\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u000bMdg\r\u000e6\u000b\u0003y\n\u0001b\u001a:jujdW\rZ\u0005\u0003\u0001n\u0012q\u0001T8hO&tw-A\bsKB|'\u000f^$f]\u0016\u0014\u0018\r^8s!\t\u0019E)D\u0001\u001f\u0013\t)eDA\bSKB|'\u000f^$f]\u0016\u0014\u0018\r^8s\u0003E\u0001\u0018mZ5oCRLwN\\*feZL7-\u001a\t\u0003\u0011Vk\u0011!\u0013\u0006\u0003\u0015.\u000b\u0001\"\u001a8sS\u000eDWM\u001d\u0006\u0003\u00196\u000bA\u0001\u001b;ua*\u0011ajT\u0001\u0004gFd'B\u0001)R\u0003\u0019!W\r\u001d7ps*\u0011!kU\u0001\bI&<\u0017\u000e^1m\u0015\u0005!\u0016AA1j\u0013\t1\u0016JA\tQC\u001eLg.\u0019;j_:\u001cVM\u001d<jG\u0016\fAbY5SKB|7/\u001b;pef\u0004\"!W/\u000e\u0003iS!AT.\u000b\u0005q#\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011aL\u0017\u0002\r\u0007&\u0014V\r]8tSR|'/_\u0001\fi\u0006\u001c8.\u0011:dQ&4X\r\u0005\u0002bM6\t!M\u0003\u0002dI\u00069\u0011M]2iSZ,'BA3%\u0003\u0011!\u0018m]6\n\u0005\u001d\u0014'a\u0003+bg.\f%o\u00195jm\u0016\f\u0001\u0003Z8x]2|\u0017\r\u001a*fg>,(oY3\u0011\u0005\rS\u0017BA6\u001f\u0005A!un\u001e8m_\u0006$'+Z:pkJ\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0007]>\u0004\u0018O]:\u0011\u0005\r\u0003\u0001\"B!\u0007\u0001\u0004\u0011\u0005\"\u0002$\u0007\u0001\u00049\u0005\"B,\u0007\u0001\u0004A\u0006\"B0\u0007\u0001\u0004\u0001\u0007\"\u00025\u0007\u0001\u0004I\u0017\u0001\u0003:fgB|gn]3\u0016\u0003Y\u00042a^A\u0001\u001b\u0005A(BA={\u0003\r\u0019\b/\u001b\u0006\u0003wr\f\u0001B]3ti\u0016\f7/\u001f\u0006\u0003{z\fQA\u001b2pgNT\u0011a`\u0001\u0004_J<\u0017bAA\u0002q\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\u0006a!/Z:q_:\u001cXm\u0018\u0013fcR!\u0011\u0011BA\u000b!\u0011\tY!!\u0005\u000e\u0005\u00055!BAA\b\u0003\u0015\u00198-\u00197b\u0013\u0011\t\u0019\"!\u0004\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003/A\u0011\u0011!a\u0001m\u0006\u0019\u0001\u0010J\u0019\u0002\u0013I,7\u000f]8og\u0016\u0004\u0003fA\u0005\u0002\u001eA!\u0011qDA\u0018\u001b\t\t\tCC\u0002$\u0003GQA!!\n\u0002(\u0005\u0011!o\u001d\u0006\u0005\u0003S\tY#\u0001\u0002xg*\u0011\u0011QF\u0001\bU\u0006\\\u0017M\u001d;b\u0013\u0011\t\t$!\t\u0003\u000f\r{g\u000e^3yi\u0006Y1/\u001a;SKN\u0004xN\\:f)\u0011\tI!a\u000e\t\u000bQT\u0001\u0019\u0001<\u0002\u0019M,GoQ5GS2$XM]:\u0015\r\u0005%\u0011QHA%\u0011\u001d\tyd\u0003a\u0001\u0003\u0003\n\u0001c]3be\u000eD\u0007+\u0019:b[\u0016$XM]:\u0011\t\u0005\r\u0013QI\u0007\u0002I&\u0019\u0011q\t3\u00039\u0005\u00138\r[5wK\u0012$\u0016m]6TK\u0006\u00148\r\u001b)be\u0006lW\r^3sg\"9\u00111J\u0006A\u0002\u00055\u0013\u0001F2p]\u001aLw-\u001e:bi&|g.\u0013;f[&#7\u000f\u0005\u0004\u0002P\u0005e\u0013QL\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005!Q\u000f^5m\u0015\t\t9&\u0001\u0003kCZ\f\u0017\u0002BA.\u0003#\u0012A\u0001T5tiB!\u0011qLA3\u001b\t\t\tGC\u0002\u0002dQ\n1\u0001\u001a;p\u0013\u0011\t9'!\u0019\u0003'\r{gNZ5hkJ\fG/[8o\u0013R,W.\u00133\u0002\u0019M$(/Z1n%\u0016\u0004xN\u001d;\u0016\t\u00055\u0014q\u0010\u000b\t\u0003_\n\t*!)\u0002,B1\u0011\u0011OA<\u0003wj!!a\u001d\u000b\t\u0005U\u0014\u0011K\u0001\u0007gR\u0014X-Y7\n\t\u0005e\u00141\u000f\u0002\u0007'R\u0014X-Y7\u0011\t\u0005u\u0014q\u0010\u0007\u0001\t\u001d\t\t\t\u0004b\u0001\u0003\u0007\u0013\u0011\u0001V\t\u0005\u0003\u000b\u000bY\t\u0005\u0003\u0002\f\u0005\u001d\u0015\u0002BAE\u0003\u001b\u0011qAT8uQ&tw\r\u0005\u0003\u0002\f\u00055\u0015\u0002BAH\u0003\u001b\u00111!\u00118z\u0011\u001d\t\u0019\n\u0004a\u0001\u0003+\u000b1\u0002]1hS:<W*Y=cKB1\u00111BAL\u00037KA!!'\u0002\u000e\t1q\n\u001d;j_:\u0004B!a\u0018\u0002\u001e&!\u0011qTA1\u0005\u0019\u0001\u0016mZ5oO\"9\u00111\u0015\u0007A\u0002\u0005\u0015\u0016a\u00032vS2$\u0007+\u0019:b[N\u0004\u0002\"a\u0003\u0002(\u0006m\u0015\u0011I\u0005\u0005\u0003S\u000biAA\u0005Gk:\u001cG/[8oc!9\u0011Q\u000f\u0007A\u0002\u00055\u0006\u0003CA\u0006\u0003O\u000b\t%a\u001c\u00025M$(/Z1n\t\u0016\u0004Hn\\=nK:$H+Y:l%\u0016\u0004xN\u001d;\u00155\u0005M\u00161XAf\u0003\u001f\f\u0019.a8\u0002|\u0006}(1\u0001B\n\u0005/\u0011\tC!\n\u0011\r\u0005E\u0014qOA[!\u0011\ty&a.\n\t\u0005e\u0016\u0011\r\u0002\u0019\t\u0016\u0004Hn\\=nK:$H+Y:l%\u0016\u0004xN\u001d;MS:,\u0007bBA_\u001b\u0001\u0007\u0011qX\u0001\u0006E\u0016<\u0017N\u001c\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*\u001910!2\u000b\u0005}\u0011\u0013\u0002BAe\u0003\u0007\u0014A\u0001R1uK\"9\u0011QZ\u0007A\u0002\u0005}\u0016aA3oI\"9\u0011\u0011[\u0007A\u0002\u0005U\u0015A\u00029bO&tw\rC\u0004\u0002V6\u0001\r!a6\u0002\u000b=\u0014H-\u001a:\u0011\r\u0005=\u0013\u0011LAm!\u0011\ty&a7\n\t\u0005u\u0017\u0011\r\u0002\t\u001fJ$WM]5oO\"9\u0011\u0011]\u0007A\u0002\u0005\r\u0018!B;tKJ\u001c\bCBA(\u00033\n)\u000f\u0005\u0003\u0002h\u0006Uh\u0002BAu\u0003c\u0004B!a;\u0002\u000e5\u0011\u0011Q\u001e\u0006\u0004\u0003_T\u0013A\u0002\u001fs_>$h(\u0003\u0003\u0002t\u00065\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002x\u0006e(AB*ue&twM\u0003\u0003\u0002t\u00065\u0001bBA\u007f\u001b\u0001\u0007\u00111]\u0001\u000bi\u0006\u001c8n\u0015;bi\u0016\u001c\bb\u0002B\u0001\u001b\u0001\u0007\u00111]\u0001\ni\u0006\u001c8\u000eV=qKNDqA!\u0002\u000e\u0001\u0004\u00119!A\u0005gKR\u001c\u0007.T8eKB!!\u0011\u0002B\b\u001b\t\u0011YAC\u0002\u0003\u000eQ\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\tE!1\u0002\u0002\n\r\u0016$8\r['pI\u0016DqA!\u0006\u000e\u0001\u0004\t)/\u0001\u0004uCN\\\u0017\n\u001a\u0005\b\u00053i\u0001\u0019\u0001B\u000e\u00039yg\u000e\\=Tk\u000e\u001cWm]:gk2\u0004B!a\u0003\u0003\u001e%!!qDA\u0007\u0005\u001d\u0011un\u001c7fC:DqAa\t\u000e\u0001\u0004\t)/\u0001\u0006x_J\\WM\u001d(b[\u0016Dq!a\u0013\u000e\u0001\u0004\ti%A\u0007hKR$\u0016m]6SKB|'\u000f\u001e\u000b\u001b\u0003g\u0013YC!\f\u00030\tE\"1\u0007B\u001b\u0005o\u0011IDa\u000f\u0003>\t}\"\u0011\t\u0005\b\u0003{s\u0001\u0019AA`\u0011\u001d\tiM\u0004a\u0001\u0003\u007fCq!!5\u000f\u0001\u0004\tY\nC\u0004\u0002V:\u0001\r!a6\t\u000f\u0005\u0005h\u00021\u0001\u0002d\"9\u0011Q \bA\u0002\u0005\r\bb\u0002B\u0001\u001d\u0001\u0007\u00111\u001d\u0005\b\u0005\u000bq\u0001\u0019\u0001B\u0004\u0011\u001d\u0011)B\u0004a\u0001\u0003KDqA!\u0007\u000f\u0001\u0004\u0011Y\u0002C\u0004\u0003$9\u0001\r!!:\t\u000f\u0005-c\u00021\u0001\u0002N\u0005\u0011Bm\\<oY>\fG\rV1tWJ+\u0007o\u001c:u)Y\t)Oa\u0012\u0003J\t-#Q\nB(\u0005#\u0012\u0019F!\u0016\u0003X\te\u0003bBA_\u001f\u0001\u0007\u0011q\u0018\u0005\b\u0003\u001b|\u0001\u0019AA`\u0011\u001d\t)n\u0004a\u0001\u0003/Dq!!9\u0010\u0001\u0004\t\u0019\u000fC\u0004\u0002~>\u0001\r!a9\t\u000f\t\u0005q\u00021\u0001\u0002d\"9!QC\bA\u0002\u0005\u0015\bb\u0002B\r\u001f\u0001\u0007!1\u0004\u0005\b\u0005Gy\u0001\u0019AAs\u0011\u001d\tYe\u0004a\u0001\u0003\u001bB3b\u0004B/\u0005O\u0012IG!\u001c\u0003pA!!q\fB2\u001b\t\u0011\tG\u0003\u0002|A%!!Q\rB1\u0005\u001d9vN]6eSJ\fa\u0001\u001d:fM&D\u0018E\u0001B6\u0003!!wn\u001e8m_\u0006$\u0017!B2mK\u0006tGE\u0001B9\u0013\u0011\u0011\u0019H!\u001e\u0002\r\u0005cu+Q-T\u0015\u0011\u00119H!\u001f\u0002\u000b\rcW-\u00198\u000b\t\tm$\u0011M\u0001\b/>\u00148\u000eZ5sQ-y!q\u0010BJ\u0005+\u0013IJa'\u0011\t\t\u0005%qR\u0007\u0003\u0005\u0007SAA!\"\u0003\b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\t%%1R\u0001\fiJ\fgn]1di&|gNC\u0002\u0003\u000ez\fqb\u001d9sS:<gM]1nK^|'o[\u0005\u0005\u0005#\u0013\u0019IA\u0007Ue\u0006t7/Y2uS>t\u0017\r\\\u0001\u0006m\u0006dW/Z\u0011\u0003\u0005/\u000b1D]3q_J$\u0018N\\4Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\u0018\u0001\u0003:fC\u0012|e\u000e\\=\u001a\u0003\u0005\tqc\u001d;sK\u0006l7i\u001c8ue>dG+Y:l%\u0016\u0004xN\u001d;\u00151\t\u0005&\u0011\u0016BV\u0005[\u0013\tL!.\u00038\ne&1\u0018B_\u0005\u007f\u0013\t\r\u0005\u0004\u0002r\u0005]$1\u0015\t\u0005\u0003?\u0012)+\u0003\u0003\u0003(\u0006\u0005$!F\"p]R\u0014x\u000e\u001c+bg.\u0014V\r]8si2Kg.\u001a\u0005\b\u0003{\u0003\u0002\u0019AA`\u0011\u001d\ti\r\u0005a\u0001\u0003\u007fCqAa,\u0011\u0001\u0004\t\u0019/\u0001\u0004ti\u0006$Xm\u001d\u0005\b\u0005g\u0003\u0002\u0019AAs\u0003!!\u0018m]6OC6,\u0007b\u0002B\u0003!\u0001\u0007!q\u0001\u0005\b\u0003C\u0004\u0002\u0019AAr\u0011\u001d\t)\u000e\u0005a\u0001\u0003/DqAa\t\u0011\u0001\u0004\t)\u000fC\u0004\u0003\u0016A\u0001\r!!:\t\u000f\u0005E\u0007\u00031\u0001\u0002\u0016\"9!1\u0019\tA\u0002\t\u0015\u0017a\u0002;be\u001e,Go\u001d\t\u0007\u0003\u001f\u00129-!:\n\t\t%\u0017\u0011\u000b\u0002\u0004'\u0016$\u0018!F4fi\u000e{g\u000e\u001e:pYR\u000b7o[:SKB|'\u000f\u001e\u000b\u0019\u0005C\u0013yM!5\u0003T\nU'q\u001bBm\u00057\u0014iNa8\u0003b\n\r\bbBA_#\u0001\u0007\u0011q\u0018\u0005\b\u0003\u001b\f\u0002\u0019AA`\u0011\u001d\u0011y+\u0005a\u0001\u0003GDqAa-\u0012\u0001\u0004\t)\u000fC\u0004\u0003\u0006E\u0001\rAa\u0002\t\u000f\u0005\u0005\u0018\u00031\u0001\u0002d\"9\u0011Q[\tA\u0002\u0005]\u0007b\u0002B\u0012#\u0001\u0007\u0011Q\u001d\u0005\b\u0005+\t\u0002\u0019AAs\u0011\u001d\t\t.\u0005a\u0001\u00037CqAa1\u0012\u0001\u0004\u0011)-\u0001\u000ee_^tGn\\1e\u0007>tGO]8m)\u0006\u001c8n\u001d*fa>\u0014H\u000f\u0006\u000b\u0002f\n%(1\u001eBw\u0005_\u0014\tPa=\u0003v\n](\u0011 \u0005\b\u0003{\u0013\u0002\u0019AA`\u0011\u001d\tiM\u0005a\u0001\u0003\u007fCqAa,\u0013\u0001\u0004\t\u0019\u000fC\u0004\u00034J\u0001\r!!:\t\u000f\u0005\u0005(\u00031\u0001\u0002d\"9\u0011Q\u001b\nA\u0002\u0005]\u0007b\u0002B\u0012%\u0001\u0007\u0011Q\u001d\u0005\b\u0005+\u0011\u0002\u0019AAs\u0011\u001d\u0011\u0019M\u0005a\u0001\u0005\u000bD3B\u0005B/\u0005O\u0012IG!\u001c\u0003p!Z!Ca \u0003\u0014\nU%\u0011\u0014BN\u0003]a\u0017n\u001d;BY2\u001c\u0015n](g)f\u0004Xm\u0012:pkB,G\r\u0006\u0004\u0004\u0004\r}1Q\u0007\t\t\u0007\u000b\u0019yaa\u0005\u0002f6\u00111q\u0001\u0006\u0005\u0007\u0013\u0019Y!A\u0005j[6,H/\u00192mK*!1QBA\u0007\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007#\u00199AA\u0002NCB\u0004Ba!\u0006\u0004\u001c5\u00111q\u0003\u0006\u0005\u00073\t)&\u0001\u0003mC:<\u0017\u0002BB\u000f\u0007/\u0011q!\u00138uK\u001e,'\u000fC\u0004\u0004\"M\u0001\raa\t\u0002\r\rLG+\u001f9f!\u0011\u0019)c!\r\u000e\u0005\r\u001d\"\u0002BB\u0015\u0007W\tqA]3gY\u0016\u001cGOC\u0002 \u0007[Q1aa\f%\u0003\u0019\u0001H.^4j]&!11GB\u0014\u0005\u0011!\u0016\u0010]3\t\u000f\r]2\u00031\u0001\u0004:\u0005Aq-\u001a;MC\n,G\u000e\u0005\u0005\u0002\f\u0005\u001d61HAs!\rI6QH\u0005\u0004\u0007\u007fQ&aI\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\u0012\u000bG/Y,ji\"Le\u000e^3s]\u0006d\u0017\nZ\u0001\u000eY&\u001cH\u000fV=qKB\u000bG\u000f[:\u0015\u0011\u000553QIB'\u0007\u001fBqaa\u0012\u0015\u0001\u0004\u0019I%A\u0006be\u000eD\u0017N^3e\u0007&\u001c\b\u0003CAt\u0007\u0017\u001a\u0019\"a9\n\t\rE\u0011\u0011 \u0005\b\u0007o!\u0002\u0019AB\u001d\u0011\u001d\u0019\t\u0003\u0006a\u0001\u0007G\t\u0001\u0003\\5ti\u0016sg/\u001b:p]6,g\u000e^:\u0015\u0005\u00055\u0013\u0001\u00057jgR\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8t\u0003M!wn\u001e8m_\u0006$\u0017)\u001e3jiJ+\u0007o\u001c:u)\t\t)\u000fK\u0006\u0018\u0005;\u00129G!\u001b\u0003n\t=\u0004fC\f\u0003\u0000\tM%Q\u0013BM\u00057#B!!:\u0004b!911\r\rA\u0002\u0005\r\u0018a\u00024pY\u0012,'o\u001d\u0015\f1\tu#q\rB5\u0005[\u0012y\u0007K\u0006\u0019\u0005\u007f\u0012\u0019J!&\u0003\u001a\nm\u0015A\u00059sKZLWm^!vI&$(+\u001a9peR$\u0002b!\u001c\u0004v\r]4\u0011\u0010\t\u0007\u0003c\n9ha\u001c\u0011\t\u0005}3\u0011O\u0005\u0005\u0007g\n\tGA\bBk\u0012LG\u000f\u0015:fm&,wOU8x\u0011\u001d\u0019\u0019'\u0007a\u0001\u0003GDq!!6\u001a\u0001\u0004\t9\u000eC\u0004\u0002Rf\u0001\r!a')\u000fe\u0011iFa\u001a\u0004~\u0005\u00121qP\u0001\baJ,g/[3xQ-I\"q\u0010BJ\u0005+\u0013IJa'\u0002#\u001d,Go\u0015;biV\u001cxJ^3sm&,w\u000f\u0006\u0004\u0004\b\u000eM5Q\u0013\t\u0005\u0007\u0013\u001by)\u0004\u0002\u0004\f*!1QRA1\u0003\u0019\u0011X\r]8si&!1\u0011SBF\u0005e!U\r\u001d7ps6,g\u000e^:Ti\u0006$Xo](wKJ4\u0018.Z<\t\u000f\u0005u&\u00041\u0001\u0002@\"9\u0011Q\u001a\u000eA\u0002\u0005}\u0016aD4fi\u0006\u0003\b/\u00128w'R\fG/^:\u0015\r\rm51UBS!\u0019\ty%!\u0017\u0004\u001eB!1\u0011RBP\u0013\u0011\u0019\tka#\u0003%\u0005\u0003\b/\u00128w'R\fG/^:SKB|'\u000f\u001e\u0005\b\u0003{[\u0002\u0019AA`\u0011\u001d\tim\u0007a\u0001\u0003\u007f\u000b1#];fef\u0014\u00150\u0011:dQ&4X\r\u001a#bi\u0016$bba+\u00044\u000eU6qWB]\u0007w\u001bi\f\u0005\u0004\u0002r\u0005]4Q\u0016\t\u0005\u0005\u0013\u0019y+\u0003\u0003\u00042\n-!!\u0004+bg.<\u0016\u000e\u001e5CY>\u001c7\u000eC\u0004\u0002>r\u0001\r!a0\t\u000f\u00055G\u00041\u0001\u0002@\"9\u0011\u0011\u001b\u000fA\u0002\u0005m\u0005bBAk9\u0001\u0007\u0011Q\u001d\u0005\b\u0005\u000ba\u0002\u0019\u0001B\u0004\u0011\u001d\u0019y\f\ba\u0001\u0007\u0003\f\u0001\u0002^1tWRK\b/\u001a\t\u0005\u0005\u0013\u0019\u0019-\u0003\u0003\u0004F\n-!\u0001\u0003+bg.\\\u0015N\u001c3)\u0007\u0001\u0019I\r\u0005\u0003\u0004L\u000eEWBABg\u0015\u0011\u0019yMa#\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0004T\u000e5'AC\"p]R\u0014x\u000e\u001c7fe\"\u001a\u0001aa6\u0011\t\re7Q]\u0007\u0003\u00077TAA!\"\u0004^*!1q\\Bq\u0003\u001d1\u0017m\u0019;pefTAaa9\u0003\f\u0006)!-Z1og&!1q]Bn\u0005%\tU\u000f^8xSJ,G\r")
public class ReportServiceImpl
extends AbstractSecuredResource
implements ReportService,
Logging {
    private final ReportGenerator reportGenerator;
    private final PaginationService paginationService;
    private final CiRepository ciRepository;
    private final TaskArchive taskArchive;
    private final DownloadResource downloadResource;
    @Context
    private HttpResponse response;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportServiceImpl reportServiceImpl = this;
        synchronized (reportServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private HttpResponse response() {
        return this.response;
    }

    private void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    public void setResponse(HttpResponse response) {
        this.response_$eq(response);
    }

    private void setCiFilters(ArchivedTaskSearchParameters searchParameters, java.util.List<ConfigurationItemId> configurationItemIds) {
        Tuple2<List<String>, List<String>> tuple2 = TaskFilterUtils$.MODULE$.parseCiFilters((List<ConfigurationItemId>)((List)Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala(configurationItemIds).asScala()).toList().flatten(Predef$.MODULE$.$conforms())));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List applications = (List)tuple2._1();
        List environments = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)applications, (Object)environments);
        List applications2 = (List)tuple22._1();
        List environments2 = (List)tuple22._2();
        applications2.foreach((Function1 & Serializable)x$1 -> searchParameters.forApplication(x$1));
        environments2.foreach((Function1 & Serializable)x$1 -> searchParameters.forEnvironment(x$1));
    }

    private <T> Stream<T> streamReport(Option<Paging> pagingMaybe, Function1<Paging, ArchivedTaskSearchParameters> buildParams, Function1<ArchivedTaskSearchParameters, Stream<T>> stream) {
        Option limitedMaybe = pagingMaybe.map((Function1 & Serializable)paging -> new Tuple2(paging, (Object)$this.paginationService.getLimitedPaging(paging)));
        ArchivedTaskSearchParameters searchParameters = (ArchivedTaskSearchParameters)buildParams.apply(limitedMaybe.map((Function1 & Serializable)x$3 -> (Paging)x$3._2()).getOrElse((Function0 & Serializable)() -> new Paging()));
        limitedMaybe.foreach((Function1 & Serializable)limitedPaging -> {
            this.paginationService.addPagingHeaderIfNeeded((Paging)limitedPaging._1(), (Paging)limitedPaging._2(), this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.taskArchive.countTotalResults(searchParameters$2)));
            return BoxedUnit.UNIT;
        });
        return (Stream)stream.apply((Object)searchParameters);
    }

    private Stream<DeploymentTaskReportLine> streamDeploymentTaskReport(Date begin, Date end, Option<Paging> paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, (Paging)limited, order, null, users, taskStates, taskTypes, fetchMode, taskId, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava(), ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful, workerName);
            this.setCiFilters(params, configurationItemIds);
            return params;
        }, (Function1 & Serializable)searchParameters -> $this.reportGenerator.streamTaskReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<DeploymentTaskReportLine> getTaskReport(Date begin, Date end, Paging paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamDeploymentTaskReport(begin, end, (Option<Paging>)Option$.MODULE$.apply((Object)paging), order, users, taskStates, taskTypes, fetchMode, taskId, onlySuccessful, workerName, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        Stream<ReportLine> stream = this.streamDeploymentTaskReport(begin, end, (Option<Paging>)None$.MODULE$, order, users, taskStates, taskTypes, FetchMode.SUMMARY, taskId, onlySuccessful, workerName, configurationItemIds).map(line -> DeploymentTaskReportLineConverter$.MODULE$.toReportLine((DeploymentTaskReportLine)line));
        String fileName = String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, CollectionConverters$.MODULE$.SetHasAsJava(DeploymentReportLineField$.MODULE$.allFields()).asJava(), stream, fileName);
    }

    private Stream<ControlTaskReportLine> streamControlTaskReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Option<Paging> paging, java.util.Set<String> targets) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildTaskSearchParameters((Paging)limited, order, EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
            params.withTargets(targets);
            params.withTaskStates(states);
            params.withTaskName(taskName);
            params.withFetchMode(fetchMode);
            params.withWorkerName(workerName);
            params.inDateTimeRange($this.reportGenerator.safeDateTime(begin, null), $this.reportGenerator.safeDateTime(end, null));
            params.withUniqueId(taskId);
            Object object = users != null && !users.isEmpty() ? params.forUsers((java.util.Set)Sets.newHashSet((Iterable)users)) : BoxedUnit.UNIT;
            return params;
        }, (Function1 & Serializable)searchParameters -> $this.reportGenerator.streamControlTasksReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<ControlTaskReportLine> getControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Paging paging, java.util.Set<String> targets) {
        return this.streamControlTaskReport(begin, end, states, taskName, fetchMode, users, order, workerName, taskId, (Option<Paging>)Option$.MODULE$.apply((Object)paging), targets);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, java.util.Set<String> targets) {
        Stream<ReportLine> report = this.streamControlTaskReport(begin, end, states, taskName, FetchMode.SUMMARY, users, order, workerName, taskId, (Option<Paging>)None$.MODULE$, targets).map(line -> ControlTaskReportLineConverter$.MODULE$.toReportLine((ControlTaskReportLine)line));
        return ReportUtils.createDownloadToken(this.downloadResource, CollectionConverters$.MODULE$.SetHasAsJava(ControlTaskReportLineField$.MODULE$.allFields()).asJava(), report, this.reportGenerator.buildControlTaskReportFileName(begin, end));
    }

    private Map<Integer, String> listAllCisOfTypeGrouped(Type ciType, Function1<ConfigurationItemDataWithInternalId, String> getLabel) {
        SearchParameters params = SearchParametersFactory.createSearchParams((Type)ciType, (long)0L, (long)-1L);
        PlatformPermissions.READ.getPermissionHandler().applyPermission(params);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.ciRepository.listInternal(params)).asScala().map((Function1 & Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.internalId()), getLabel.apply(item)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private java.util.List<ConfigurationItemId> listTypePaths(Map<Integer, java.util.List<String>> archivedCis, Function1<ConfigurationItemDataWithInternalId, String> getLabel, Type ciType) {
        List list;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Map<Integer, String> cisInRepository = this.listAllCisOfTypeGrouped(ciType, getLabel);
        scala.collection.immutable.Set matchedIds = (scala.collection.immutable.Set)archivedCis.keySet().intersect((Set)cisInRepository.keySet());
        List onlyInArchive = ((IterableOnceOps)archivedCis.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Integer id = (Integer)tuple2._1();
                java.util.List paths = (java.util.List)tuple2._2();
                if (matchedIds.contains((Object)id)) {
                    return (Seq)CollectionConverters$.MODULE$.ListHasAsScala(paths).asScala().filter((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$2(cisInRepository, id, path)));
                }
                return Nil$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        List list2 = cisInRepository.values().toList();
        List inArchiveAndRepository = onlyInArchive.$colon$colon$colon(list2);
        if (this.hasPermission(PlatformPermissions.REPORT_VIEW)) {
            List list3 = inArchiveAndRepository;
            list = ((IterableOnceOps)archivedCis.view().filterKeys((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$3(cisInRepository, id))).values().flatMap((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala())).toList().$colon$colon$colon(list3);
        } else {
            list = inArchiveAndRepository;
        }
        List result = list;
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)((StrictOptimizedSeqOps)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$5 -> new ConfigurationItemId(x$5, ciType))).asJava();
    }

    public java.util.List<ConfigurationItemId> listEnvironments() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)CollectionConverters$.MODULE$.MapHasAsScala(this.reportGenerator.getEnvironments()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable)x$6 -> x$6.id(), Type.valueOf(Environment.class));
    }

    public java.util.List<ConfigurationItemId> listApplications() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)CollectionConverters$.MODULE$.MapHasAsScala(this.reportGenerator.getApplications()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable)x$7 -> x$7.name(), Type.valueOf(Application.class));
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport() {
        return this.reportGenerator.generateAuditReport(Collections.emptyList(), this.downloadResource);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport(java.util.List<String> folders) {
        return this.reportGenerator.generateAuditReport(folders, this.downloadResource);
    }

    @Workdir(prefix="preview")
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Stream<AuditPreviewRow> previewAuditReport(java.util.List<String> folders, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Paging paging) {
        AuditPreviewReport previewReport = this.reportGenerator.previewAuditReport(folders, order, paging);
        Paging limited = this.paginationService.getLimitedPaging(paging);
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response()), () -> previewReport.total());
        return previewReport.currentPageData().stream();
    }

    public DeploymentsStatusOverview getStatusOverview(Date begin, Date end) {
        return this.reportGenerator.buildStatusOverview(begin, end);
    }

    public java.util.List<AppEnvStatusReport> getAppEnvStatus(Date begin, Date end) {
        return this.reportGenerator.buildAppEnvStatusReport(begin, end);
    }

    public Stream<TaskWithBlock> queryByArchivedDate(Date begin, Date end, Paging paging, String order, FetchMode fetchMode, TaskKind taskType) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        ArchivedTaskSearchParameters searchParameters = this.reportGenerator.buildQueryByArchivedDateParameters(begin, end, order, taskType);
        Paging limited = this.paginationService.getLimitedPaging(paging);
        searchParameters.showPage(limited.page(), limited.resultsPerPage());
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.taskArchive.countTotalResults(searchParameters)));
        return this.reportGenerator.queryByArchivedDate(searchParameters, fetchMode);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$2(Map cisInRepository$1, Integer id$1, String path) {
        Object object = cisInRepository$1.apply((Object)id$1);
        String string = path;
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$3(Map cisInRepository$1, Integer id) {
        return !cisInRepository$1.keySet().contains((Object)id);
    }

    public ReportServiceImpl(ReportGenerator reportGenerator, PaginationService paginationService, CiRepository ciRepository, TaskArchive taskArchive, DownloadResource downloadResource) {
        this.reportGenerator = reportGenerator;
        this.paginationService = paginationService;
        this.ciRepository = ciRepository;
        this.taskArchive = taskArchive;
        this.downloadResource = downloadResource;
        Logging.$init$((Logging)this);
    }
}

