package com.xebialabs.deployit.core.converters

import ai.digital.deploy.sql.model.ActiveUserSession
import com.xebialabs.xltype.serialization.json.JsonWriter

import scala.jdk.CollectionConverters._

class SessionsConverter {
  def sessionConverter = new SessionConverter()

  def toJson(sessions: java.util.Collection[ActiveUserSession]): String = {
    val writer = new JsonWriter
    writer.array()
    sessions.asScala.foreach(session => sessionConverter.toJson(session, writer))
    writer.endArray()
    writer.toString
  }
}
