/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.configuration.central.deploy.converter.HoconDurationConverter$;
import ai.digital.deploy.sql.http.enricher.PaginationService;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.SatelliteService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator$;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.satellite.ExtensionsDelta$;
import com.xebialabs.deployit.plugin.satellite.InstalledExtensionsDelta;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker$;
import com.xebialabs.deployit.plugin.satellite.extension.ExtensionsLocator;
import com.xebialabs.deployit.plugin.satellite.extension.FileSystemExtensionsLocator$;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SatelliteRepository;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import com.xebialabs.satellite.protocol.Paths$;
import com.xebialabs.xlplatform.satellite.Satellite;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.core.Context;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001\u0002\t\u0012\u0001yA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!AA\n\u0001B\u0001B\u0003%Q\nC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0004g\u0001\t\u0007I\u0011A4\t\rI\u0004\u0001\u0015!\u0003i\u0011)y\b\u00011AA\u0002\u0013\u0005\u0011\u0011\u0001\u0005\f\u0003;\u0001\u0001\u0019!a\u0001\n\u0003\ty\u0002C\u0006\u0002.\u0001\u0001\r\u0011!Q!\n\u0005\r\u0001bBA\u001f\u0001\u0011%\u0011q\b\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\t)\u0007\u0001C!\u0003OBq!!%\u0001\t\u0013\t\u0019\nC\u0004\u0002$\u0002!\t%!*\t\u000f\u0005]\u0007\u0001\"\u0011\u0002Z\n!2+\u0019;fY2LG/Z*feZL7-Z%na2T!AE\n\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0015+\u0005!!/Z:u\u0015\t1r#\u0001\u0003d_J,'B\u0001\r\u001a\u0003!!W\r\u001d7ps&$(B\u0001\u000e\u001c\u0003%AXMY5bY\u0006\u00147OC\u0001\u001d\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001q$\n\u0017\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t\u001a\u0012aB:fGV\u0014X\rZ\u0005\u0003I\u0005\u0012q#\u00112tiJ\f7\r^*fGV\u0014X\r\u001a*fg>,(oY3\u0011\u0005\u0019RS\"A\u0014\u000b\u0005IA#BA\u0015\u0018\u0003\u0019)gnZ5oK&\u00111f\n\u0002\u0011'\u0006$X\r\u001c7ji\u0016\u001cVM\u001d<jG\u0016\u0004\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u000bMdg\r\u000e6\u000b\u0003E\n\u0001b\u001a:jujdW\rZ\u0005\u0003g9\u0012q\u0001T8hO&tw-A\ntCR,G\u000e\\5uKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00027s5\tqG\u0003\u00029/\u0005Q!/\u001a9pg&$xN]=\n\u0005i:$aE*bi\u0016dG.\u001b;f%\u0016\u0004xn]5u_JL\u0018!\u00059bO&t\u0017\r^5p]N+'O^5dKB\u0011QHS\u0007\u0002})\u0011q\bQ\u0001\tK:\u0014\u0018n\u00195fe*\u0011\u0011IQ\u0001\u0005QR$\bO\u0003\u0002D\t\u0006\u00191/\u001d7\u000b\u0005\u00153\u0015A\u00023fa2|\u0017P\u0003\u0002H\u0011\u00069A-[4ji\u0006d'\"A%\u0002\u0005\u0005L\u0017BA&?\u0005E\u0001\u0016mZ5oCRLwN\\*feZL7-Z\u0001\u0012e\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0007C\u0001\u001cO\u0013\tyuGA\tSKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD\u0003\u0002*U+Z\u0003\"a\u0015\u0001\u000e\u0003EAQ\u0001\u000e\u0003A\u0002UBQa\u000f\u0003A\u0002qBQ\u0001\u0014\u0003A\u00025C#\u0001\u0002-\u0011\u0005e#W\"\u0001.\u000b\u0005mc\u0016AC1o]>$\u0018\r^5p]*\u0011QLX\u0001\bM\u0006\u001cGo\u001c:z\u0015\ty\u0006-A\u0003cK\u0006t7O\u0003\u0002bE\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001d\u0003\ry'oZ\u0005\u0003Kj\u0013\u0011\"Q;u_^L'/\u001a3\u0002\u0011I,7\u000f]8og\u0016,\u0012\u0001\u001b\t\u0003SBl\u0011A\u001b\u0006\u0003W2\f1a\u001d9j\u0015\tig.\u0001\u0005sKN$X-Y:z\u0015\ty'-A\u0003kE>\u001c8/\u0003\u0002rU\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\u0006I!/Z:q_:\u001cX\r\t\u0015\u0003\rQ\u0004\"!^?\u000e\u0003YT!AF<\u000b\u0005aL\u0018A\u0001:t\u0015\tQ80\u0001\u0002xg*\tA0A\u0004kC.\f'\u000f^1\n\u0005y4(aB\"p]R,\u0007\u0010^\u0001\u0017I\u00164\u0017-\u001e7u!&tw\rV5nK>,H\u000f\u0015:paV\u0011\u00111\u0001\t\u0005\u0003\u000b\t9B\u0004\u0003\u0002\b\u0005M\u0001\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055Q$\u0001\u0004=e>|GO\u0010\u0006\u0003\u0003#\tQa]2bY\u0006LA!!\u0006\u0002\u0010\u00051\u0001K]3eK\u001aLA!!\u0007\u0002\u001c\t11\u000b\u001e:j]\u001eTA!!\u0006\u0002\u0010\u0005QB-\u001a4bk2$\b+\u001b8h)&lWm\\;u!J|\u0007o\u0018\u0013fcR!\u0011\u0011EA\u0015!\u0011\t\u0019#!\n\u000e\u0005\u0005=\u0011\u0002BA\u0014\u0003\u001f\u0011A!\u00168ji\"I\u00111\u0006\u0005\u0002\u0002\u0003\u0007\u00111A\u0001\u0004q\u0012\n\u0014a\u00063fM\u0006,H\u000e\u001e)j]\u001e$\u0016.\\3pkR\u0004&o\u001c9!Q\u001dI\u0011\u0011GA\u001c\u0003s\u00012!WA\u001a\u0013\r\t)D\u0017\u0002\u0006-\u0006dW/Z\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003w\t1\u0006J>eKBdw.\u001f\u0018tCR,G\u000e\\5uK:\"\u0018.\\3pkRt\u0003/\u001b8huE\u0002\u0004e]3d_:$7/`\u0001\u0013I\u00164\u0017-\u001e7u!&tw\rV5nK>,H/\u0006\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\t\u0005-\u0013qB\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA(\u0003\u000b\u0012aBR5oSR,G)\u001e:bi&|g.A\u0004hKRLeNZ8\u0015\t\u0005U\u0013\u0011\r\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111L\u0014\u0002\u0007\u0011$x.\u0003\u0003\u0002`\u0005e#!D*bi\u0016dG.\u001b;f\u0013:4w\u000eC\u0004\u0002d-\u0001\r!a\u0001\u0002\t\rL\u0017\nZ\u0001\tO\u0016$\u0018J\u001c4pgR!\u0011\u0011NAF!\u0019\tY'!\"\u0002V9!\u0011QNA@\u001d\u0011\ty'a\u001f\u000f\t\u0005E\u0014\u0011\u0010\b\u0005\u0003g\n9H\u0004\u0003\u0002\n\u0005U\u0014\"\u0001\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\r\tihF\u0001\naJ|g/[:j_:LA!!!\u0002\u0004\u00069\u0001/Y2lC\u001e,'bAA?/%!\u0011qQAE\u0005\u0015QE*[:u\u0015\u0011\t\t)a!\t\u000f\u00055E\u00021\u0001\u0002\u0010\u0006\u0019\u0011\u000eZ:\u0011\r\u0005-\u0014QQA\u0002\u0003A\t'/\u001a)mk\u001eLgn]*z]\u000e,G\r\u0006\u0003\u0002\u0016\u0006\u0005\u0006CBA\u0012\u0003/\u000bY*\u0003\u0003\u0002\u001a\u0006=!AB(qi&|g\u000e\u0005\u0003\u0002$\u0005u\u0015\u0002BAP\u0003\u001f\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002d5\u0001\r!a\u0001\u0002\u00131L7\u000f\u001e%pgR\u001cHCCAT\u0003{\u000by,a1\u0002NB1\u0011\u0011VAZ\u0003ok!!a+\u000b\t\u00055\u0016qV\u0001\u0005kRLGN\u0003\u0002\u00022\u0006!!.\u0019<b\u0013\u0011\t),a+\u0003\t1K7\u000f\u001e\t\u0005\u0003/\nI,\u0003\u0003\u0002<\u0006e#aE\"p]\u001aLw-\u001e:bi&|g.\u0013;f[&#\u0007bBA2\u001d\u0001\u0007\u00111\u0001\u0005\b\u0003\u0003t\u0001\u0019AA\u0002\u0003\u0011q\u0017-\\3\t\u000f\u0005\u0015g\u00021\u0001\u0002H\u00061\u0001/Y4j]\u001e\u0004B!a\u0016\u0002J&!\u00111ZA-\u0005\u0019\u0001\u0016mZ5oO\"9\u0011q\u001a\bA\u0002\u0005E\u0017!B8sI\u0016\u0014\b\u0003BA,\u0003'LA!!6\u0002Z\tAqJ\u001d3fe&tw-\u0001\u0006d_VtG\u000fS8tiN$b!a7\u0002h\u0006%\b\u0003BAo\u0003Gl!!a8\u000b\t\u0005\u0005\u0018qV\u0001\u0005Y\u0006tw-\u0003\u0003\u0002f\u0006}'aB%oi\u0016<WM\u001d\u0005\b\u0003Gz\u0001\u0019AA\u0002\u0011\u001d\t\tm\u0004a\u0001\u0003\u0007A3\u0001AAw!\u0011\ty/!>\u000e\u0005\u0005E(bAAzA\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005]\u0018\u0011\u001f\u0002\b'\u0016\u0014h/[2f\u0001")
public class SatelliteServiceImpl
extends AbstractSecuredResource
implements SatelliteService,
Logging {
    private final SatelliteRepository satelliteRepository;
    private final PaginationService paginationService;
    private final RepositoryService repositoryService;
    @Context
    private final HttpResponse response;
    @Value(value="${deploy.satellite.timeout.ping:10 seconds}")
    private String defaultPingTimeoutProp;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SatelliteServiceImpl satelliteServiceImpl = this;
        synchronized (satelliteServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public HttpResponse response() {
        return this.response;
    }

    public String defaultPingTimeoutProp() {
        return this.defaultPingTimeoutProp;
    }

    public void defaultPingTimeoutProp_$eq(String x$1) {
        this.defaultPingTimeoutProp = x$1;
    }

    private FiniteDuration defaultPingTimeout() {
        return HoconDurationConverter$.MODULE$.convert(this.defaultPingTimeoutProp());
    }

    public SatelliteInfo getInfo(String ciId) {
        ActorRef x$3;
        Timeout x$2;
        SatelliteInfoChecker.Get x$1;
        ActorSystem actorSystem = TaskActorSystem$.MODULE$.actorSystem();
        ExecutionContextExecutor dispatcher = actorSystem.dispatcher();
        Timeout timeout = new Timeout(this.defaultPingTimeout());
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return null;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        ActorRef checker = TaskActorSystem$.MODULE$.actorSystem().actorOf(SatelliteInfoChecker$.MODULE$.props(satellite.getAddress()));
        ActorRef qual$1 = package$.MODULE$.ask(checker);
        Future future = AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)(x$1 = new SatelliteInfoChecker.Get(actorLocator.locate(Paths$.MODULE$.info(), actorSystem))), x$2 = timeout, x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)).recover((PartialFunction)new Serializable(this, satellite){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SatelliteServiceImpl $outer;
            private final Satellite satellite$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().debug((Function0 & Serializable)() -> "Operation failed on satellite " + $this.satellite$1.getAddress() + " (" + A1.getMessage() + ")");
                return (B1)new SatelliteInfo();
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.satellite$1 = satellite$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.deployit.core.rest.api.SatelliteServiceImpl$$anonfun$1 java.lang.Throwable )}, serializedLambda);
            }
        }, (ExecutionContext)dispatcher);
        SatelliteInfo satelliteInfo = (SatelliteInfo)Await$.MODULE$.result((Awaitable)future, package.DoubleMult$.MODULE$.$times$extension(scala.concurrent.duration.package$.MODULE$.DoubleMult(1.5), (Duration)this.defaultPingTimeout()));
        if (Predef$.MODULE$.Boolean2boolean(satelliteInfo.isAvailable())) {
            Option<Object> option = this.arePluginsSynced(ci.getId());
            if (option instanceof Some) {
                Some some = (Some)option;
                boolean pluginSync = BoxesRunTime.unboxToBoolean((Object)some.value());
                satelliteInfo.setPluginsSynced(Predef$.MODULE$.boolean2Boolean(pluginSync));
            } else if (None$.MODULE$.equals(option)) {
            } else {
                throw new MatchError(option);
            }
        }
        satelliteInfo.setSatelliteId(ciId);
        return satelliteInfo;
    }

    public List<SatelliteInfo> getInfos(List<String> ids) {
        ExecutionContextExecutor dispatcher = TaskActorSystem$.MODULE$.actorSystem().dispatcher();
        Buffer getInfoFutures = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(ids).asScala().map((Function1 & Serializable)ciId -> Future$.MODULE$.apply((Function0 & Serializable)() -> this.getInfo((String)ciId), (ExecutionContext)dispatcher));
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)getInfoFutures, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)dispatcher), (Duration)package.IntMult$.MODULE$.$times$extension(scala.concurrent.duration.package$.MODULE$.IntMult(3), this.defaultPingTimeout()))).toList()).asJava();
    }

    private Option<Object> arePluginsSynced(String ciId) {
        Some some;
        ActorSystem actorSystem = TaskActorSystem$.MODULE$.actorSystem();
        Timeout timeout = new Timeout(this.defaultPingTimeout());
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return None$.MODULE$;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        try {
            InstalledExtensionsDelta deltas = ExtensionsDelta$.MODULE$.calculateExtensionsDelta((ExtensionsLocator)FileSystemExtensionsLocator$.MODULE$, actorLocator, actorSystem);
            some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)deltas.empty()));
        }
        catch (Exception error) {
            this.logger().error((Function0 & Serializable)() -> "Plugin sync check operation failed on satellite " + satellite.getAddress() + " (" + error.getMessage() + ")");
            some = Option$.MODULE$.empty();
        }
        return some;
    }

    public List<ConfigurationItemId> listHosts(String ciId, String name, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        this.paginationService.addPagingHeaderIfNeeded(this.paginationService.toSetHeader(this.response()), () -> this.countHosts(ciId, name), paging);
        return this.satelliteRepository.listHosts(ciId, name, paging, order);
    }

    public Integer countHosts(String ciId, String name) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        return Predef$.MODULE$.int2Integer(this.satelliteRepository.countHosts(ciId, name));
    }

    @Autowired
    public SatelliteServiceImpl(SatelliteRepository satelliteRepository, PaginationService paginationService, RepositoryService repositoryService) {
        this.satelliteRepository = satelliteRepository;
        this.paginationService = paginationService;
        this.repositoryService = repositoryService;
        Logging.$init$((Logging)this);
        this.response = null;
    }
}

