/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.sql.model.CreatePersonalAccessTokenForm;
import ai.digital.deploy.sql.model.UserTokensView;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.XldUserTokenService;
import com.xebialabs.deployit.core.rest.api.AbstractUserRestrictedResource;
import com.xebialabs.deployit.core.rest.api.XldUserTokenService$;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.model.Tokens;
import com.xebialabs.deployit.security.model.XldUserToken;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.service.UserTokenService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001B\u0005\u000b\u0001]A\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tU\u0001\u0011\t\u0011)A\u0005W!)q\u0006\u0001C\u0001a!)1\t\u0001C!\t\")!\u000f\u0001C!g\")\u0011\u0010\u0001C!u\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0002\u001812$Wk]3s)>\\WM\\*feZL7-Z%na2T!a\u0003\u0007\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u000e\u001d\u0005!!/Z:u\u0015\ty\u0001#\u0001\u0003d_J,'BA\t\u0013\u0003!!W\r\u001d7ps&$(BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001\u0004\b\t\u00033ii\u0011AC\u0005\u00037)\u0011a$\u00112tiJ\f7\r^+tKJ\u0014Vm\u001d;sS\u000e$X\r\u001a*fg>,(oY3\u0011\u0005uyR\"\u0001\u0010\u000b\u0005-q\u0011B\u0001\u0011\u001f\u0005MAF\u000eZ+tKJ$vn[3o'\u0016\u0014h/[2f\u0003A)8/\u001a:U_.,gnU3sm&\u001cW\r\u0005\u0002$Q5\tAE\u0003\u0002&M\u000591/\u001a:wS\u000e,'BA\u0014\u0011\u0003!\u0019XmY;sSRL\u0018BA\u0015%\u0005A)6/\u001a:U_.,gnU3sm&\u001cW-A\u0006vg\u0016\u00148+\u001a:wS\u000e,\u0007C\u0001\u0017.\u001b\u00051\u0013B\u0001\u0018'\u0005-)6/\u001a:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\r\t$g\r\t\u00033\u0001AQ!I\u0002A\u0002\tBQAK\u0002A\u0002-B#aA\u001b\u0011\u0005Y\nU\"A\u001c\u000b\u0005aJ\u0014AC1o]>$\u0018\r^5p]*\u0011!hO\u0001\bM\u0006\u001cGo\u001c:z\u0015\taT(A\u0003cK\u0006t7O\u0003\u0002?\u007f\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001A\u0003\ry'oZ\u0005\u0003\u0005^\u0012\u0011\"Q;u_^L'/\u001a3\u0002\u001b\u001d,G/V:feR{7.\u001a8t)\u0011)5KX2\u0011\u0005\u0019\u000bV\"A$\u000b\u0005!K\u0015!B7pI\u0016d'B\u0001&L\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00196\u000ba\u0001Z3qY>L(B\u0001(P\u0003\u001d!\u0017nZ5uC2T\u0011\u0001U\u0001\u0003C&L!AU$\u0003\u001dU\u001bXM\u001d+pW\u0016t7OV5fo\")A\u000b\u0002a\u0001+\u00061\u0001/Y4j]\u001e\u0004\"A\u0016/\u000e\u0003]S!\u0001W-\u0002\u0007\u0011$xN\u0003\u0002\f5*\u00111\fE\u0001\u0007K:<\u0017N\\3\n\u0005u;&A\u0002)bO&tw\rC\u0003`\t\u0001\u0007\u0001-A\u0003pe\u0012,'\u000f\u0005\u0002WC&\u0011!m\u0016\u0002\t\u001fJ$WM]5oO\")A\r\u0002a\u0001K\u0006IAo\\6f]:{G/\u001a\t\u0003M>t!aZ7\u0011\u0005!\\W\"A5\u000b\u0005)4\u0012A\u0002\u001fs_>$hHC\u0001m\u0003\u0015\u00198-\u00197b\u0013\tq7.\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u0014aa\u0015;sS:<'B\u00018l\u0003Q9W\r\u001e+pW\u0016t7OR8s+N,'O\\1nKR)Q\t\u001e<xq\")Q/\u0002a\u0001K\u0006AQo]3s]\u0006lW\rC\u0003U\u000b\u0001\u0007Q\u000bC\u0003`\u000b\u0001\u0007\u0001\rC\u0003e\u000b\u0001\u0007Q-A\thK:,'/\u0019;f+N,'\u000fV8lK:$\"!R>\t\u000bq4\u0001\u0019A?\u0002\u001bU\u001cXM\u001d+pW\u0016tgi\u001c:n!\t1e0\u0003\u0002\u0000\u000f\ni2I]3bi\u0016\u0004VM]:p]\u0006d\u0017iY2fgN$vn[3o\r>\u0014X.\u0001\u0011eK2,G/Z+tKJ$vn[3o\u0005f,6/\u001a:oC6,\u0017I\u001c3DS&#GCBA\u0003\u0003\u001b\ty\u0001\u0005\u0003\u0002\b\u0005%Q\"A6\n\u0007\u0005-1N\u0001\u0003V]&$\b\"B;\b\u0001\u0004)\u0007bBA\t\u000f\u0001\u0007\u00111C\u0001\u0005G&LE\r\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\t1\fgn\u001a\u0006\u0003\u0003;\tAA[1wC&!\u0011\u0011EA\f\u0005\u001dIe\u000e^3hKJ\fQ\u0003Z3mKR,Wk]3s)>\\WM\u001c\"z\u0007&LE\r\u0006\u0003\u0002\u0006\u0005\u001d\u0002bBA\t\u0011\u0001\u0007\u00111\u0003\u0015\u0004\u0001\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005ER(\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!\u000e\u00020\tQ1i\u001c8ue>dG.\u001a:")
public class XldUserTokenServiceImpl
extends AbstractUserRestrictedResource
implements XldUserTokenService {
    private final UserTokenService userTokenService;
    private final UserService userService;

    public UserTokensView getUserTokens(Paging paging, Ordering order, String tokenNote) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        XldUserToken userTokens = this.userTokenService.listUserTokenByUserName(authentication.getName(), paging, order, tokenNote);
        if (userTokens == null) {
            return new UserTokensView(authentication.getName(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        }
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenView((Tokens)tokens))).asJava());
    }

    public UserTokensView getTokensForUsername(String username, Paging paging, Ordering order, String tokenNote) {
        this.checkCurrentUserOrPermissions(username, (scala.collection.immutable.Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{PlatformPermissions.ADMIN}));
        XldUserToken userTokens = this.userTokenService.listUserTokenByUserName(username, paging, order, tokenNote);
        if (userTokens == null) {
            return new UserTokensView(username, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        }
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenView((Tokens)tokens))).asJava());
    }

    public UserTokensView generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        try {
            this.userService.read(username);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("Token generation is disabled for LDAP/OIDC user", new Object[0]);
        }
        Checks.checkArgument((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(userTokenForm.tokenNote())), (String)"Note can't be blank", (Object[])new Object[0]);
        Checks.checkArgument((userTokenForm.expiryDate() == null || userTokenForm.expiryDate().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.tokenNote().trim();
        userTokenForm.tokenNote_$eq(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        XldUserToken xldUserToken = this.userTokenService.listUserTokenByUserName(username, null, null, null);
        Checks.checkArgument((!xldUserToken.tokens().exists((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)XldUserTokenServiceImpl.$anonfun$generateUserToken$1(userTokenForm, token))) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
        XldUserToken userTokens = this.userTokenService.createUserToken(username, userTokenForm.tokenNote(), userTokenForm.expiryDate());
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenViewForCreateToken((Tokens)tokens))).asJava());
    }

    public void deleteUserTokenByUsernameAndCiId(String username, Integer ciId) {
        this.checkCurrentUserOrPermissions(username, (scala.collection.immutable.Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{PlatformPermissions.ADMIN}));
        this.userTokenService.deleteUserToken(username, ciId);
    }

    public void deleteUserTokenByCiId(Integer ciId) {
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        XldUserToken xldUserToken = this.userTokenService.listUserTokenByUserName(username, null, null, null);
        if (xldUserToken.tokens().exists((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)XldUserTokenServiceImpl.$anonfun$deleteUserTokenByCiId$1(ciId, token)))) {
            this.userTokenService.deleteUserToken(username, ciId);
            return;
        }
        throw new Checks.IncorrectArgumentException("Personal access token ciId[" + ciId + "] does not belong to user[" + username + "]", new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$generateUserToken$1(CreatePersonalAccessTokenForm userTokenForm$1, Tokens token) {
        String string = token.tokenNote();
        String string2 = userTokenForm$1.tokenNote();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deleteUserTokenByCiId$1(Integer ciId$1, Tokens token) {
        Integer n = token.ciId();
        Integer n2 = ciId$1;
        return !(n != null ? !((Object)n).equals(n2) : n2 != null);
    }

    @Autowired
    public XldUserTokenServiceImpl(UserTokenService userTokenService, UserService userService) {
        this.userTokenService = userTokenService;
        this.userService = userService;
    }
}

