/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.core.common.security.permission.DeployitPermissions;
import ai.digital.deploy.tasker.common.TaskType;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.util.TaskFilterUtils;
import com.xebialabs.deployit.core.util.TypeConversions;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.report.AppEnvStatusReport;
import com.xebialabs.deployit.engine.api.dto.report.DeploymentsStatusOverview;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.TaskKind;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.report.audit.AuditPreviewReport;
import com.xebialabs.deployit.report.audit.AuditReportRepository;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.task.archive.AppEnvPair;
import com.xebialabs.deployit.task.archive.AppEnvStatusReportLine;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.ControlTask;
import com.xebialabs.deployit.task.archive.DeploymentResult;
import com.xebialabs.deployit.task.archive.DeploymentTask;
import com.xebialabs.deployit.task.archive.StatusOverviewReportLine;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.sql.CachingTaskReader;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedControlTasks;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedTasks;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedTasksShared;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportGenerator
extends AbstractSecuredResource {
    private static final Logger log = LoggerFactory.getLogger(ReportGenerator.class);
    private static final Function<ArchivedTask, TaskWithBlock> castToTaskWithBlock = input -> input;
    private final TaskArchive taskArchive;
    private final AuditReportRepository sqlAuditReportRepository;
    private final RoleService roleService;
    public static final Set<String> DEPLOYMENT_ALLOWED_SORT_FIELDS = new HashSet<String>(Arrays.asList("id", "failures", "owner", "state", "startDate", "completionDate", "application", "environment_id", "taskType", "worker_name"));
    public static final Set<String> CONTROL_ALLOWED_SORT_FIELDS = new HashSet<String>(Arrays.asList("id", "failures", "owner", "state", "startDate", "completionDate", "description", "controlTaskTargetCI", "taskName", "worker_name"));
    public static final EnumSet<TaskType> ALLOWED_TASK_TYPE_FILTER_VALUES = EnumSet.of(TaskType.INITIAL, new TaskType[]{TaskType.UPGRADE, TaskType.UNDEPLOY, TaskType.ROLLBACK, TaskType.INSPECTION, TaskType.CONTROL});

    @Autowired
    public ReportGenerator(TaskArchive taskArchive, AuditReportRepository sqlAuditReportRepository, RoleService roleService) {
        this.taskArchive = taskArchive;
        this.sqlAuditReportRepository = sqlAuditReportRepository;
        this.roleService = roleService;
    }

    public ArchivedTaskSearchParameters buildFilteredTaskSearchParameters(Date begin, Date end, Paging paging, List<Ordering> order, String filterType, List<String> users, List<String> taskStates, List<String> taskTypes, FetchMode fetchMode, String taskId, List<ConfigurationItemId> configurationItemIds, Set<String> allowedSortFields, boolean onlySuccessful, String workerName) {
        FilterType filter;
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        EnumSet<TaskType> types = EnumSet.noneOf(TaskType.class);
        types.addAll(TaskFilterUtils.buildTaskTypesFilter(taskTypes, onlySuccessful));
        TaskFilterUtils.validateTaskTypesFilter(types, ALLOWED_TASK_TYPE_FILTER_VALUES);
        ArchivedTaskSearchParameters searchParameters = this.buildTaskSearchParameters(paging, order, types, allowedSortFields);
        searchParameters.createdBetween(begin.asDateTime(), end.asDateTime());
        searchParameters.forSuccessfulOnly(onlySuccessful);
        searchParameters.withFetchMode(fetchMode);
        searchParameters.withUniqueId(taskId);
        searchParameters.withWorkerName(workerName);
        if (filterType != null && (filter = FilterType.valueOf((String)filterType.toUpperCase())) != FilterType.NONE) {
            searchParameters.forFilterType(filter, configurationItemIds);
        }
        if (!users.isEmpty()) {
            searchParameters.forUsers((Set)Sets.newHashSet(users));
        }
        if (!taskStates.isEmpty()) {
            searchParameters.withTaskStates(taskStates);
        }
        if (this.shouldApplyReadPermission()) {
            searchParameters.applySecurityParameters(this.taskArchive.getReferences());
        }
        return searchParameters;
    }

    private boolean shouldApplyReadPermission() {
        return !PermissionHelper.isCurrentUserAdmin() && !this.roleService.isReadOnlyAdmin();
    }

    public ArchivedTaskSearchParameters buildTaskSearchParameters(Paging paging, List<Ordering> order, EnumSet<TaskType> taskTypes, Set<String> allowedSortFields) {
        paging.validate();
        for (Ordering ordering : order) {
            ordering.validate(allowedSortFields);
        }
        ArchivedTaskSearchParameters searchParameters = new ArchivedTaskSearchParameters();
        searchParameters.thatAreOfType(taskTypes);
        if (order.isEmpty()) {
            searchParameters.orderBy("startDate", false);
        } else {
            for (Ordering ordering : order) {
                searchParameters.orderBy(ordering.field(), ordering.isAscending());
            }
        }
        if (this.shouldApplyReadPermission()) {
            searchParameters.applySecurityParameters(this.taskArchive.getReferences());
        }
        searchParameters.showPage(paging.page(), paging.resultsPerPage());
        return searchParameters;
    }

    public Stream<DeploymentTaskReportLine> streamTaskReport(ArchivedTaskSearchParameters searchParameters) {
        this.checkPermission(DeployitPermissions.REPORT_VIEW());
        return this.taskArchive.searchForMaps(searchParameters, true).map(this::asDeploymentTaskReportLine);
    }

    public Stream<ControlTaskReportLine> streamControlTasksReport(ArchivedTaskSearchParameters searchParameters) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return this.taskArchive.searchForMaps(searchParameters, true).map(this::asControlTaskReportLine);
    }

    public Map<Integer, List<String>> getEnvironments() {
        this.checkPermission(DeployitPermissions.REPORT_VIEW());
        return this.taskArchive.getAllArchivedEnvironmentsWithIds();
    }

    public Map<Integer, List<String>> getApplications() {
        this.checkPermission(DeployitPermissions.REPORT_VIEW());
        return this.taskArchive.getAllArchivedApplicationsWithIds();
    }

    private DeploymentTaskReportLine asDeploymentTaskReportLine(Map<String, Object> map) {
        DeploymentTaskReportLine line = new DeploymentTaskReportLine();
        line.setTaskId((String)map.get(ArchivedTasksShared.task_id().name()));
        line.setStartDate((DateTime)map.get(ArchivedTasksShared.start_date().name()));
        line.setCompletionDate((DateTime)map.get(ArchivedDeploymentTasks.end_date().name()));
        line.setStatus((String)map.get(ArchivedDeploymentTasks.status().name()));
        String taskTypeFromEntity = (String)map.get(ArchivedDeploymentTasks.task_type().name());
        log.debug("DepTaskRep: original task type from entity {}", (Object)taskTypeFromEntity);
        TaskType taskTypeFound = this.getTaskType(taskTypeFromEntity);
        line.setOriginalTaskType(taskTypeFound.getDescription());
        line.setTaskType(this.transformTaskTypeForReport(taskTypeFound));
        log.debug("DepTaskRep: originalTaskType {}", (Object)line.getOriginalTaskType());
        log.debug("DepTaskRep: taskTypeForReport {}", (Object)line.getTaskType());
        line.setUser((String)map.get(ArchivedDeploymentTasks.owner().name()));
        String environment = (String)map.get(ArchivedDeploymentTasks.environment().name());
        line.setEnvironment(environment.substring(environment.lastIndexOf(47) + 1));
        line.setEnvironmentId(environment);
        line.setEnvironmentIdWithoutRoot(environment.substring(environment.indexOf(47) + 1));
        line.setDeploymentPackage((String)map.get(ArchivedDeploymentTasks.packages().name()));
        line.setRolledBack(TypeConversions.enforceBoolean((Object)map.get(ArchivedDeploymentTasks.rolled_back().name())));
        if (map.containsKey(ArchivedTasks.task_details().name())) {
            CachingTaskReader reader = new CachingTaskReader((Reader)new StringReader((String)map.get(ArchivedTasks.task_details().name())));
            line.setBlock(reader.withoutSteps().getBlock());
        }
        line.setWorkerName((String)map.get(ArchivedTasks.worker_name().name()));
        return line;
    }

    private ControlTaskReportLine asControlTaskReportLine(Map<String, Object> map) {
        ControlTaskReportLine line = new ControlTaskReportLine();
        line.setTaskId((String)map.get(ArchivedControlTasks.task_id().name()));
        line.setStarted((DateTime)map.get(ArchivedControlTasks.start_date().name()));
        line.setFinished((DateTime)map.get(ArchivedControlTasks.end_date().name()));
        line.setState((String)map.get(ArchivedControlTasks.status().name()));
        line.setOwner((String)map.get(ArchivedControlTasks.owner().name()));
        line.setTaskName((String)map.get(ArchivedControlTasks.control_task_name().name()));
        line.setControlTaskTargetCI((String)map.get(ArchivedControlTasks.target_ci().name()));
        line.setDescription((String)map.get(ArchivedControlTasks.description().name()));
        if (map.containsKey(ArchivedTasks.task_details().name())) {
            CachingTaskReader reader = new CachingTaskReader((Reader)new StringReader((String)map.get(ArchivedTasks.task_details().name())));
            line.setBlock(reader.withoutSteps().getBlock());
        }
        line.setWorkerName((String)map.get(ArchivedTasks.worker_name().name()));
        return line;
    }

    public DateTime safeDateTime(Date date, DateTime defaultValue) {
        return date == null ? defaultValue : date.asDateTime();
    }

    public String buildControlTaskReportFileName(Date begin, Date end) {
        DateTime theBeginningOfTime = new DateTime(1, 1, 1, 0, 0, 0);
        DateTime beginDT = this.safeDateTime(begin, theBeginningOfTime);
        DateTime endDT = this.safeDateTime(end, new DateTime());
        return String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)beginDT), ReportUtils.DATE_FORMAT.print((ReadableInstant)endDT));
    }

    public String generateAuditReport(List<String> folders, DownloadResource downloadResource) {
        this.checkPermission(DeployitPermissions.REPORT_VIEW());
        List globalAuditReport = this.sqlAuditReportRepository.getGlobalAuditReport();
        List folderAuditReport = this.sqlAuditReportRepository.getAuditReport(folders);
        return ReportUtils.createAuditReport(downloadResource, globalAuditReport, folderAuditReport);
    }

    public String generateDeploymentsDashboardReport(Date begin, Date end, DownloadResource downloadResource) {
        this.checkPermission(DeployitPermissions.REPORT_VIEW());
        this.checkBeginEndArgs(begin, end);
        DateTime beginDateTime = new DateTime((Object)begin.toString());
        DateTime endDateTime = new DateTime((Object)end.toString());
        Collection dashboardReport = this.taskArchive.statusOverview(beginDateTime, endDateTime);
        Collection deploymentReport = this.taskArchive.statusOverviewData(beginDateTime, endDateTime);
        return ReportUtils.createDeploymentsDashboardReport(beginDateTime, endDateTime, dashboardReport, deploymentReport, downloadResource);
    }

    public AuditPreviewReport previewAuditReport(List<String> folders, List<Ordering> order, Paging paging) {
        this.checkPermission(DeployitPermissions.REPORT_VIEW());
        return this.sqlAuditReportRepository.previewAuditReport(folders, order, paging);
    }

    public DeploymentsStatusOverview buildStatusOverview(Date begin, Date end) {
        this.checkBeginEndArgs(begin, end);
        Collection searchResult = this.taskArchive.statusOverview(begin.asDateTime(), end.asDateTime());
        return this.transformStatusOverviewReportLine(searchResult);
    }

    private void checkBeginEndArgs(Date begin, Date end) {
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkArgument((begin.getCalendar().getTime().compareTo(end.getCalendar().getTime()) <= 0 ? 1 : 0) != 0, (String)"Begin time must be before end time.", (Object[])new Object[0]);
    }

    private DeploymentsStatusOverview transformStatusOverviewReportLine(Collection<StatusOverviewReportLine> searchResult) {
        return new DeploymentsStatusOverview(this.getStatusAmount(searchResult, DeploymentResult.SUCCESS), this.getStatusAmount(searchResult, DeploymentResult.FAILED), this.getStatusAmount(searchResult, DeploymentResult.ABORTED), this.getStatusAmount(searchResult, DeploymentResult.ROLLBACK), this.getStatusAmount(searchResult, DeploymentResult.TOTAL));
    }

    private int getStatusAmount(Collection<StatusOverviewReportLine> searchResult, DeploymentResult status) {
        if (searchResult.isEmpty()) {
            return 0;
        }
        return searchResult.stream().filter(sr -> sr.executionState().equals(status.name())).map(StatusOverviewReportLine::amount).findFirst().orElse(0);
    }

    public List<AppEnvStatusReport> buildAppEnvStatusReport(Date begin, Date end) {
        this.checkBeginEndArgs(begin, end);
        Collection searchResult = this.taskArchive.appEnvStatus(begin.asDateTime(), end.asDateTime());
        ArrayList<AppEnvStatusReport> reportList = new ArrayList<AppEnvStatusReport>();
        Map<AppEnvPair, Map<String, Integer>> searchResultGroupedByAppEnvDeployResult = searchResult.stream().collect(Collectors.groupingBy(line -> new AppEnvPair(line.application(), line.environment()), Collectors.groupingBy(AppEnvStatusReportLine::executionState, Collectors.summingInt(AppEnvStatusReportLine::amount))));
        searchResultGroupedByAppEnvDeployResult.keySet().forEach(appEnvPair -> {
            Map pairLines = (Map)searchResultGroupedByAppEnvDeployResult.get(appEnvPair);
            reportList.add(new AppEnvStatusReport(appEnvPair.application(), appEnvPair.environment(), new DeploymentsStatusOverview(pairLines.getOrDefault(DeploymentResult.SUCCESS.name(), 0).intValue(), pairLines.getOrDefault(DeploymentResult.FAILED.name(), 0).intValue(), pairLines.getOrDefault(DeploymentResult.ABORTED.name(), 0).intValue(), pairLines.getOrDefault(DeploymentResult.ROLLBACK.name(), 0).intValue(), pairLines.getOrDefault(DeploymentResult.TOTAL.name(), 0).intValue())));
        });
        return reportList;
    }

    public ArchivedTaskSearchParameters buildQueryByArchivedDateParameters(Date begin, Date end, String order, TaskKind taskType) {
        Checks.checkTrue((begin != null || end != null ? 1 : 0) != 0, (String)"Either begin date or end date is mandatory", (Object[])new Object[]{"[begin, end]"});
        ArchivedTaskSearchParameters searchParameters = new ArchivedTaskSearchParameters();
        searchParameters.setFilterByArchivedDate(true);
        searchParameters.inDateTimeRange(this.safeDateTime(begin, null), this.safeDateTime(end, null));
        boolean ascending = order == null || !order.equalsIgnoreCase("DESC");
        searchParameters.orderBy("archivedDate", ascending);
        if (taskType == TaskKind.DEPLOYMENT) {
            searchParameters.thatAreOfType((Set)DeploymentTask.DEPLOYMENT_TASK_TYPES());
        } else if (taskType == TaskKind.CONTROL_TASK) {
            searchParameters.thatAreOfType((Set)ControlTask.CONTROL_TASK_TYPES());
        }
        return searchParameters;
    }

    public Stream<TaskWithBlock> queryByArchivedDate(ArchivedTaskSearchParameters searchParameters, FetchMode fetchMode) {
        return this.taskArchive.searchForTasks(searchParameters, true).map(taskReader -> {
            if (Objects.equals(fetchMode, FetchMode.FULL)) {
                return taskReader.withoutSteps();
            }
            return taskReader.withoutBlocks();
        }).map(castToTaskWithBlock);
    }

    private TaskType getTaskType(String taskType) {
        if (taskType == null || taskType.isEmpty()) {
            log.debug("DepTaskRep: original task type mapped unknown for {}", (Object)taskType);
            return TaskType.DEFAULT;
        }
        try {
            return TaskType.valueOf((String)taskType);
        }
        catch (IllegalArgumentException e) {
            log.debug("DepTaskRep: original task type mapped unknown for {}", (Object)taskType, (Object)e);
            return TaskType.DEFAULT;
        }
    }

    private String transformTaskTypeForReport(TaskType taskType) {
        switch (taskType) {
            case INITIAL: {
                return "Initial";
            }
            case UPGRADE: {
                return "Update";
            }
            case UNDEPLOY: {
                return "Undeployment";
            }
            case ROLLBACK: {
                return "Rollback";
            }
        }
        return "Unknown";
    }
}

