package com.xebialabs.deployit.core.converters

import ai.digital.deploy.sql.model.ReportLine
import DeploymentReportLineField.{COMPLETION_DATE, ENVIRONMENT, ENVIRONMENT_ID, ENVIRONMENT_ID_WITHOUT_ROOT, ORIGINAL_TYPE, PACKAGE, ROLLED_BACK, START_DATE, STATUS, TASK_ID, TYPE, USER, WORKER_NAME}
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine

import scala.collection.mutable
import scala.jdk.CollectionConverters._

object DeploymentTaskReportLineConverter {
  def toReportLine(line: DeploymentTaskReportLine): ReportLine = ReportLine.fromMap(mutable.Map(Map[String, Object](
    TASK_ID -> line.getTaskId,
    START_DATE -> line.getStartDate,
    COMPLETION_DATE -> line.getCompletionDate,
    STATUS -> line.getStatus,
    TYPE -> line.getTaskType,
    ORIGINAL_TYPE -> line.getOriginalTaskType,
    USER -> line.getUser,
    ENVIRONMENT -> line.getEnvironment,
    ENVIRONMENT_ID -> line.getEnvironmentId,
    ENVIRONMENT_ID_WITHOUT_ROOT -> line.getEnvironmentIdWithoutRoot,
    PACKAGE -> line.getDeploymentPackage,
    ROLLED_BACK -> line.getRolledBack,
    WORKER_NAME -> line.getWorkerName
  ).toSeq: _*).asJava)
}

object DeploymentReportLineField {
  val TASK_ID = "taskId"
  val START_DATE = "startDate"
  val COMPLETION_DATE = "completionDate"
  val STATUS = "status"
  val TYPE = "type"
  val ORIGINAL_TYPE = "originalType"
  val USER = "user"
  val ENVIRONMENT = "environment"
  val ENVIRONMENT_ID = "environmentId"
  val ENVIRONMENT_ID_WITHOUT_ROOT = "environmentIdWithoutRoot"
  val PACKAGE = "package"
  val ROLLED_BACK = "rolledBack"
  val WORKER_NAME = "worker_name"

  private lazy val headerWithDesc: Map[String, String] = Map(
    TASK_ID -> TASK_ID,
    START_DATE -> START_DATE,
    COMPLETION_DATE -> COMPLETION_DATE,
    STATUS -> STATUS,
    TYPE -> TYPE,
    ORIGINAL_TYPE -> TYPE,
    USER -> USER,
    ENVIRONMENT -> ENVIRONMENT,
    ENVIRONMENT_ID -> ENVIRONMENT_ID,
    ENVIRONMENT_ID_WITHOUT_ROOT -> ENVIRONMENT_ID_WITHOUT_ROOT,
    PACKAGE -> PACKAGE,
    ROLLED_BACK -> ROLLED_BACK,
    WORKER_NAME -> WORKER_NAME
  )

  def getHeadersWithDescAsJava: java.util.Map[String, String] = {
    lazy val javaMap = headerWithDesc.asJava
    javaMap
  }

  val allFields: Set[String] = Set(TASK_ID, START_DATE, COMPLETION_DATE, STATUS, ORIGINAL_TYPE, USER, ENVIRONMENT, ENVIRONMENT_ID, ENVIRONMENT_ID_WITHOUT_ROOT, PACKAGE, ROLLED_BACK, WORKER_NAME)

}
