package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.engine.api.execution.*;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.log.StepLogRetriever;
import org.joda.time.DateTime;

import java.util.List;
import java.util.Map;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

public class TaskWithStepsView implements TaskWithSteps {
    private TaskWithSteps wrapped;
    private StepLogRetriever stepLogRetriever;

    public TaskWithStepsView(SerializableTask wrapped) {
        checkArgument(wrapped instanceof TaskWithSteps, "Should be a TaskWithSteps, but was a %s", wrapped.getClass());
        this.wrapped = (TaskWithSteps) wrapped;
    }

    public TaskWithStepsView(SerializableTask wrapped, StepLogRetriever stepLogRetriever) {
        this(wrapped);
        this.stepLogRetriever = stepLogRetriever;
    }

    @Override
    public TaskExecutionState getState() {
        return wrapped.getState();
    }

    @Override
    public String getId() {
        return wrapped.getId();
    }

    @Override
    public String getDescription() {
        return wrapped.getDescription();
    }

    @Override
    public DateTime getScheduledDate() {
        return wrapped.getScheduledDate();
    }

    @Override
    public DateTime getStartDate() {
        return wrapped.getStartDate();
    }

    @Override
    public DateTime getCompletionDate() {
        return wrapped.getCompletionDate();
    }

    @Override
    public int getNrSteps() {
        return wrapped.getNrSteps();
    }

    @Override
    public int getCurrentStepNr() {
        return wrapped.getCurrentStepNr();
    }

    @Override
    public List<Integer> getCurrentStepNrs() {
        return wrapped.getCurrentStepNrs();
    }

    @Override
    public Map<String, String> getMetadata() {
        return wrapped.getMetadata();
    }

    @Override
    public int getFailureCount() {
        return wrapped.getFailureCount();
    }

    @Override
    public String getOwner() {
        return wrapped.getOwner();
    }

    @Override
    public List<StepState> getSteps() {
        if (stepLogRetriever != null && wrapped instanceof Task) {
            return ((Task) wrapped).getSteps((BlockPath b, StepState s) -> stepLogRetriever.retrieveLogs(wrapped.getId(), b, s));
        } else {
            return wrapped.getSteps();
        }
    }

    @Override
    public StepState getStep(final int nr) {
        if (stepLogRetriever != null && wrapped instanceof Task) {
            return ((Task) wrapped).getStep(nr, (BlockPath b, StepState s) -> stepLogRetriever.retrieveLogs(wrapped.getId(), b, s));
        } else {
            return wrapped.getStep(nr);
        }
    }

    @Override
    public Integer getWorkerId() {
        return wrapped.getWorkerId();
    }

    @Override
    public List<TaskPackageDependency> getPackageDependencies() {
        return wrapped.getPackageDependencies();
    }
}
