/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.core.rest.json.MethodDescriptorJsonWriter;
import com.xebialabs.deployit.core.rest.json.PropertyDescriptorJsonWriter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DescriptorJsonWriter
implements MessageBodyWriter<Descriptor> {
    public boolean isWriteable(Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Descriptor.class.isAssignableFrom(type);
    }

    public long getSize(Descriptor descriptor, Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Descriptor descriptor, Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(descriptor).getBytes());
    }

    @VisibleForTesting
    String toJson(Descriptor descriptor) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        this.writeJson(descriptor, writer);
        return stringWriter.toString();
    }

    public void writeJson(Descriptor descriptor, JsonWriter writer) {
        writer.object();
        writer.key("type").value((Object)descriptor.getType().toString());
        if (descriptor.getDeployableType() != null) {
            writer.key("deployableType").value((Object)descriptor.getDeployableType().toString());
        }
        if (descriptor.getContainerType() != null) {
            writer.key("containerType").value((Object)descriptor.getContainerType().toString());
        }
        writer.key("virtual").value(descriptor.isVirtual());
        if (descriptor.getIcon() != null) {
            writer.key("icon").value((Object)descriptor.getIcon());
        }
        if (descriptor.getRootName() != null && !descriptor.getRootName().isEmpty()) {
            writer.key("root").value((Object)descriptor.getRootName());
        }
        writer.key("description").value((Object)descriptor.getDescription());
        DescriptorJsonWriter.writePropertyDescriptors(writer, descriptor);
        this.writeIntefaces(writer, descriptor);
        this.writeSuperClasses(writer, descriptor);
        this.writeControlTasks(descriptor, writer);
        writer.endObject();
    }

    private void writeControlTasks(Descriptor descriptor, JsonWriter writer) {
        if (!CollectionUtils.isEmpty((Collection)descriptor.getControlTasks())) {
            writer.key("control-tasks");
            writer.array();
            for (MethodDescriptor controlTask : descriptor.getControlTasks()) {
                MethodDescriptorJsonWriter.writeJson(controlTask, writer);
            }
            writer.endArray();
        }
    }

    private void writeSuperClasses(JsonWriter writer, Descriptor descriptor) {
        List superTypes = descriptor.getSuperClasses();
        writer.key("superTypes");
        writer.array();
        for (Type type : superTypes) {
            writer.value((Object)type.toString());
        }
        writer.endArray();
    }

    private void writeIntefaces(JsonWriter writer, Descriptor descriptor) {
        Set interfaces = descriptor.getInterfaces();
        writer.key("interfaces");
        writer.array();
        for (Type type : interfaces) {
            writer.value((Object)type.toString());
        }
        writer.endArray();
    }

    private static void writePropertyDescriptors(JsonWriter writer, Descriptor descriptor) {
        writer.key("properties");
        writer.array();
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            PropertyDescriptorJsonWriter.writePropertyDescriptor(writer, pd);
        }
        writer.endArray();
    }
}

