/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.Mappings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.core.api.DeploymentProxy;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import com.xebialabs.deployit.core.api.dto.Steps;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.validation.ValidationMessage;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.task.ExecutionEngine;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemDescriptorRepositoryHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DeploymentResource
extends AbstractSecuredResource
implements DeploymentProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private DtoConverter dtoConverter;
    @Autowired
    private ExecutionEngine engine;
    @Autowired
    private Validator validator;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResource.class);

    public Response generateMappings(String sourceId, String targetId) {
        ConfigurationItemEntity source = (ConfigurationItemEntity)this.repositoryService.readFully(sourceId);
        ConfigurationItemEntity target = targetId != null ? (ConfigurationItemEntity)this.repositoryService.readFully(targetId) : null;
        DeploymentType type = this.determineType(source, target);
        Mappings mappings = new Mappings();
        if (type == DeploymentType.INITIAL) {
            logger.info("Initial deployment of {} to {}", (Object)sourceId, (Object)targetId);
            mappings = this.deploymentService.generateDefaultMappings(source, target);
            return ResponseFactory.status((Response.Status)Response.Status.CREATED).entity((Object)this.dtoConverter.toDto(mappings)).build();
        }
        if (type == DeploymentType.UPGRADE) {
            logger.info("Upgrade deployment of {} to {}", (Object)sourceId, (Object)targetId);
            mappings = this.deploymentService.generateMappingsForUpgradeDeployment(source, target);
        } else if (type != DeploymentType.UNDEPLOYMENT) {
            throw new Checks.IncorrectArgumentException("Can't generate mappings for deployment type %s", new Object[]{type});
        }
        return ResponseFactory.status((Response.Status)Response.Status.CREATED).entity((Object)this.dtoConverter.toDto(mappings)).build();
    }

    public Response generatePartialMappings(List<String> partialSourceIds, String targetId, String mappingType) {
        Checks.checkArgument((partialSourceIds.size() > 0 ? 1 : 0) != 0, (String)"Should have at least on source to generate mappings for.", (Object[])new Object[0]);
        String deploymentPackageId = null;
        ArrayList sourceCIs = Lists.newArrayList();
        for (String id : partialSourceIds) {
            sourceCIs.add((ConfigurationItemEntity)this.repositoryService.readFully(id));
            String thisDeploymentPackageId = JcrPathHelper.getParentId((String)id);
            if (deploymentPackageId == null) {
                deploymentPackageId = thisDeploymentPackageId;
                continue;
            }
            Checks.checkArgument((boolean)StringUtils.equals((String)deploymentPackageId, (String)deploymentPackageId), (String)"All sources should be from same package", (Object[])new Object[0]);
        }
        ConfigurationItemEntity deploymentPackage = (ConfigurationItemEntity)this.repositoryService.readFully(deploymentPackageId);
        ConfigurationItemEntity target = (ConfigurationItemEntity)this.repositoryService.readFully(targetId);
        DeploymentType type = this.determineType((ConfigurationItemEntity)sourceCIs.get(0), target);
        if (type == DeploymentType.INITIAL) {
            return ResponseFactory.created((Object)this.dtoConverter.toDto(this.deploymentService.generatePartialDefaultMappings(deploymentPackage, (List)sourceCIs, target, mappingType))).build();
        }
        throw new Checks.IncorrectArgumentException("Target of partial mappings should be an environment or an environment member.", new Object[0]);
    }

    public Response prepare(String sourceId, String targetId, RepositoryObjects mappings) {
        Task deploymentTask = this.createDeploymentTask(sourceId, targetId, mappings);
        String taskId = this.engine.register(deploymentTask);
        Steps steps = this.dtoConverter.toDto(deploymentTask);
        steps.setTaskId(taskId);
        return ResponseFactory.ok((Object)steps).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response validate(String sourceId, String targetId, RepositoryObjects mappings) {
        if (!this.validateMappingsWithValidator(mappings)) {
            return ResponseFactory.badRequest((Object)mappings).build();
        }
        Task task = this.createDeploymentTask(sourceId, targetId, mappings);
        try {
            List taskSteps = task.getSteps();
            if (taskSteps.isEmpty()) {
                throw new InvalidMappingsException("The mappings did not lead to any steps, no action will be taken.");
            }
        }
        finally {
            task.destroy();
        }
        return ResponseFactory.noContent().build();
    }

    private Task createDeploymentTask(String sourceId, String targetId, RepositoryObjects mappings) {
        ConfigurationItemEntity source = (ConfigurationItemEntity)this.repositoryService.readFully(sourceId);
        ConfigurationItemEntity target = targetId != null ? (ConfigurationItemEntity)this.repositoryService.readFully(targetId) : null;
        DeploymentType type = this.determineType(source, target);
        this.checkPermissions(source, target, type);
        Task deploymentTask = null;
        if (type == DeploymentType.INITIAL) {
            Collection mappingEntities = this.dtoConverter.fromDto(mappings);
            deploymentTask = this.deploymentService.prepareInitialDeployment(source, target, mappingEntities);
        } else if (type == DeploymentType.UPGRADE) {
            Collection mappingEntities = this.dtoConverter.fromDto(mappings);
            deploymentTask = this.deploymentService.prepareUpgradeDeployment(source, target, mappingEntities);
        } else if (type == DeploymentType.UNDEPLOYMENT) {
            deploymentTask = this.deploymentService.prepareUndeployment(source);
        } else {
            throw new UnsupportedOperationException("type " + (Object)((Object)type) + " is not supported yet.");
        }
        return deploymentTask;
    }

    private void checkPermissions(ConfigurationItemEntity source, ConfigurationItemEntity target, DeploymentType type) {
        switch (type) {
            case INITIAL: {
                this.checkPermission(Permission.DEPLOY_INITIAL, Lists.newArrayList((Object[])new String[]{target.getId()}));
                break;
            }
            case UPGRADE: {
                this.checkPermission(Permission.DEPLOY_UPGRADE, Lists.newArrayList((Object[])new String[]{(String)target.getValue("target")}));
                break;
            }
            case UNDEPLOYMENT: {
                this.checkPermission(Permission.UNDEPLOY, Lists.newArrayList((Object[])new String[]{(String)source.getValue("target")}));
                break;
            }
            default: {
                throw new IllegalStateException("Cannot do deployment of unknown type.");
            }
        }
    }

    private boolean validateMappingsWithValidator(RepositoryObjects mappings) {
        boolean allValid = true;
        for (RepositoryObject mapping : mappings.getObjects()) {
            RepositoryObjectEntity mappingEntity = this.dtoConverter.fromDto(mapping);
            Validator.Validations validations = this.validator.validate(mappingEntity, new RepositoryObjectEntity[0]);
            if (!validations.hasMessages()) continue;
            mapping.setValidations(this.dtoConverter.toDto((List<ValidationMessage>)validations));
            allValid = false;
        }
        return allValid;
    }

    private DeploymentType determineType(ConfigurationItemEntity source, ConfigurationItemEntity target) {
        String sourceType = source.getConfigurationItemTypeName();
        ConfigurationItemDescriptor sourceDescriptor = ConfigurationItemDescriptorRepositoryHolder.getDescriptor((String)sourceType);
        if (this.isAssignable(sourceDescriptor, Deployment.class) && target == null) {
            return DeploymentType.UNDEPLOYMENT;
        }
        if (target == null) {
            throw new Checks.IncorrectArgumentException("A target should be given unless it is an undeployment.", new Object[0]);
        }
        String targetType = target.getConfigurationItemTypeName();
        ConfigurationItemDescriptor targetDescriptor = ConfigurationItemDescriptorRepositoryHolder.getDescriptor((String)targetType);
        if (this.isAssignable(targetDescriptor, Deployment.class)) {
            return DeploymentType.UPGRADE;
        }
        return DeploymentType.INITIAL;
    }

    private boolean isAssignable(ConfigurationItemDescriptor desc, Class<?> clazz) {
        return clazz.isAssignableFrom(desc.getTypeClass());
    }

    @HttpResponseCodeResult(statusCode=406)
    private class InvalidMappingsException
    extends DeployitException {
        public InvalidMappingsException(String s) {
            super(s);
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class DeploymentException
    extends DeployitException {
        public DeploymentException(String messageTemplate, Object ... params) {
            super(messageTemplate, params);
        }
    }

    static enum DeploymentType {
        INITIAL,
        UPGRADE,
        UNDEPLOYMENT;

    }
}

