/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskRegistry;
import com.xebialabs.deployit.task.labelparser.InitialDeploymentTaskLabelParser;
import com.xebialabs.deployit.task.labelparser.UndeploymentTaskLabelParser;
import com.xebialabs.deployit.task.labelparser.UpgradeTaskLabelParser;
import java.util.Calendar;
import java.util.Collection;

public class TasksInDateRangeReport {
    private TaskRegistry taskRegistry;

    public TasksInDateRangeReport(TaskRegistry taskRegistry) {
        this.taskRegistry = taskRegistry;
    }

    public Report report(final Date begin, final Date end) {
        Collection tasksInRange = Collections2.filter((Collection)this.taskRegistry.getAllArchivedTasks(), (Predicate)new Predicate<Task>(){

            public boolean apply(Task input) {
                boolean isValidState;
                Calendar completionDate = input.getCompletionDate();
                Task.State state = input.getState();
                boolean bl = isValidState = state.equals((Object)Task.State.DONE) || state.equals((Object)Task.State.CANCELLED);
                if (!isValidState || !input.isDeploymentTask() || completionDate == null) {
                    return false;
                }
                boolean isAfterBegin = completionDate.after(begin.getCalendar());
                boolean isEqualsBegin = completionDate.equals(begin.getCalendar());
                boolean isBeforeEnd = completionDate.before(end.getCalendar());
                return (isAfterBegin || isEqualsBegin) && isBeforeEnd;
            }
        });
        Report report = new Report();
        for (Task task : tasksInRange) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("user", (Object)task.getOwner());
            reportLine.addValue("status", (Object)task.getState().name());
            reportLine.addValue("startDate", (Object)new Date(task.getStartDate(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ").toString());
            reportLine.addValue("completionDate", (Object)new Date(task.getCompletionDate(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ").toString());
            this.fillParsedInfo(reportLine, task.getLabel());
        }
        return report;
    }

    private void fillParsedInfo(Report.ReportLine reportLine, String taskLabel) {
        String taskType = "Unknown";
        InitialDeploymentTaskLabelParser labelParser = null;
        if (taskLabel.startsWith(Task.DEPLOYMENT_PREFIX)) {
            taskType = "Initial";
            labelParser = new InitialDeploymentTaskLabelParser(taskLabel);
        } else if (taskLabel.startsWith(Task.UPGRADE_PREFIX)) {
            taskType = "Upgrade";
            labelParser = new UpgradeTaskLabelParser(taskLabel);
        } else if (taskLabel.startsWith(Task.UNDEPLOYMENT_PREFIX)) {
            taskType = "Undeployment";
            labelParser = new UndeploymentTaskLabelParser(taskLabel);
        }
        if (labelParser != null) {
            String packageId = labelParser.getApplication();
            String enviromentId = labelParser.getEnvironment();
            reportLine.addValue("type", (Object)taskType);
            reportLine.addValue("package", (Object)packageId.substring(packageId.indexOf("/") + 1));
            reportLine.addValue("environment", (Object)enviromentId.substring(enviromentId.indexOf("/") + 1));
        }
    }
}

