/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.ReportProxy;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsForEnvironmentReport;
import com.xebialabs.deployit.core.rest.api.reports.TasksInDateRangeReport;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.task.TaskRegistry;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ReportResource
implements ReportProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaskRegistry taskRegistry;

    public Response deploymentsForEnvironment(String environment, Date date) {
        Checks.checkNotNull((Object)environment, (String)"environment");
        Checks.checkNotNull((Object)date, (String)"date");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"date");
        Report report = new DeploymentsForEnvironmentReport(this.repositoryService, this.taskRegistry).report(environment, date);
        return ResponseFactory.ok((Object)report).build();
    }

    public Response tasksInDateRange(Date begin, Date end) {
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Report report = new TasksInDateRangeReport(this.taskRegistry).report(begin, end);
        return ResponseFactory.ok((Object)report).build();
    }
}

