/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.Artifact;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItem;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyKind;
import com.xebialabs.deployit.core.api.dto.FullTaskInfo;
import com.xebialabs.deployit.core.api.dto.Message;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import com.xebialabs.deployit.core.api.dto.StepInfo;
import com.xebialabs.deployit.core.api.dto.Steps;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfos;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.service.validation.ValidationMessage;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskStepInfo;
import com.xebialabs.deployit.util.PasswordObfuscator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DtoConverter {
    private PojoConverter pojoConverter;

    @Autowired
    public DtoConverter(PojoConverter pojoConverter) {
        this.pojoConverter = pojoConverter;
    }

    public RepositoryObject entityToDto(RepositoryObjectEntity entity) {
        Artifact dto;
        Checks.checkNotNull((Object)entity, (String)"entity");
        Checks.checkNotNull((Object)entity.getId(), (String)"entity.id");
        if (entity instanceof ArtifactEntity) {
            dto = new Artifact();
        } else if (entity instanceof ConfigurationItemEntity) {
            dto = new ConfigurationItem();
        } else {
            throw new IllegalArgumentException("entity is not of class " + ConfigurationItemEntity.class.getName() + " or class " + ArtifactEntity.class.getName());
        }
        dto.setId(entity.getId());
        dto.setType(entity.getType().toString());
        dto.setLastModified(entity.getLastModified());
        dto.setOverrideLastModified(null);
        dto.setCreatingTaskId(entity.getCreatingTaskId());
        if (entity instanceof ArtifactEntity) {
            dto.setFilename(((ArtifactEntity)entity).getFilename());
        }
        this.copyValuesToDto(entity, (RepositoryObject)dto);
        return dto;
    }

    private void copyValuesToDto(RepositoryObjectEntity entity, RepositoryObject dto) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : entity.getValues().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            map.put(key, value);
        }
        dto.setValues((Map)map);
    }

    public RepositoryObjectEntity entityFromDto(RepositoryObject dto) {
        Checks.checkNotNull((Object)dto, (String)"dto");
        Checks.checkNotNull((Object)dto.getId(), (String)"dto.id");
        RepositoryObjectEntity entity = this.createEntity(dto);
        entity.setId(dto.getId());
        entity.setLastModified(null);
        entity.setOverrideLastModified(dto.getOverrideLastModified());
        entity.setCreatingTaskId(null);
        if (entity instanceof ArtifactEntity) {
            ((ArtifactEntity)entity).setFilename(((Artifact)dto).getFilename());
        }
        this.copyValues(dto, entity);
        return entity;
    }

    private void copyValues(RepositoryObject from, RepositoryObjectEntity to) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)to.getType());
        for (String fromKey : from.getValues().keySet()) {
            PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(fromKey);
            Object value = from.getValues().get(fromKey);
            if (propertyDescriptor != null && propertyDescriptor.isPassword()) {
                to.addValue(fromKey, (Object)PasswordObfuscator.ensureEncrypted((String)value.toString()));
                continue;
            }
            to.addValue(fromKey, value);
        }
    }

    private RepositoryObjectEntity createEntity(RepositoryObject dto) {
        ConfigurationItemEntity entity;
        if (dto instanceof Artifact) {
            entity = this.createObjectWithDefaults(dto.getType());
        } else if (dto instanceof ConfigurationItem) {
            entity = this.createObjectWithDefaults(dto.getType());
        } else {
            throw new IllegalArgumentException("Do not know the type " + dto.getClass() + " to create entity for.");
        }
        return entity;
    }

    private ConfigurationItemEntity createObjectWithDefaults(String type) {
        Checks.checkNotNull((Object)type, (String)"dto.type");
        Descriptor descriptor = DescriptorRegistry.getDescriptor((String)type);
        Checks.checkArgument((descriptor != null ? 1 : 0) != 0, (String)(type + " is an unknown type"), (Object[])new Object[0]);
        return this.pojoConverter.toEntity(descriptor.newInstance());
    }

    public ArtifactEntity artifactEntityFromDto(ArtifactAndData dto) {
        Checks.checkNotNull((Object)dto, (String)"dto");
        Checks.checkNotNull((Object)dto.getArtifact(), (String)"dto.artifact");
        Checks.checkNotNull((Object)dto.getArtifact().getId(), (String)"dto.artifact.id");
        Checks.checkNotNull((Object)dto.getData(), (String)"dto.artifact.data");
        ArtifactEntity entity = (ArtifactEntity)this.entityFromDto((RepositoryObject)dto.getArtifact());
        entity.setData(ByteStreams.newInputStreamSupplier((byte[])dto.getData()));
        return entity;
    }

    public RepositoryObjects entitiesToDto(Collection<? extends RepositoryObjectEntity> entities) {
        Checks.checkNotNull(entities, (String)"entities");
        RepositoryObjects objects = new RepositoryObjects();
        for (RepositoryObjectEntity repositoryObjectEntity : entities) {
            objects.add(this.entityToDto(repositoryObjectEntity));
        }
        return objects;
    }

    public List<ConfigurationItem> deployedsToDto(ListMultimap<Boolean, ConfigurationItemEntity> deployeds) {
        Checks.checkNotNull(deployeds, (String)"deployeds");
        ArrayList cis = Lists.newArrayList();
        for (ConfigurationItemEntity validDeployedEntity : deployeds.get((Object)true)) {
            ConfigurationItem validDeployed = (ConfigurationItem)this.entityToDto((RepositoryObjectEntity)validDeployedEntity);
            cis.add(validDeployed);
        }
        for (ConfigurationItemEntity invalidDeployedEntity : deployeds.get((Object)false)) {
            ConfigurationItem invalidDeployed = (ConfigurationItem)this.entityToDto((RepositoryObjectEntity)invalidDeployedEntity);
            ArrayList<Message> validations = new ArrayList<Message>();
            validations.add(new Message("source", "The deployable for this deployed is missing from the package."));
            invalidDeployed.setValidations(validations);
            cis.add(invalidDeployed);
        }
        return cis;
    }

    public <T extends RepositoryObjectEntity> Collection<T> entitiesFromDto(List<? extends RepositoryObject> objects) {
        Checks.checkNotNull(objects, (String)"objects");
        ArrayList entities = Lists.newArrayList();
        for (RepositoryObject repositoryObject : objects) {
            entities.add(this.entityFromDto(repositoryObject));
        }
        return entities;
    }

    public ConfigurationItemDescriptorDto descriptorToDto(Descriptor descriptor) {
        Checks.checkNotNull((Object)descriptor, (String)"descriptor");
        ConfigurationItemDescriptorDto dto = new ConfigurationItemDescriptorDto();
        dto.setType(descriptor.getType().toString());
        dto.setSimpleName(descriptor.getType().toString());
        Function<Type, String> typeToString = new Function<Type, String>(){

            public String apply(Type from) {
                return from.toString();
            }
        };
        dto.setInterfaces((Set)Sets.newHashSet((Iterable)Collections2.transform((Collection)descriptor.getInterfaces(), (Function)typeToString)));
        dto.setSuperClasses((List)Lists.newArrayList((Iterable)Collections2.transform((Collection)descriptor.getSuperClasses(), (Function)typeToString)));
        Type deployableType = descriptor.getDeployableType();
        dto.setMappingSourceType(deployableType != null ? deployableType.toString() : "");
        Type containerType = descriptor.getContainerType();
        dto.setMappingTargetType(containerType != null ? containerType.toString() : "");
        dto.setDescription(descriptor.getDescription());
        dto.setPlaceholderFormatName("");
        dto.setPlaceholdersName("");
        dto.setRootName(descriptor.getRoot().getRootNodeName());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            if (propertyDescriptor.isHidden()) continue;
            dto.addPropertyDescriptor(this.propertyDescriptorToDto(propertyDescriptor));
        }
        return dto;
    }

    public ConfigurationItemPropertyDescriptorDto propertyDescriptorToDto(PropertyDescriptor propertyDescriptor) {
        Type referencedType;
        Checks.checkNotNull((Object)propertyDescriptor, (String)"propertydescriptor");
        ConfigurationItemPropertyDescriptorDto dto = new ConfigurationItemPropertyDescriptorDto();
        dto.setName(propertyDescriptor.getName());
        dto.setLabel(propertyDescriptor.getLabel());
        dto.setType(ConfigurationItemPropertyKind.valueOf((String)propertyDescriptor.getKind().toString()));
        if (propertyDescriptor.getEnumValues() != null) {
            dto.setEnumValues(propertyDescriptor.getEnumValues().toArray(new String[propertyDescriptor.getEnumValues().size()]));
        }
        dto.setCollectionMemberClassname((referencedType = propertyDescriptor.getReferencedType()) != null ? referencedType.toString() : "");
        dto.setPropertyClassname("");
        dto.setRequired(propertyDescriptor.isRequired());
        dto.setEditable(true);
        dto.setPassword(propertyDescriptor.isPassword());
        dto.setIdentifying(false);
        dto.setDiscoveryParam(false);
        dto.setDiscoveryRequired(false);
        dto.setCategory(propertyDescriptor.getCategory());
        dto.setSize(propertyDescriptor.getSize().toString());
        Object defaultValue = propertyDescriptor.getDefaultValue();
        dto.setDefaultValue(defaultValue == null ? null : defaultValue.toString());
        dto.setDescription(propertyDescriptor.getDescription());
        dto.setAsContainment(propertyDescriptor.isAsContainment());
        if (propertyDescriptor.getListDescriptors() != null) {
            for (PropertyDescriptor each : propertyDescriptor.getListDescriptors()) {
                dto.addPropertyDescriptor(this.propertyDescriptorToDto(each));
            }
        }
        return dto;
    }

    public TaskInfos tasksToDto(List<Task> tasks) {
        TaskInfos taskInfos = new TaskInfos();
        for (Task eachTask : tasks) {
            taskInfos.add(this.taskToDto(eachTask.getId(), eachTask));
        }
        return taskInfos;
    }

    public TaskInfo taskToDto(String id, Task task) {
        Checks.checkNotNull((Object)id, (String)"id");
        Checks.checkNotNull((Object)task, (String)"task");
        TaskInfo ti = new TaskInfo();
        ti.setId(id);
        ti.setLabel(task.getLabel());
        ti.setState(task.getState().name());
        ti.setStartDate(task.getStartDate());
        ti.setCompletionDate(task.getCompletionDate());
        ti.setNrOfSteps(task.getNrOfSteps());
        ti.setCurrentStepNr(task.getCurrentStepNr());
        ti.setUser(task.getOwner());
        if (task instanceof DeploymentTask) {
            DeploymentTask dt = (DeploymentTask)task;
            ti.setApplication(dt.getApplicationName());
            ti.setVersion(dt.getApplicationVersion());
            ti.setEnvironment(dt.getEnvironment());
            ti.setFailureCount(dt.getFailureCount());
        }
        return ti;
    }

    public StepInfo taskStepInfoToDto(int stepNr, TaskStepInfo step) {
        Checks.checkNotNull((Object)step, (String)"step");
        StepInfo si = new StepInfo();
        si.setNr(stepNr);
        si.setDescription(step.getDescription());
        si.setState(step.getState().name());
        si.setStartDate(step.getStartDate());
        si.setCompletionDate(step.getCompletionDate());
        si.setLog(step.getLog());
        return si;
    }

    public Steps taskToDto(Task task) {
        return this.taskStepInfosToDto(task.getSteps());
    }

    public Steps taskStepInfosToDto(List<? extends TaskStepInfo> stepList) {
        Steps steps = new Steps();
        int stepNr = 1;
        for (TaskStepInfo taskStepInfo : stepList) {
            steps.add(this.taskStepInfoToDto(stepNr++, taskStepInfo));
        }
        return steps;
    }

    public TaskInfo archivedTaskToDto(DeploymentTaskInfo deploymentTask) {
        Checks.checkNotNull((Object)deploymentTask, (String)"deploymentTask");
        return this.populateTaskInfo(deploymentTask, new TaskInfo());
    }

    private <T extends TaskInfo> T populateTaskInfo(DeploymentTaskInfo deploymentTask, T taskInfo) {
        Checks.checkNotNull((Object)deploymentTask, (String)"deploymentTask");
        Checks.checkNotNull(taskInfo, (String)"taskInfo");
        taskInfo.setId(deploymentTask.getId());
        taskInfo.setLabel(String.format("Deployment of package:%s version:%s to env:%s", deploymentTask.getApplicationName(), deploymentTask.getApplicationVersion(), deploymentTask.getEnvironment()));
        taskInfo.setState(deploymentTask.getState().name());
        taskInfo.setStartDate(deploymentTask.getStartDate());
        taskInfo.setCompletionDate(deploymentTask.getCompletionDate());
        taskInfo.setNrOfSteps(deploymentTask.getSteps().size());
        taskInfo.setCurrentStepNr(deploymentTask.getCurrentStepNr());
        taskInfo.setUser(deploymentTask.getOwner());
        taskInfo.setEnvironment(deploymentTask.getEnvironment());
        taskInfo.setApplication(deploymentTask.getApplicationName());
        taskInfo.setVersion(deploymentTask.getApplicationVersion());
        return taskInfo;
    }

    public RepositoryObject validationMessagesToDto(RepositoryObjectEntity entity, List<ValidationMessage> messages) {
        RepositoryObject repositoryObject = this.entityToDto(entity);
        repositoryObject.setValidations(this.validationMessagesToDto(messages));
        return repositoryObject;
    }

    public List<Message> validationMessagesToDto(List<ValidationMessage> messages) {
        ArrayList list = Lists.newArrayList();
        for (ValidationMessage validationMessage : messages) {
            list.add(new Message(validationMessage.getFieldName(), validationMessage.getMessage()));
        }
        return list;
    }

    public FullTaskInfo fullArchivedTaskToDto(DeploymentTaskInfo deploymentTaskInfo) {
        Checks.checkNotNull((Object)deploymentTaskInfo, (String)"deploymentTaskInfo");
        int stepNr = 1;
        FullTaskInfo fullTaskInfo = this.populateTaskInfo(deploymentTaskInfo, new FullTaskInfo());
        for (TaskStepInfo taskStepInfo : deploymentTaskInfo.getSteps()) {
            fullTaskInfo.addStep(this.taskStepInfoToDto(stepNr++, taskStepInfo));
        }
        return fullTaskInfo;
    }
}

