/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.ImportablePackageProxy;
import com.xebialabs.deployit.core.api.dto.FileUpload;
import com.xebialabs.deployit.core.api.dto.ImportablePackages;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.source.ByteArraySource;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.service.importer.source.UrlSource;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ImportablePackageResource
extends AbstractSecuredResource
implements ImportablePackageProxy {
    @Autowired
    private ImporterService importerService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DtoConverter dtoConverter;

    public Response list() {
        List files = this.importerService.listPackages();
        return ResponseFactory.ok((Object)new ImportablePackages(files)).build();
    }

    public Response importPackage(String file) {
        if (!this.importerService.getImportablePackageDirectory().exists()) {
            throw new ImporterException(String.format("Directory '%s' to import packages from does not exist", this.importerService.getImportablePackageDirectory().getAbsolutePath()), new Object[0]);
        }
        FileSource fileSource = new FileSource(new File(this.importerService.getImportablePackageDirectory(), file), false);
        return ResponseFactory.created((Object)this.doImport((ImportSource)fileSource)).build();
    }

    public Response importPackageFromUrl(String url) {
        try {
            UrlSource urlSource = new UrlSource(new URL(url));
            return ResponseFactory.created((Object)this.doImport((ImportSource)urlSource)).build();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Response importUploadedPackage(String file, FileUpload form) {
        byte[] uploadedPackage = form.getFileData();
        ByteArraySource byteArraySource = new ByteArraySource(file, uploadedPackage);
        return ResponseFactory.created((Object)this.doImport((ImportSource)byteArraySource)).build();
    }

    private RepositoryObject doImport(ImportSource source) {
        String importedApplication = this.importerService.importPackage(source);
        RepositoryObjectEntity read = this.repositoryService.read(importedApplication);
        return this.dtoConverter.entityToDto(read);
    }
}

