/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.RepositoryProxy;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.validation.ValidationMessage;
import com.xebialabs.deployit.service.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class RepositoryResource
extends AbstractSecuredResource
implements RepositoryProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DtoConverter dtoConverter;
    @Autowired
    private Validator validator;

    public Response create(String id, RepositoryObject dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.setId(id);
        RepositoryObjectEntity entity = this.dtoConverter.entityFromDto(dto);
        return this.createInternal(entity);
    }

    public Response create(String id, ArtifactAndData dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.getArtifact().setId(id);
        ArtifactEntity entity = this.dtoConverter.artifactEntityFromDto(dto);
        return this.createInternal((RepositoryObjectEntity)entity);
    }

    public Response createMultiple(RepositoryObjects dto) {
        this.checkPermission(Permission.EDIT_REPO, Lists.newArrayList((Iterable)Collections2.transform((Collection)dto.getObjects(), (Function)new Function<RepositoryObject, String>(){

            public String apply(RepositoryObject from) {
                return from.getId();
            }
        })));
        Collection<RepositoryObjectEntity> entities = this.dtoConverter.entitiesFromDto(dto.getObjects());
        return this.createInternal(entities);
    }

    public Response read(String id) {
        RepositoryObjectEntity entity = this.repositoryService.read(id);
        RepositoryObject dto = this.dtoConverter.entityToDto(entity);
        return ResponseFactory.status((Response.Status)Response.Status.OK).entity((Object)dto).build();
    }

    public Response update(String id, RepositoryObject dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.setId(id);
        RepositoryObjectEntity entity = this.dtoConverter.entityFromDto(dto);
        return this.updateInternal(entity);
    }

    public Response update(String id, ArtifactAndData dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.getArtifact().setId(id);
        ArtifactEntity entity = this.dtoConverter.artifactEntityFromDto(dto);
        return this.updateInternal((RepositoryObjectEntity)entity);
    }

    public Response delete(String id) {
        this.checkPermission(Permission.EDIT_REPO, id);
        this.repositoryService.delete(new String[]{id});
        return ResponseFactory.noContent().build();
    }

    private Response createInternal(RepositoryObjectEntity entity) {
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(entity);
        if (response != null) {
            return response;
        }
        this.repositoryService.create(new RepositoryObjectEntity[]{entity});
        return this.reloadEntityAndCreateSuccessResponse(entity);
    }

    private Response validateEntityAndCreateErrorResponseIfNeeded(RepositoryObjectEntity entity) {
        Validator.Validations validations = this.validator.validate(entity, (List)Lists.newArrayList());
        if (validations.hasMessages()) {
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.dtoConverter.validationMessagesToDto(entity, (List<ValidationMessage>)validations)).build();
        }
        return null;
    }

    private Response validateEntityAndCreateErrorResponseIfNeeded(Collection<RepositoryObjectEntity> entities) {
        RepositoryObjects repositoryObjects = new RepositoryObjects();
        boolean allValid = true;
        RepositoryObjectEntity[] entitiesArray = entities.toArray(new RepositoryObjectEntity[entities.size()]);
        for (RepositoryObjectEntity entity : entities) {
            Validator.Validations validations = this.validator.validate(entity, entitiesArray);
            repositoryObjects.add(this.dtoConverter.validationMessagesToDto(entity, (List<ValidationMessage>)validations));
            allValid = allValid && !validations.hasMessages();
        }
        if (!allValid) {
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)repositoryObjects).build();
        }
        return null;
    }

    private Response reloadEntityAndCreateSuccessResponse(RepositoryObjectEntity entity) {
        RepositoryObjectEntity reloaded = this.repositoryService.read(entity.getId());
        return ResponseFactory.created((Object)this.dtoConverter.entityToDto(reloaded)).build();
    }

    private Response createInternal(Collection<RepositoryObjectEntity> entities) {
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(entities);
        if (response != null) {
            return response;
        }
        RepositoryObjectEntity[] entitiesArray = entities.toArray(new RepositoryObjectEntity[entities.size()]);
        this.repositoryService.create(entitiesArray);
        return this.reloadEntityAndCreateSuccessResponse(entities);
    }

    private Response reloadEntityAndCreateSuccessResponse(Collection<RepositoryObjectEntity> entities) {
        ArrayList reloadedDtos = Lists.newArrayList();
        for (RepositoryObjectEntity entity : entities) {
            RepositoryObjectEntity reloadedEntity = this.repositoryService.read(entity.getId());
            reloadedDtos.add(reloadedEntity);
        }
        return ResponseFactory.created((Object)this.dtoConverter.entitiesToDto(reloadedDtos)).build();
    }

    private Response updateInternal(RepositoryObjectEntity entity) {
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(entity);
        if (response != null) {
            return response;
        }
        this.repositoryService.update(new RepositoryObjectEntity[]{entity});
        return this.reloadEntityAndCreateSuccessResponse(entity);
    }
}

