package com.xebialabs.deployit.core.rest.api;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.core.api.DescriptorProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;

@Controller
public class DescriptorResource implements DescriptorProxy {

	@Autowired
	private DtoConverter dtoConverter;

	@Override
	public Response list() {
		ConfigurationItemDescriptorList descriptorList = new ConfigurationItemDescriptorList();
		List<ConfigurationItemDescriptorDto> descriptors = new ArrayList<ConfigurationItemDescriptorDto>();
		for (Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
			if(!descriptor.isVirtual()) {
				ConfigurationItemDescriptorDto descriptorDto = dtoConverter.descriptorToDto(descriptor);
				descriptors.add(descriptorDto);
			}
		}
		descriptorList.setDescriptors(descriptors);
		return ResponseFactory.ok(descriptorList).build();
	}

	@Override
	public Response find(@PathParam("type") final String type) {
		final Descriptor descriptor = DescriptorRegistry.getDescriptor(Type.valueOf(type));
		final ConfigurationItemDescriptorDto dto = dtoConverter.descriptorToDto(descriptor);
		return ResponseFactory.ok(dto).build();
	}

}
