/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Strings;
import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.SearchParameters;
import java.util.List;

public class SearchParameterFactory {
    static final long DEFAULT_RESULTS_PER_PAGE = 25L;

    public static SearchParameters createSearchParam(String type, long page, long resultPerPage, List<PropertyValue> values, Date at, Date after, Date before) {
        SearchParameters searchParameters = SearchParameterFactory.createSearchParam(type, page, resultPerPage, values);
        if (at != null) {
            searchParameters.setAt(at.getCalendar());
        }
        if (after != null) {
            searchParameters.setAfter(after.getCalendar());
        }
        if (before != null) {
            searchParameters.setBefore(before.getCalendar());
        }
        return searchParameters;
    }

    public static SearchParameters createSearchParam(String type, long page, long resultPerPage, List<PropertyValue> values) {
        SearchParameters searchParam = new SearchParameters();
        if (type != null && !type.trim().isEmpty()) {
            searchParam.setType(Type.valueOf((String)type));
        }
        searchParam.setPage(page);
        if (resultPerPage > 0L) {
            searchParam.setResultsPerPage(resultPerPage);
        } else if (resultPerPage == 0L) {
            searchParam.setResultsPerPage(25L);
        }
        for (PropertyValue value : values) {
            searchParam.addProperty(value.getKey(), value.getValue());
        }
        return searchParam;
    }

    public static SearchParameters createSearchParam(String typeName, long page, long resultPerPage, List<PropertyValue> values, String parent, String id) {
        SearchParameters searchParam = SearchParameterFactory.createSearchParam(typeName, page, resultPerPage, values);
        if (SearchParameterFactory.isNotBlank(parent)) {
            searchParam.setParent(parent);
        }
        if (SearchParameterFactory.isNotBlank(id)) {
            searchParam.setId(id);
        }
        return searchParam;
    }

    private static boolean isNotBlank(String parent) {
        return !Strings.nullToEmpty((String)parent).trim().isEmpty();
    }
}

