/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.core.rest.api.reports.widgets.DeploymentTrendsPercentileWidget;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DeploymentTrendsWidget;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DeploymentsDurationFrequencyWidget;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DeploymentsPercentageWidgetData;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Top5LongestRunningDeployments;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Top5RetriedDeployments;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Top5SuccessfulDeployments;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.TaskArchive;

public enum WidgetRegistry {
    DEPLOYMENTSUCCESS("deploymentSuccess"){

        @Override
        public final Widget getWidget(TaskArchive taskArchive) {
            return DeploymentsPercentageWidgetData.getInstance(taskArchive);
        }
    }
    ,
    DEPLOYMENTDURATION("deploymentDuration"){

        @Override
        public final Widget getWidget(TaskArchive taskArchive) {
            return DeploymentsDurationFrequencyWidget.getInstance(taskArchive);
        }
    }
    ,
    DEPLOYMENTTREND("deploymentTrend"){

        @Override
        public Widget getWidget(TaskArchive taskArchive) {
            return DeploymentTrendsWidget.getInstance(taskArchive);
        }
    }
    ,
    DEPLOYMENTTRENDPERCENTILE("deploymentTrendPercentile"){

        @Override
        public Widget getWidget(TaskArchive taskArchive) {
            return DeploymentTrendsPercentileWidget.getInstance(taskArchive);
        }
    }
    ,
    TOP5SUCCESSFULDEPLOYMENTS("top5SuccessfulDeployments"){

        @Override
        public Widget getWidget(TaskArchive taskArchive) {
            return Top5SuccessfulDeployments.getInstance(taskArchive);
        }
    }
    ,
    TOP5RETRIEDDEPLOYMENTS("top5RetriedDeployments"){

        @Override
        public Widget getWidget(TaskArchive taskArchive) {
            return Top5RetriedDeployments.getInstance(taskArchive);
        }
    }
    ,
    TOP5LONGESTRUNNINGDEPLOYMENTS("top5LongestRunningDeployments"){

        @Override
        public Widget getWidget(TaskArchive taskArchive) {
            return Top5LongestRunningDeployments.getInstance(taskArchive);
        }
    };

    private String widgetName;

    private WidgetRegistry(String widgetName) {
        this.widgetName = widgetName;
    }

    public final String getWidgetType() {
        return this.widgetName;
    }

    public abstract Widget getWidget(TaskArchive var1);
}

