/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.core.rest.resteasy.TemporaryFiles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.mime4j.storage.AbstractStorageProvider;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.storage.StorageOutputStream;

public class Mime4jStorageProvider
extends AbstractStorageProvider {
    private static final Set<File> toBeDeleted = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final String DEFAULT_PREFIX = "m4j";
    private final String prefix;
    private final String suffix;
    private final File directory;

    public Mime4jStorageProvider() {
        this(DEFAULT_PREFIX, null, null);
    }

    public Mime4jStorageProvider(File directory) {
        this(DEFAULT_PREFIX, null, directory);
    }

    public Mime4jStorageProvider(String prefix, String suffix, File directory) {
        if (prefix == null || prefix.length() < 3) {
            throw new IllegalArgumentException("invalid prefix");
        }
        if (directory != null && !directory.isDirectory() && !directory.mkdirs()) {
            throw new IllegalArgumentException("invalid directory");
        }
        this.prefix = prefix;
        this.suffix = suffix;
        this.directory = directory;
    }

    public StorageOutputStream createStorageOutputStream() throws IOException {
        File file = File.createTempFile(this.prefix, this.suffix, this.directory);
        file.deleteOnExit();
        return new TempFileStorageOutputStream(file);
    }

    private static final class TempFileStorageOutputStream
    extends StorageOutputStream {
        private File file;
        private OutputStream out;

        public TempFileStorageOutputStream(File file) throws IOException {
            this.file = file;
            this.out = new FileOutputStream(file);
        }

        public void close() throws IOException {
            super.close();
            this.out.close();
        }

        protected void write0(byte[] buffer, int offset, int length) throws IOException {
            this.out.write(buffer, offset, length);
        }

        protected Storage toStorage0() throws IOException {
            return new TemporaryFiles.TempFileStorage(this.file);
        }
    }
}

