/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class DeploymentsForEnvironmentReport {
    private TaskArchive taskArchive;

    public DeploymentsForEnvironmentReport(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(String string, Date date) {
        ArchivedTaskSearchParameters archivedTaskSearchParameters = new ArchivedTaskSearchParameters();
        archivedTaskSearchParameters.toEnvironment(string).createdOnOrBefore(date.getCalendar());
        Report report = new Report();
        Collection collection = this.taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters, new GroupBy((Collection)Lists.newArrayList((Object[])new String[]{"applicationName"}), new Function[]{new Function<Map<String, String>>(){

            public Map<String, String> invoke(Object object, DeploymentTaskInfo deploymentTaskInfo) {
                if (object == null) {
                    return this.getTaskInfo(deploymentTaskInfo);
                }
                Map<String, String> map = (Map<String, String>)object;
                Date date = new Date((String)map.get("date"));
                if (date.compareTo(new Date(deploymentTaskInfo.getCompletionDate(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ")) < 0) {
                    map = this.getTaskInfo(deploymentTaskInfo);
                }
                return map;
            }

            private Map<String, String> getTaskInfo(DeploymentTaskInfo deploymentTaskInfo) {
                HashMap hashMap = Maps.newHashMap();
                hashMap.put("deploymentType", deploymentTaskInfo.getDeploymentType().name());
                hashMap.put("user", deploymentTaskInfo.getOwner());
                hashMap.put("date", new Date(deploymentTaskInfo.getCompletionDate(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ").toString());
                hashMap.put("applicationVersion", deploymentTaskInfo.getApplicationVersion());
                return hashMap;
            }

            public String getName() {
                return "taskInfo";
            }
        }}));
        ArrayList arrayList = Lists.newArrayList((Iterable)collection);
        Collections.sort(arrayList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> map, Map<String, Object> map2) {
                Map map3 = (Map)map.get("taskInfo");
                Map map4 = (Map)map2.get("taskInfo");
                Date date = new Date((String)map3.get("date"));
                Date date2 = new Date((String)map4.get("date"));
                return date.compareTo(date2);
            }
        });
        for (Map map : arrayList) {
            Map map2 = (Map)map.get("taskInfo");
            if (DeploymentTask.DeploymentType.valueOf((String)((String)map2.get("deploymentType"))).equals((Object)DeploymentTask.DeploymentType.UNDEPLOY)) continue;
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("application", map.get("applicationName"));
            reportLine.addValue("version", map2.get("applicationVersion"));
            reportLine.addValue("user", map2.get("user"));
            reportLine.addValue("date", map2.get("date"));
        }
        return report;
    }
}

