/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.OutputSupplier;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.io.DerivedArtifactFile;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.util.Either;
import com.xebialabs.deployit.util.PasswordObfuscator;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationItemDtoReader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationItemDtoReader.class);

    public <T extends ConfigurationItem> T read(ConfigurationItemDto configurationItemDto) {
        return this.read(configurationItemDto, null);
    }

    public <T extends ConfigurationItem> T read(ConfigurationItemDto configurationItemDto, WorkDir workDir) {
        return this.read(configurationItemDto, workDir, Maps.newHashMap());
    }

    private <T extends ConfigurationItem> T read(ConfigurationItemDto configurationItemDto, WorkDir workDir, Map<String, Either<ConfigurationItemDto, ConfigurationItem>> map) {
        Checks.checkNotNull((Object)configurationItemDto, (String)"dto");
        Checks.checkNotNull((Object)configurationItemDto.getId(), (String)"dto.id");
        Type type = Type.valueOf((String)configurationItemDto.getType());
        Checks.checkArgument((boolean)type.exists(), (String)"Type %s does not exist", (Object[])new Object[]{type});
        Descriptor descriptor = type.getDescriptor();
        ConfigurationItem configurationItem = descriptor.newInstance();
        configurationItem.setId(configurationItemDto.getId());
        map.put(configurationItem.getId(), (Either<ConfigurationItemDto, ConfigurationItem>)Either.right((Object)configurationItem));
        this.copyValues((RepositoryObject)configurationItemDto, configurationItem, descriptor, workDir, map);
        if (configurationItem instanceof DerivedArtifact && workDir != null) {
            logger.trace("Setting DerivedFile on {}", (Object)configurationItemDto.getId());
            ((DerivedArtifact)configurationItem).setFile((OverthereFile)DerivedArtifactFile.create((DerivedArtifact)((DerivedArtifact)configurationItem)));
        }
        return (T)configurationItem;
    }

    public ConfigurationItem read(ArtifactAndData artifactAndData, WorkDir workDir) {
        Checks.checkNotNull((Object)artifactAndData, (String)"dto");
        Artifact artifact = (Artifact)this.read((ConfigurationItemDto)artifactAndData.getArtifact(), workDir);
        artifact.setFile((OverthereFile)this.readArtifactData(artifactAndData, workDir));
        return artifact;
    }

    private LocalFile readArtifactData(ArtifactAndData artifactAndData, WorkDir workDir) {
        Checks.checkArgument((artifactAndData.getArtifact().getFilename() != null ? 1 : 0) != 0, (String)"The filename for the artifact should not be null", (Object[])new Object[0]);
        final LocalFile localFile = workDir.newFile(artifactAndData.getArtifact().getFilename());
        try {
            ByteStreams.write((byte[])artifactAndData.getData(), (OutputSupplier)new OutputSupplier<OutputStream>(){

                public OutputStream getOutput() throws IOException {
                    return localFile.getOutputStream();
                }
            });
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not write Artifact data for " + artifactAndData.getArtifact().getId() + " to " + localFile);
        }
        return localFile;
    }

    private void copyValues(RepositoryObject repositoryObject, ConfigurationItem configurationItem, Descriptor descriptor, WorkDir workDir, Map<String, Either<ConfigurationItemDto, ConfigurationItem>> map) {
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            Object v = repositoryObject.getValues().get(propertyDescriptor.getName());
            if (v == null) continue;
            propertyDescriptor.set(configurationItem, this.convertValueIfNecessary(v, propertyDescriptor, workDir, map));
        }
    }

    private Object convertValueIfNecessary(Object set, PropertyDescriptor propertyDescriptor, WorkDir workDir, Map<String, Either<ConfigurationItemDto, ConfigurationItem>> map) {
        Object object = null;
        switch (propertyDescriptor.getKind()) {
            case STRING: {
                if (propertyDescriptor.isPassword()) {
                    object = PasswordObfuscator.ensureDecrypted((String)((String)((Object)set)));
                    break;
                }
            }
            case BOOLEAN: 
            case INTEGER: 
            case ENUM: {
                object = set;
                break;
            }
            case SET_OF_STRING: {
                object = this.handleSetOfString(set);
                break;
            }
            case SET_OF_CI: {
                object = Sets.newHashSet(this.handleCollectionOfConfigurationItem(set, workDir, map));
                break;
            }
            case LIST_OF_STRING: {
                object = this.handleListOfString(set);
                break;
            }
            case LIST_OF_CI: {
                object = Lists.newArrayList(this.handleCollectionOfConfigurationItem(set, workDir, map));
                break;
            }
            case CI: {
                object = this.handleConfigurationItem((String)((Object)set), workDir, map);
                break;
            }
            case MAP_STRING_STRING: {
                object = set != null ? Maps.newHashMap((Map)((Map)((Object)set))) : null;
            }
        }
        return object;
    }

    private Collection<ConfigurationItem> handleCollectionOfConfigurationItem(Object object, WorkDir workDir, Map<String, Either<ConfigurationItemDto, ConfigurationItem>> map) {
        ArrayList arrayList = Lists.newArrayList();
        for (String string : (Collection)object) {
            arrayList.add(this.handleConfigurationItem(string, workDir, map));
        }
        return arrayList;
    }

    private ConfigurationItem handleConfigurationItem(String string, WorkDir workDir, Map<String, Either<ConfigurationItemDto, ConfigurationItem>> map) {
        if (map.containsKey(string)) {
            Either<ConfigurationItemDto, ConfigurationItem> either = map.get(string);
            if (either.getLeft() != null) {
                return this.read((ConfigurationItemDto)either.getLeft(), workDir, map);
            }
            return (ConfigurationItem)either.getRight();
        }
        ConfigurationItem configurationItem = RepositoryServiceHolder.getRepositoryService().read(string, workDir);
        map.put(configurationItem.getId(), (Either<ConfigurationItemDto, ConfigurationItem>)Either.right((Object)configurationItem));
        return configurationItem;
    }

    private Set<String> handleSetOfString(Object object) {
        if (object instanceof Set) {
            return Sets.newHashSet((Iterable)((Set)object));
        }
        if (object instanceof Collection) {
            return Sets.newHashSet((Iterable)((Collection)object));
        }
        throw new IllegalStateException("Did not get a Set of String or other Collection type, but a: " + object);
    }

    private List<String> handleListOfString(Object object) {
        if (object instanceof List) {
            return Lists.newArrayList((Iterable)((List)object));
        }
        if (object instanceof Collection) {
            return Lists.newArrayList((Iterable)((Collection)object));
        }
        throw new IllegalStateException("Did not get a List of String or other Collection type, but a: " + object);
    }

    public List<ConfigurationItem> read(ConfigurationItemDtos configurationItemDtos) {
        return this.read(configurationItemDtos.getObjects(), null);
    }

    public List<ConfigurationItem> read(List<ConfigurationItemDto> list) {
        return this.read(list, null);
    }

    public List<ConfigurationItem> read(List<ConfigurationItemDto> list, WorkDir workDir) {
        ArrayList arrayList = Lists.newArrayList();
        Map<String, Either<ConfigurationItemDto, ConfigurationItem>> map = this.buildContext(list);
        for (ConfigurationItemDto configurationItemDto : list) {
            Object t = this.read(configurationItemDto, workDir, map);
            arrayList.add(t);
        }
        return arrayList;
    }

    private Map<String, Either<ConfigurationItemDto, ConfigurationItem>> buildContext(List<ConfigurationItemDto> list) {
        HashMap hashMap = Maps.newHashMap();
        for (ConfigurationItemDto configurationItemDto : list) {
            hashMap.put(configurationItemDto.getId(), Either.left((Object)configurationItemDto));
        }
        return hashMap;
    }
}

