package com.xebialabs.deployit.core.rest.api;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.google.common.base.Function;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.InternalComparisonProxy;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.comparison.Comparator;

@Controller
public class ComparisonResource extends AbstractSecuredResource implements InternalComparisonProxy {

    @Autowired
    private RepositoryService repositoryService;

    @Autowired
    private Comparator comparator;

    @Override
    public Comparison compare(String reference, List<String> ids) {
        ConfigurationItem referenceEntity = repositoryService.read(reference);

        final ListMultimap<String, String> multimap = comparator.compare(referenceEntity, Lists.transform(ids, new Function<String, ConfigurationItem>() {
            @Override
            public ConfigurationItem apply(String input) {
                return repositoryService.read(input);
            }
        }));

        return Comparison.from(multimap);
    }
}
