package com.xebialabs.deployit.core.rest.api.reports;

import java.util.EnumSet;

import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;

import static com.xebialabs.deployit.task.TaskType.INITIAL;
import static com.xebialabs.deployit.task.TaskType.ROLLBACK;
import static com.xebialabs.deployit.task.TaskType.UNDEPLOY;
import static com.xebialabs.deployit.task.TaskType.UPGRADE;

public abstract class TaskArchiveReport {

    protected final JcrTaskArchive taskArchive;
    private ArchivedTaskSearchParameters searchParameters;

    public TaskArchiveReport(JcrTaskArchive taskArchive) {
        this.taskArchive = taskArchive;
        this.searchParameters = new ArchivedTaskSearchParameters();
        this.searchParameters.thatAreOfType(EnumSet.of(INITIAL, ROLLBACK, UNDEPLOY, UPGRADE));
    }

    public ArchivedTaskSearchParameters getSearchParameters() {
        return searchParameters;
    }

    public ArchivedTaskSearchParameters cloneSearchParameters() {
        return new ArchivedTaskSearchParameters(searchParameters);
    }

}