package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

@Component
public class WorkdirHolder {

    private static final AtomicReference<WorkDirFactory> FACTORY = new AtomicReference<WorkDirFactory>();

    private static final ThreadLocal<WorkDir> WORKDIR = new ThreadLocal<WorkDir>();

    @Autowired
    public WorkdirHolder(WorkDirFactory workDirFactory) {
        FACTORY.compareAndSet(null, workDirFactory);
    }

    public static void initWorkdir() {
        WORKDIR.set(FACTORY.get().newWorkDir());
    }

    public static void clear() {
        WORKDIR.remove();
    }

    public static WorkDir get() {
        return WORKDIR.get();
    }
}
