/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.InspectionService;
import com.xebialabs.deployit.engine.api.dto.Inspection;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.tasker.Engine;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.discovery.DiscoveryResult;
import com.xebialabs.deployit.service.discovery.DiscoveryService;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.util.List;
import javax.ws.rs.PathParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DiscoveryResource
extends AbstractSecuredResource
implements InspectionService {
    @Autowired
    private DiscoveryService discoveryService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private Engine engine;
    @Autowired
    private JcrTaskArchive taskArchive;
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryResource.class);

    public Inspection prepare(ConfigurationItem configurationItem) {
        this.checkPermission(Permission.DISCOVERY);
        return new Inspection(configurationItem);
    }

    public Inspection prepare(String id) {
        this.checkPermission(Permission.DISCOVERY);
        ConfigurationItem read = this.repositoryService.read(id);
        return new Inspection(read);
    }

    @Workdir
    public String createTask(Inspection inspection) {
        this.checkPermission(Permission.DISCOVERY);
        try {
            TaskSpecification taskSpecification = this.discoveryService.prepareDiscovery(inspection.getConfigurationItem(), WorkdirHolder.get());
            logger.info("Creating inspection task for [{}]", (Object)inspection.getConfigurationItem());
            return this.engine.register(taskSpecification);
        }
        catch (RuntimeException e) {
            WorkdirHolder.get().delete();
            throw e;
        }
    }

    public List<ConfigurationItem> retrieveInspectionResults(@PathParam(value="taskId") String taskId) {
        this.checkPermission(Permission.DISCOVERY);
        TaskWithSteps task = this.taskArchive.getTask(taskId);
        if (task == null) {
            throw new Checks.ConditionFailedException("Task [%s] is not yet finished.", new Object[]{taskId});
        }
        DiscoveryResult discoveryResults = this.discoveryService.getDiscoveryResults(taskId);
        if (!discoveryResults.getOwner().equals(Permissions.getAuthenticatedUserName())) {
            throw new Checks.ConditionFailedException("You were not the owner of task [%s]", new Object[]{taskId});
        }
        return discoveryResults.getItems();
    }
}

