/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.joda.time.DateTime;

public class DeploymentsDurationFrequencyWidget
extends DashboardWidgetBase {
    private static final String INTERVAL = "interval";
    private static final String DEPLOYMENT_PERCENT = "deploymentPercent";
    private static final String NUM_OF_DEPLOYMENT = "numOfDeployment";
    private final DecimalFormat format = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public DeploymentsDurationFrequencyWidget(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(DateTime begin, DateTime end) {
        ArchivedTaskSearchParameters sp = this.getSearchParameters().createdBetween(begin, end).thatCompleted().thatAreOfType(EnumSet.of(TaskType.INITIAL, TaskType.UNDEPLOY, TaskType.UPGRADE));
        Collection foundTasks = this.taskArchive.searchTaskWithOnlyMetadata(sp);
        if (foundTasks.size() == 0) {
            return new Report();
        }
        return this.generateReport(foundTasks);
    }

    private Report generateReport(Collection<ArchivedTask> foundTasks) {
        long mean = DeploymentsDurationFrequencyWidget.mean(foundTasks);
        long standardDeviation = DeploymentsDurationFrequencyWidget.standardDeviation(mean, foundTasks);
        List<Long> clusterLimits = DeploymentsDurationFrequencyWidget.clusterLimits(mean, standardDeviation);
        return this.createDetails(foundTasks, clusterLimits);
    }

    private static long mean(Collection<ArchivedTask> tasks) {
        long total = 0L;
        for (TaskState taskState : tasks) {
            total += ReportUtils.duration(taskState);
        }
        return total / (long)tasks.size();
    }

    private static long standardDeviation(long mean, Collection<ArchivedTask> tasks) {
        if (tasks.size() > 1) {
            long total = 0L;
            for (TaskState taskState : tasks) {
                long distance = ReportUtils.duration(taskState) - mean;
                total += distance * distance;
            }
            return (long)Math.sqrt(total / (long)(tasks.size() - 1));
        }
        return 0L;
    }

    private static List<Long> clusterLimits(long mean, long standardDeviation) {
        ArrayList clusterLimits = Lists.newArrayList();
        if (standardDeviation > 0L && mean - standardDeviation - standardDeviation > 0L) {
            clusterLimits.add(mean - standardDeviation - standardDeviation);
        }
        if (standardDeviation > 0L && mean - standardDeviation > 0L) {
            clusterLimits.add(mean - standardDeviation);
        }
        clusterLimits.add(mean);
        if (standardDeviation > 0L) {
            clusterLimits.add(mean + standardDeviation);
            clusterLimits.add(mean + standardDeviation + standardDeviation);
        }
        return clusterLimits;
    }

    private Report createDetails(Collection<ArchivedTask> tasks, List<Long> clusterLimits) {
        Report report = new Report();
        int[] clusters = DeploymentsDurationFrequencyWidget.cluster(tasks, clusterLimits);
        int totalDeployments = tasks.size();
        if (totalDeployments > 1) {
            Report.ReportLine firstLine = report.addLine();
            firstLine.addValue(INTERVAL, (Object)("<" + DeploymentsDurationFrequencyWidget.formatToMinsAndSecs(clusterLimits.get(0))));
            firstLine.addValue(DEPLOYMENT_PERCENT, (Object)this.format.format(DeploymentsDurationFrequencyWidget.getPercentage(clusters[0], totalDeployments)));
            firstLine.addValue(NUM_OF_DEPLOYMENT, (Object)this.format.format(clusters[0]));
        }
        for (int i = 1; i < clusterLimits.size(); ++i) {
            Report.ReportLine line = report.addLine();
            line.addValue(INTERVAL, (Object)(DeploymentsDurationFrequencyWidget.formatToMinsAndSecs(clusterLimits.get(i - 1)) + " - " + DeploymentsDurationFrequencyWidget.formatToMinsAndSecs(clusterLimits.get(i))));
            line.addValue(DEPLOYMENT_PERCENT, (Object)this.format.format(DeploymentsDurationFrequencyWidget.getPercentage(clusters[i], totalDeployments)));
            line.addValue(NUM_OF_DEPLOYMENT, (Object)this.format.format(clusters[i]));
        }
        Report.ReportLine lastLine = report.addLine();
        lastLine.addValue(INTERVAL, (Object)(">" + DeploymentsDurationFrequencyWidget.formatToMinsAndSecs(clusterLimits.get(clusterLimits.size() - 1))));
        lastLine.addValue(DEPLOYMENT_PERCENT, (Object)this.format.format(DeploymentsDurationFrequencyWidget.getPercentage(clusters[clusters.length - 1], totalDeployments)));
        lastLine.addValue(NUM_OF_DEPLOYMENT, (Object)this.format.format(clusters[clusters.length - 1]));
        return report;
    }

    private static int[] cluster(Collection<ArchivedTask> tasks, List<Long> clusterLimits) {
        int[] cluster = new int[clusterLimits.size() + 1];
        for (TaskState taskState : tasks) {
            boolean aboveMaxLimit = true;
            for (int i = 0; i < clusterLimits.size(); ++i) {
                Long limit = clusterLimits.get(i);
                if (ReportUtils.duration(taskState) >= limit) continue;
                int n = i;
                cluster[n] = cluster[n] + 1;
                aboveMaxLimit = false;
                break;
            }
            if (!aboveMaxLimit) continue;
            int n = clusterLimits.size();
            cluster[n] = cluster[n] + 1;
        }
        return cluster;
    }
}

