/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.DateTime;

public class TaskStateData {
    private AtomicInteger noOfSuccessfulDeployments = new AtomicInteger(0);
    private AtomicInteger noOfFailedDeployments = new AtomicInteger(0);
    private AtomicInteger noOfAbortedDeployments = new AtomicInteger(0);
    private AtomicInteger noOfRollbacks = new AtomicInteger(0);
    private Long averageDeploymentTime = 0L;

    public AtomicInteger getNoOfSuccessfulDeployments() {
        return this.noOfSuccessfulDeployments;
    }

    public void setNoOfSuccessfulDeployments(AtomicInteger noOfSuccessfulDeployments) {
        this.noOfSuccessfulDeployments = noOfSuccessfulDeployments;
    }

    public AtomicInteger getNoOfFailedDeployments() {
        return this.noOfFailedDeployments;
    }

    public void setNoOfFailedDeployments(AtomicInteger noOfFailedDeployments) {
        this.noOfFailedDeployments = noOfFailedDeployments;
    }

    public AtomicInteger getNoOfAbortedDeployments() {
        return this.noOfAbortedDeployments;
    }

    public void setNoOfAbortedDeployments(AtomicInteger noOfAbortedDeployments) {
        this.noOfAbortedDeployments = noOfAbortedDeployments;
    }

    public AtomicInteger getNoOfRollbacks() {
        return this.noOfRollbacks;
    }

    public Long getAverageDeploymentTime() {
        return this.averageDeploymentTime;
    }

    public void setAverageDeploymentTime(Long averageDeploymentTime) {
        this.averageDeploymentTime = averageDeploymentTime;
    }

    public int getTotalSuccessfulTasks() {
        return this.noOfFailedDeployments.get() + this.noOfSuccessfulDeployments.get();
    }

    public int getTotalTasks() {
        return this.noOfAbortedDeployments.get() + this.noOfFailedDeployments.get() + this.noOfSuccessfulDeployments.get() + this.noOfRollbacks.get();
    }

    public void addTask(Map<String, Object> task) {
        if (TaskType.ROLLBACK.name().equals(task.get(ArchivedDeploymentTasks.task_type()))) {
            this.noOfRollbacks.incrementAndGet();
            return;
        }
        if (task.get(ArchivedDeploymentTasks.status()).equals(TaskExecutionState.DONE.toString())) {
            if (task.containsKey(ArchivedDeploymentTasks.failure_count()) && ((Number)task.get(ArchivedDeploymentTasks.failure_count())).intValue() > 0) {
                this.noOfFailedDeployments.incrementAndGet();
            } else {
                this.noOfSuccessfulDeployments.incrementAndGet();
            }
        } else if (task.get(ArchivedDeploymentTasks.status()).equals(TaskExecutionState.CANCELLED.toString())) {
            this.noOfAbortedDeployments.incrementAndGet();
        }
    }

    public void addTaskAndDuration(Map<String, Object> task) {
        this.addTask(task);
        if (task.get(ArchivedDeploymentTasks.status()).equals(TaskExecutionState.DONE.toString())) {
            this.averageDeploymentTime = this.averageDeploymentTime + (((DateTime)task.get(ArchivedDeploymentTasks.end_date())).getMillis() - ((DateTime)task.get(ArchivedDeploymentTasks.start_date())).getMillis());
        }
    }
}

