/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.InspectionService;
import com.xebialabs.deployit.engine.api.dto.Inspection;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.service.discovery.DiscoveryResult;
import com.xebialabs.deployit.service.discovery.DiscoveryService;
import com.xebialabs.deployit.task.archive.TaskArchive;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DiscoveryResource
extends AbstractSecuredResource
implements InspectionService {
    @Autowired
    private DiscoveryService discoveryService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaskExecutionEngine engine;
    @Autowired
    private TaskArchive taskArchive;
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryResource.class);

    public Inspection prepare(ConfigurationItem configurationItem) {
        this.checkPermission(DeployitPermissions.DISCOVERY);
        return new Inspection(configurationItem);
    }

    public Inspection prepare(String id) {
        this.checkPermission(DeployitPermissions.DISCOVERY);
        ConfigurationItem read = this.repositoryService.read(id);
        return new Inspection(read);
    }

    @Workdir(prefix="task")
    public String createTask(Inspection inspection) {
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            this.checkPermission(DeployitPermissions.DISCOVERY);
            TaskSpecification taskSpecification = this.discoveryService.prepareDiscovery(inspection.getConfigurationItem(), workDir);
            logger.info("Creating inspection task for [{}]", (Object)inspection.getConfigurationItem());
            return this.engine.register(taskSpecification);
        });
    }

    public List<ConfigurationItem> retrieveInspectionResults(String taskId) {
        this.checkPermission(DeployitPermissions.DISCOVERY);
        logger.info("Retrieving discovery results for task [{}]", (Object)taskId);
        try {
            Task task = this.engine.retrieve(taskId);
            logger.warn("Attempt to retrieve discovery results from a still-running task");
            int currentStepNr = task.getCurrentStepNr();
            StepState currentStep = task.getStep(currentStepNr);
            logger.warn("task [{}], state [{}], current step [{}/{}], description [{}], log: [{}]", new Object[]{taskId, task.getState(), currentStepNr, task.getNrSteps(), currentStep.getDescription(), currentStep.getLog()});
            throw new Checks.ConditionFailedException("Task [%s] is not yet finished.", new Object[]{taskId});
        }
        catch (TaskNotFoundException task) {
            DiscoveryResult discoveryResults = this.discoveryService.getDiscoveryResults(taskId);
            if (!discoveryResults.getOwner().equals(Permissions.getAuthenticatedUserName())) {
                throw new Checks.ConditionFailedException("You were not the owner of task [%s]", new Object[]{taskId});
            }
            return discoveryResults.getItems();
        }
    }
}

