/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.CredentialService;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.validator.UniqueDefaultCredentialValidator;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemProperties;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.service.validation.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0006\r\u0001eA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A1\u0006\u0001B\u0001B\u0003%Q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0004T\u0001\t\u0007I\u0011\u0001+\t\rm\u0003\u0001\u0015!\u0003V\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!!\u0004\u0001\t\u0013\ty\u0001C\u0004\u0002\u0016\u0001!I!a\u0006\u0003+\r\u0013X\rZ3oi&\fGnU3sm&\u001cW-S7qY*\u0011QBD\u0001\u0004CBL'BA\b\u0011\u0003\u0011\u0011Xm\u001d;\u000b\u0005E\u0011\u0012\u0001B2pe\u0016T!a\u0005\u000b\u0002\u0011\u0011,\u0007\u000f\\8zSRT!!\u0006\f\u0002\u0013a,'-[1mC\n\u001c(\"A\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Q\"\u0005\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005!A.\u00198h\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\r=\u0013'.Z2u!\t\u0019S%D\u0001%\u0015\ti\u0001#\u0003\u0002'I\t\t2I]3eK:$\u0018.\u00197TKJ4\u0018nY3\u00025\u0011,g-Y;mi\u000e\u0013X\rZ3oi&\fGNV1mS\u0012\fGo\u001c:\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-\u0002\u0012!\u0003<bY&$\u0017\r^8s\u0013\ti#F\u0001\u0011V]&\fX/\u001a#fM\u0006,H\u000e^\"sK\u0012,g\u000e^5bYZ\u000bG.\u001b3bi>\u0014\u0018!\u0005:fa>\u001c\u0018\u000e^8ssN+'O^5dKB\u0011\u0001gM\u0007\u0002c)\u0011!GE\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001b2\u0005E\u0011V\r]8tSR|'/_*feZL7-\u001a\t\u0003mmj\u0011a\u000e\u0006\u0003qe\n!B^1mS\u0012\fG/[8o\u0015\tQ$#A\u0004tKJ4\u0018nY3\n\u0005q:$!\u0003,bY&$\u0017\r^8s\u0003\u0019a\u0014N\\5u}Q!q(\u0011\"D!\t\u0001\u0005!D\u0001\r\u0011\u00159C\u00011\u0001)\u0011\u0015qC\u00011\u00010\u0011\u0015YC\u00011\u00016Q\t!Q\t\u0005\u0002G#6\tqI\u0003\u0002I\u0013\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005)[\u0015a\u00024bGR|'/\u001f\u0006\u0003\u00196\u000bQAY3b]NT!AT(\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001U\u0001\u0004_J<\u0017B\u0001*H\u0005%\tU\u000f^8xSJ,G-\u0001\u0004m_\u001e<WM]\u000b\u0002+B\u0011a+W\u0007\u0002/*\u0011\u0001lT\u0001\u0006g24GG[\u0005\u00035^\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0007GJ,\u0017\r^3\u0015\ty#\u0017O\u001e\t\u0003?\nl\u0011\u0001\u0019\u0006\u0002C\u0006)1oY1mC&\u00111\r\u0019\u0002\u0005+:LG\u000fC\u0003f\u000f\u0001\u0007a-\u0001\u0002jIB\u0011qM\u001c\b\u0003Q2\u0004\"!\u001b1\u000e\u0003)T!a\u001b\r\u0002\rq\u0012xn\u001c;?\u0013\ti\u0007-\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u0014aa\u0015;sS:<'BA7a\u0011\u0015\u0011x\u00011\u0001t\u0003%1wN]2f'\u00064X\r\u0005\u0002`i&\u0011Q\u000f\u0019\u0002\b\u0005>|G.Z1o\u0011\u00159x\u00011\u0001y\u0003E\u0019wN\u001c4jOV\u0014\u0018\r^5p]&#X-\u001c\t\u0003s~l\u0011A\u001f\u0006\u0003wr\f1!\u001e3n\u0015\tiQP\u0003\u0002\u007f%\u00051\u0001\u000f\\;hS:L1!!\u0001{\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\\\u0001\u0007kB$\u0017\r^3\u0015\u000fy\u000b9!!\u0003\u0002\f!)Q\r\u0003a\u0001M\")!\u000f\u0003a\u0001g\")q\u000f\u0003a\u0001q\u0006!b/\u00197jI\u0006$Xm\u0011:fI\u0016tG/[1m\u0007&$RAXA\t\u0003'AQA]\u0005A\u0002MDQa^\u0005A\u0002a\faC]3tKR$UMZ1vYR\u001c%/\u001a3f]RL\u0017\r\u001c\u000b\u0002=\"\u001a\u0001!a\u0007\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\tN\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003K\tyB\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class CredentialServiceImpl
implements CredentialService {
    private final UniqueDefaultCredentialValidator defaultCredentialValidator;
    private final RepositoryService repositoryService;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void create(String id, boolean forceSave, ConfigurationItem configurationItem) {
        this.validateCredentialCi(forceSave, configurationItem);
        if (forceSave) {
            this.resetDefaultCredential();
        }
        this.repositoryService.create(new ConfigurationItem[]{configurationItem});
    }

    public void update(String id, boolean forceSave, ConfigurationItem configurationItem) {
        this.validateCredentialCi(forceSave, configurationItem);
        if (forceSave) {
            this.resetDefaultCredential();
        }
        this.repositoryService.update(new ConfigurationItem[]{configurationItem});
    }

    private void validateCredentialCi(boolean forceSave, ConfigurationItem configurationItem) {
        if (!forceSave) {
            try {
                this.defaultCredentialValidator.validate(configurationItem);
            }
            catch (Validator.ValidationsFailedException ex) {
                this.logger().debug(ex.getMessage());
                throw ex;
            }
        }
    }

    private void resetDefaultCredential() {
        HashMap<String, String> properties = new HashMap<String, String>(null){
            {
                this.put("defaultCi", "true");
            }
        };
        ConfigurationItemProperties ciProperties = new ConfigurationItemProperties((Map)properties);
        SearchParameters searchParameters = SearchParametersFactory.createSearchParams((Type)Type.valueOf((String)"credentials.UsernamePasswordCredentials"), (long)0L, (long)-1L, null, null, null, null, null, null, (int)0, (ConfigurationItemProperties)ciProperties);
        String defaultCredentialCiId = (String)((IterableLike)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.repositoryService.list(searchParameters)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom())).head();
        ConfigurationItem defaultCredentialCi = this.repositoryService.read(defaultCredentialCiId);
        defaultCredentialCi.setProperty("defaultCi", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.repositoryService.update(new ConfigurationItem[]{defaultCredentialCi});
    }

    @Autowired
    public CredentialServiceImpl(UniqueDefaultCredentialValidator defaultCredentialValidator, RepositoryService repositoryService, Validator validator) {
        this.defaultCredentialValidator = defaultCredentialValidator;
        this.repositoryService = repositoryService;
        this.logger = LoggerFactory.getLogger(CredentialServiceImpl.class);
    }
}

