/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.SatelliteService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.Paging$;
import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator$;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.satellite.ExtensionsDelta$;
import com.xebialabs.deployit.plugin.satellite.InstalledExtensionsDelta;
import com.xebialabs.deployit.plugin.satellite.SatelliteCommunicatorSystem$;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker$;
import com.xebialabs.deployit.plugin.satellite.extension.ExtensionsLocator;
import com.xebialabs.deployit.plugin.satellite.extension.FileSystemExtensionsLocator$;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SqlSatelliteService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.satellite.protocol.Paths$;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\b\u0011\u0001uA\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!)a\b\u0001C\u0001\u007f!91\u000b\u0001b\u0001\n\u0003!\u0006BB0\u0001A\u0003%Q\u000bC\u0003m\u0001\u0011\u0005Q\u000eC\u0005\u0002\u0006\u0001\u0011\r\u0011b\u0001\u0002\b!9\u0011\u0011\u0002\u0001!\u0002\u0013Q\b\"CA\u0006\u0001\t\u0007I1AA\u0007\u0011!\t9\u0002\u0001Q\u0001\n\u0005=\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011\u001d\t9\u0006\u0001C!\u00033Bq!a#\u0001\t\u0003\niIA\tTCR,G\u000e\\5uKJ+7o\\;sG\u0016T!!\u0005\n\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0014)\u0005!!/Z:u\u0015\t)b#\u0001\u0003d_J,'BA\f\u0019\u0003!!W\r\u001d7ps&$(BA\r\u001b\u0003%AXMY5bY\u0006\u00147OC\u0001\u001c\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001a\u0004J\u0016\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0012aB:fGV\u0014X\rZ\u0005\u0003G\u0001\u0012q#\u00112tiJ\f7\r^*fGV\u0014X\r\u001a*fg>,(oY3\u0011\u0005\u0015JS\"\u0001\u0014\u000b\u0005E9#B\u0001\u0015\u0017\u0003\u0019)gnZ5oK&\u0011!F\n\u0002\u0011'\u0006$X\r\u001c7ji\u0016\u001cVM\u001d<jG\u0016\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u000bMdg\r\u000e6\u000b\u0003A\n\u0001b\u001a:jujdW\rZ\u0005\u0003e5\u0012q\u0001T8hO&tw-A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\f\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002:m\t\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3\u0002'M\fHnU1uK2d\u0017\u000e^3TKJ4\u0018nY3\u0011\u0005Ub\u0014BA\u001f7\u0005M\u0019\u0016\u000f\\*bi\u0016dG.\u001b;f'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\u0019\u0001IQ\"\u0011\u0005\u0005\u0003Q\"\u0001\t\t\u000bM\u001a\u0001\u0019\u0001\u001b\t\u000bi\u001a\u0001\u0019A\u001e)\u0005\r)\u0005C\u0001$R\u001b\u00059%B\u0001%J\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0015.\u000bqAZ1di>\u0014\u0018P\u0003\u0002M\u001b\u0006)!-Z1og*\u0011ajT\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001+A\u0002pe\u001eL!AU$\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\u0003:fgB|gn]3\u0016\u0003U\u0003\"AV/\u000e\u0003]S!\u0001W-\u0002\u0007M\u0004\u0018N\u0003\u0002[7\u0006A!/Z:uK\u0006\u001c\u0018P\u0003\u0002]\u001f\u0006)!NY8tg&\u0011al\u0016\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\ne\u0016\u001c\bo\u001c8tK\u0002B#!B1\u0011\u0005\tTW\"A2\u000b\u0005U!'BA3g\u0003\t\u00118O\u0003\u0002hQ\u0006\u0011qo\u001d\u0006\u0002S\u0006)!.\u0019<bq&\u00111n\u0019\u0002\b\u0007>tG/\u001a=u\u0003I!WMZ1vYR\u0004\u0016N\\4US6,w.\u001e;\u0015\u00059D\bCA8w\u001b\u0005\u0001(BA9s\u0003!!WO]1uS>t'BA:u\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0002k\u0006)1oY1mC&\u0011q\u000f\u001d\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011\u0015Ih\u00011\u0001{\u0003m\u0019\u0018\r^3mY&$XmQ8n[Vt\u0017nY1u_J\u001c\u0016p\u001d;f[B\u001910!\u0001\u000e\u0003qT!! @\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003}\fA!Y6lC&\u0019\u00111\u0001?\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\fC\u000e$xN]*zgR,W.F\u0001{\u00031\t7\r^8s'f\u001cH/Z7!\u0003)!\u0017n\u001d9bi\u000eDWM]\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00145\t!/C\u0002\u0002\u0016I\u0014\u0001$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s\u0003-!\u0017n\u001d9bi\u000eDWM\u001d\u0011\u0002\u000f\u001d,G/\u00138g_R!\u0011QDA\u0015!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012M\u0005\u0019A\r^8\n\t\u0005\u001d\u0012\u0011\u0005\u0002\u000e'\u0006$X\r\u001c7ji\u0016LeNZ8\t\u000f\u0005-2\u00021\u0001\u0002.\u0005!1-[%e!\u0011\ty#!\u0010\u000f\t\u0005E\u0012\u0011\b\t\u0004\u0003g!XBAA\u001b\u0015\r\t9\u0004H\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005mB/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u007f\t\tE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003w!\u0018\u0001E1sKBcWoZ5ogNKhnY3e)\u0011\t9%!\u0016\u0011\r\u0005%\u00131JA(\u001b\u0005!\u0018bAA'i\n1q\n\u001d;j_:\u0004B!!\u0013\u0002R%\u0019\u00111\u000b;\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0006\u0007A\u0002\u00055\u0012!\u00037jgRDun\u001d;t))\tY&!\u001d\u0002t\u0005]\u0014\u0011\u0011\t\u0007\u0003;\n9'a\u001b\u000e\u0005\u0005}#\u0002BA1\u0003G\nA!\u001e;jY*\u0011\u0011QM\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002j\u0005}#\u0001\u0002'jgR\u0004B!a\b\u0002n%!\u0011qNA\u0011\u0005M\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\\%e\u0011\u001d\tY#\u0004a\u0001\u0003[Aq!!\u001e\u000e\u0001\u0004\ti#\u0001\u0003oC6,\u0007bBA=\u001b\u0001\u0007\u00111P\u0001\u0007a\u0006<\u0017N\\4\u0011\t\u0005}\u0011QP\u0005\u0005\u0003\u007f\n\tC\u0001\u0004QC\u001eLgn\u001a\u0005\b\u0003\u0007k\u0001\u0019AAC\u0003\u0015y'\u000fZ3s!\u0011\ty\"a\"\n\t\u0005%\u0015\u0011\u0005\u0002\t\u001fJ$WM]5oO\u0006Q1m\\;oi\"{7\u000f^:\u0015\r\u0005=\u00151TAO!\u0011\t\t*a&\u000e\u0005\u0005M%\u0002BAK\u0003G\nA\u0001\\1oO&!\u0011\u0011TAJ\u0005\u001dIe\u000e^3hKJDq!a\u000b\u000f\u0001\u0004\ti\u0003C\u0004\u0002v9\u0001\r!!\f)\u0007\u0001\t\t\u000b\u0005\u0003\u0002$\u0006%VBAAS\u0015\r\t9+T\u0001\u000bgR,'/Z8usB,\u0017\u0002BAV\u0003K\u0013!bQ8oiJ|G\u000e\\3s\u0001")
public class SatelliteResource
extends AbstractSecuredResource
implements SatelliteService,
Logging {
    private final RepositoryService repositoryService;
    private final SqlSatelliteService sqlSatelliteService;
    @Context
    private final HttpResponse response;
    private final ActorSystem actorSystem;
    private final ExecutionContextExecutor dispatcher;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SatelliteResource satelliteResource = this;
        synchronized (satelliteResource) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public HttpResponse response() {
        return this.response;
    }

    public FiniteDuration defaultPingTimeout(ActorSystem satelliteCommunicatorSystem) {
        return ((CommonSettings)CommonSettings$.MODULE$.apply(satelliteCommunicatorSystem)).satellite().infoTimeout().duration();
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public ExecutionContextExecutor dispatcher() {
        return this.dispatcher;
    }

    public SatelliteInfo getInfo(String ciId) {
        Timeout timeout = new Timeout(this.defaultPingTimeout(this.actorSystem()));
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return null;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        ActorRef checker = SatelliteCommunicatorSystem$.MODULE$.actorSystem().actorOf(SatelliteInfoChecker$.MODULE$.props(satellite.getAddress()));
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(checker);
        SatelliteInfoChecker.Get x$1 = new SatelliteInfoChecker.Get(actorLocator.locate(Paths$.MODULE$.info(), this.actorSystem()));
        Timeout x$2 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        Future future = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3).recover((PartialFunction)new scala.Serializable(this, satellite){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SatelliteResource $outer;
            private final Satellite satellite$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Operation failed on satellite ").append($this.satellite$1.getAddress()).append(" (").append(A1.getMessage()).append(")").toString());
                SatelliteInfo satelliteInfo = new SatelliteInfo();
                return (B1)satelliteInfo;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.satellite$1 = satellite$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.deployit.core.rest.api.SatelliteResource$$anonfun$1 java.lang.Throwable )}, serializedLambda);
            }
        }, (ExecutionContext)this.dispatcher());
        SatelliteInfo satelliteInfo = (SatelliteInfo)Await$.MODULE$.result((Awaitable)future, package.DoubleMult$.MODULE$.$times$extension(package$.MODULE$.DoubleMult(1.5), (Duration)this.defaultPingTimeout(this.actorSystem())));
        Option<Object> option = this.arePluginsSynced(ci.getId());
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            boolean pluginSync = BoxesRunTime.unboxToBoolean((Object)some.value());
            if (Predef$.MODULE$.Boolean2boolean(satelliteInfo.isAvailable())) {
                satelliteInfo.setPluginsSynced(Predef$.MODULE$.boolean2Boolean(pluginSync));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        satelliteInfo.setSatelliteId(ciId);
        return satelliteInfo;
    }

    private Option<Object> arePluginsSynced(String ciId) {
        Option option;
        Timeout timeout = new Timeout(this.defaultPingTimeout(this.actorSystem()));
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return None$.MODULE$;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        try {
            InstalledExtensionsDelta deltas = ExtensionsDelta$.MODULE$.calculateExtensionsDelta((ExtensionsLocator)FileSystemExtensionsLocator$.MODULE$, actorLocator, this.actorSystem());
            option = new Some((Object)BoxesRunTime.boxToBoolean((boolean)deltas.empty()));
        }
        catch (Exception exception) {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public List<ConfigurationItemId> listHosts(String ciId, String name, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        Integer totalCount = this.countHosts(ciId, name);
        this.response().getOutputHeaders().putSingle((Object)Paging$.MODULE$.X_TOTAL_COUNT_HEADER(), (Object)totalCount);
        return this.sqlSatelliteService.listHosts(ciId, name, paging, order);
    }

    public Integer countHosts(String ciId, String name) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        return Predef$.MODULE$.int2Integer(this.sqlSatelliteService.countHosts(ciId, name));
    }

    @Autowired
    public SatelliteResource(RepositoryService repositoryService, SqlSatelliteService sqlSatelliteService) {
        this.repositoryService = repositoryService;
        this.sqlSatelliteService = sqlSatelliteService;
        Logging.$init$((Logging)this);
        this.response = null;
        this.actorSystem = SatelliteCommunicatorSystem$.MODULE$.actorSystem();
        this.dispatcher = this.actorSystem().dispatcher();
    }
}

