/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.DeploymentWriter;
import com.xebialabs.deployit.core.rest.api.InvalidDeploymentException;
import com.xebialabs.deployit.core.rest.api.PermissionChecker;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Provisionable;
import com.xebialabs.deployit.plugin.api.udm.ProvisioningPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.dependency.DependencyService;
import com.xebialabs.deployit.service.dependency.DeploymentResult;
import com.xebialabs.deployit.service.deployment.DeployedService;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.deployment.ResolvedPlaceholderGenerator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.Dictionaries;
import com.xebialabs.deployit.service.version.VersionService;
import com.xebialabs.xlplatform.utils.Implicits;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Tuple2;
import scala.collection.immutable.List;

@Component
class DeploymentObjectGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentObjectGenerator.class);
    private final DeployedService deployedService;
    private final RepositoryService repositoryService;
    private final DependencyService dependencyService;
    private final VersionService versionService;
    private final PermissionChecker permissionChecker;

    @Autowired
    DeploymentObjectGenerator(DeployedService deployedService, RepositoryService repositoryService, DependencyService dependencyService, VersionService versionService, PermissionChecker permissionChecker) {
        this.deployedService = deployedService;
        this.repositoryService = repositoryService;
        this.dependencyService = dependencyService;
        this.permissionChecker = permissionChecker;
        this.versionService = versionService;
    }

    Deployment forInitial(Version version, Environment env) {
        if (this.isDependencyResolutionEnabled()) {
            return this.mainDeployment(this.generateMultiDeployments(version, env));
        }
        return this.generateInitialDeployment(version, env, Collections.emptyMap());
    }

    Deployment forUpdate(DeployedApplication deployedApplication, Version newVersion, Environment env) {
        if (this.isDependencyResolutionEnabled()) {
            return this.mainDeployment(this.generateMultiDeployments(newVersion, env));
        }
        return this.generateUpdateDeployment(deployedApplication, newVersion);
    }

    private Deployment mainDeployment(java.util.List<java.util.List<Deployment>> deployments) {
        Deployment deployment = (Deployment)deployments.get(deployments.size() - 1).stream().findFirst().get();
        deployment.setGroupedRequiredDeployments(deployments.subList(0, deployments.size() - 1));
        return deployment;
    }

    private Deployment generateInitialDeployment(Version version, Environment env, Map<String, String> userProvidedPlaceholders) {
        ConsolidatedDictionary dictionary = Dictionaries.of((Environment)env).filterBy(version).withAdditionalEntries(userProvidedPlaceholders).consolidate();
        DeployedApplication deployedApplication = this.deployedService.generateDeployedApplication(Type.valueOf(DeployedApplication.class), version, env, dictionary);
        if (this.isProvisioning(version)) {
            deployedApplication.setUnresolvedPlaceholders(userProvidedPlaceholders);
        }
        Deployment deployment = DeploymentWriter.createDeployment(deployedApplication, Deployment.DeploymentType.INITIAL);
        ResolvedPlaceholderGenerator.generateAndAdd((Deployment)deployment, (ConsolidatedDictionary)dictionary);
        return deployment;
    }

    private java.util.List<java.util.List<Deployment>> generateMultiDeployments(Version newVersion, Environment environment) {
        ArrayList result = Lists.newArrayList();
        Tuple2 resolvedTuple = this.versionService.resolvePlaceHolder("dependencyResolution", newVersion, environment);
        String dependencyResolution = (String)resolvedTuple._1;
        ConsolidatedDictionary dictionary = (ConsolidatedDictionary)resolvedTuple._2;
        try {
            java.util.List possibleDeployments = Implicits.listOfListToJavaListOfList((List)this.dependencyService.resolveMultiDeployment(environment.getId(), newVersion, dependencyResolution));
            java.util.List deployedApplicationsIds = possibleDeployments.stream().flatMap(Collection::stream).filter(DeploymentResult::hasDeployedApplication).map(DeploymentResult::deployedApplicationId).collect(Collectors.toList());
            Map<String, DeployedApplication> deployedApplicationsMap = this.repositoryService.read(deployedApplicationsIds, Integer.MAX_VALUE, false).stream().collect(Collectors.toMap(ConfigurationItem::getId, ci -> this.castAndCheck((ConfigurationItem)ci, (Class)DeployedApplication.class)));
            possibleDeployments.forEach(pd -> {
                ArrayList deploymentResults = new ArrayList();
                pd.forEach(possibleDeployment -> {
                    if (possibleDeployment.hasDeployedApplication()) {
                        DeployedApplication deployedApplication = (DeployedApplication)deployedApplicationsMap.get(possibleDeployment.deployedApplicationId());
                        Deployment deployment = this.generateUpdateDeployment(deployedApplication, this.castAndCheck(this.repositoryService.read(possibleDeployment.udmVersionId()), Version.class));
                        ResolvedPlaceholderGenerator.generateAndAdd((Deployment)deployment, (ConsolidatedDictionary)dictionary);
                        deploymentResults.add(deployment);
                    } else {
                        Deployment deployment = this.generateInitialDeployment(this.castAndCheck(this.repositoryService.read(possibleDeployment.udmVersionId()), Version.class), environment, Collections.emptyMap());
                        ResolvedPlaceholderGenerator.generateAndAdd((Deployment)deployment, (ConsolidatedDictionary)dictionary);
                        deploymentResults.add(deployment);
                    }
                });
                result.add(deploymentResults);
            });
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDeploymentException(e.getMessage());
        }
        this.permissionChecker.checkPermission((Deployment)((java.util.List)result.get(result.size() - 1)).stream().findFirst().get(), result);
        return result;
    }

    private <T extends ConfigurationItem> T castAndCheck(ConfigurationItem ci, Class<T> clazz) {
        Checks.checkArgument((boolean)clazz.isAssignableFrom(ci.getClass()), (String)"%s is not a %s", (Object[])new Object[]{ci, clazz.getSimpleName()});
        return (T)((ConfigurationItem)clazz.cast(ci));
    }

    private Deployment generateUpdateDeployment(DeployedApplication previousDeployedApplication, Version newVersion) {
        logger.debug("Creating upgrade deployed application from: [{}] with new version [{}]", (Object)previousDeployedApplication, (Object)newVersion);
        ConsolidatedDictionary dictionary = Dictionaries.of((Environment)previousDeployedApplication.getEnvironment()).filterBy(newVersion).consolidate();
        GeneratedDeployeds upgradedDeployeds = this.deployedService.generateUpgradedDeployeds(previousDeployedApplication, newVersion);
        DeployedApplication updatedDeployedApplication = this.deployedService.generateUpdateDeployedApplication(previousDeployedApplication, newVersion, dictionary);
        logger.debug("Generated upgrade deployed application [{}] with version [{}] and env [{}]", new Object[]{updatedDeployedApplication, updatedDeployedApplication.getVersion(), updatedDeployedApplication.getEnvironment()});
        logger.debug("Upgrade deployed application contains [{}] deployeds", (Object)updatedDeployedApplication.getDeployeds());
        Deployment deployment = DeploymentWriter.createDeployment(updatedDeployedApplication, Deployment.DeploymentType.UPDATE);
        this.permissionChecker.checkPermission(deployment);
        updatedDeployedApplication.get$validationMessages().addAll(previousDeployedApplication.get$validationMessages());
        deployment.setDeployeds(DeploymentWriter.convertDeployeds(upgradedDeployeds.getDeployeds()));
        ResolvedPlaceholderGenerator.generateAndAdd((Deployment)deployment, (ConsolidatedDictionary)dictionary);
        return deployment;
    }

    private boolean isDependencyResolutionEnabled() {
        return ServerConfiguration.getInstance().isServerResolveApplicationDependencies();
    }

    private boolean isProvisioning(Version version) {
        return version instanceof ProvisioningPackage && Optional.ofNullable(version).filter(v -> v.getDeployables().stream().anyMatch(d -> d instanceof Provisionable)).isPresent();
    }
}

