/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.InternalReportProxy;
import com.xebialabs.deployit.core.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.core.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.AbstractTaskRestrictedResource;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.TaskWithStepsView;
import com.xebialabs.deployit.core.rest.api.reports.AggregatedDeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsForEnvironmentReport;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsStateBreakdownReport;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.widgets.WidgetRegistry;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.service.ReportGenerator;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.TaskReader;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ReportResource
extends AbstractTaskRestrictedResource
implements InternalReportProxy {
    @Context
    private HttpResponse response;
    @Autowired
    private DownloadResource downloadResource;

    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Report deploymentsForEnvironment(String environment, Date date) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)environment, (String)"environment");
        Checks.checkNotNull((Object)date, (String)"date");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"date");
        DeploymentsForEnvironmentReport report = new DeploymentsForEnvironmentReport(this.taskArchive);
        return report.report(environment, date.asDateTime());
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadDeploymentsForEnvironment(String environment, Date date) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Report report = this.deploymentsForEnvironment(environment, date);
        String fileName = String.format("deployments-%s-%s.csv", environment.replaceAll("/", "_"), ReportUtils.DATE_FORMAT.print((ReadableInstant)date.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, report, fileName);
    }

    @Deprecated
    public TaskWithSteps getTask(String taskId) {
        return new TaskWithStepsView((SerializableTask)this.retrieveTask(taskId, true));
    }

    public TaskWithBlock getTaskWithBlock(String taskId) {
        return this.retrieveTask(taskId, false);
    }

    public TaskWithBlock getTaskWithBlockAndSteps(String taskId) {
        return this.retrieveTask(taskId, true);
    }

    private TaskWithBlock retrieveTask(String taskId, boolean loadSteps) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        TaskReader taskReader = this.taskArchive.getTask(taskId);
        ArchivedTask t = loadSteps ? taskReader.fully() : taskReader.withoutSteps();
        this.checkAccessTo(t.getMetadata());
        return t;
    }

    public StepBlockState getStepBlock(String taskId, String blockId) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        TaskReader taskReader = this.taskArchive.getTask(taskId);
        this.checkAccessTo(taskReader.metadata());
        BlockState block = taskReader.block(blockId);
        if (block instanceof StepBlockState) {
            return (StepBlockState)block;
        }
        throw new DeployitException("Block [%s] from task [%s] is a composite block so it has no steps", new Object[]{blockId, taskId});
    }

    public Stream<ReportLine> getTaskReport(Date begin, Date end, Paging paging, List<Ordering> order, String filterType, List<String> users, List<String> states, String taskId, boolean onlySuccessful, List<ConfigurationItemId> configurationItemIds) {
        Paging limited = this.paginationService.getLimitedPaging(paging);
        ArchivedTaskSearchParameters searchParameters = this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, limited, order, filterType, users, states, null, null, taskId, configurationItemIds, ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful);
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response), () -> this.taskArchive.countTotalResults(searchParameters));
        return this.reportGenerator.streamTaskReport(searchParameters).map(DeploymentTaskReportLine::asReportLine);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, String filterType, List<String> users, List<String> states, String taskId, boolean onlySuccessful, List<ConfigurationItemId> configurationItemIds) {
        ArchivedTaskSearchParameters parameters = this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, new Paging(), Collections.emptyList(), filterType, users, states, null, null, taskId, configurationItemIds, ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful);
        Stream<ReportLine> report = this.reportGenerator.streamTaskReport(parameters).map(DeploymentTaskReportLine::asReportLine);
        String fileName = String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, report, fileName);
    }

    public Report deploymentsStateBreakdown(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        Checks.checkNotNull((Object)filterType, (String)"filterType");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkNotNull(configurationItemIds, (String)"configurationItemIds");
        DeploymentsStateBreakdownReport report = new DeploymentsStateBreakdownReport(this.taskArchive);
        FilterType reportFilterType = FilterType.valueOf((String)filterType.toUpperCase());
        return report.report(reportFilterType, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    public String downloadDeploymentsStateBreakdown(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Report report = this.deploymentsStateBreakdown(filterType, begin, end, configurationItemIds);
        String fileName = String.format("deployments-by-state-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, report, fileName);
    }

    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Report deploymentsKeyIndicator(Date begin, Date end, String filterType, List<ConfigurationItemId> configurationItemIds) {
        FilterType filter;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        DeploymentsKeyIndicator report = new DeploymentsKeyIndicator(this.taskArchive);
        report.getSearchParameters().createdBetween(begin.asDateTime(), end.asDateTime());
        if (filterType != null && (filter = FilterType.valueOf((String)filterType.toUpperCase())) != FilterType.NONE) {
            report.getSearchParameters().forFilterType(filter, configurationItemIds);
        }
        return report.report();
    }

    public Stream<ReportLine> getControlTasksReport(Date begin, Date end, Paging paging, List<Ordering> order) {
        Paging limited = this.paginationService.getLimitedPaging(paging);
        ArchivedTaskSearchParameters searchParameters = this.reportGenerator.buildTaskSearchParameters(limited, order, EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
        searchParameters.inDateTimeRange(this.reportGenerator.safeDateTime(begin, null), this.reportGenerator.safeDateTime(end, null));
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response), () -> this.taskArchive.countTotalResults(searchParameters));
        return this.reportGenerator.streamControlTasksReport(searchParameters).map(ControlTaskReportLine::asReportLine);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end) {
        ArchivedTaskSearchParameters searchParameters = this.reportGenerator.buildTaskSearchParameters(new Paging(), Collections.emptyList(), EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
        searchParameters.inDateTimeRange(this.reportGenerator.safeDateTime(begin, null), this.reportGenerator.safeDateTime(end, null));
        Stream<ReportLine> report = this.reportGenerator.streamControlTasksReport(searchParameters).map(ControlTaskReportLine::asReportLine);
        return ReportUtils.createDownloadToken(this.downloadResource, report, this.reportGenerator.buildControlTaskReportFileName(begin, end));
    }

    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Report deploymentsKeyIndicatorAggregatedByFilterType(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)filterType, (String)"filterType");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkNotNull(configurationItemIds, (String)"configurationItemIds");
        FilterType reportFilterType = FilterType.valueOf((String)filterType.toUpperCase());
        AggregatedDeploymentsKeyIndicator report = new AggregatedDeploymentsKeyIndicator(this.taskArchive);
        report.getSearchParameters().createdBetween(new DateTime((Object)begin.getCalendar()), new DateTime((Object)end.getCalendar()));
        return report.report(reportFilterType, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadDeploymentsKeyIndicator(String filterType, Date begin, Date end, List<ConfigurationItemId> cis) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Report report = this.deploymentsKeyIndicator(begin, end, filterType, cis);
        String fileName = String.format("deployments-key-indicator-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, report, fileName);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadDeploymentsKeyIndicatorAggregatedByFilterType(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Report report = this.deploymentsKeyIndicatorAggregatedByFilterType(filterType, begin, end, configurationItemIds);
        String fileName = String.format("aggregated-deployments-key-indicator-%s-%s-%s.csv", filterType, ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, report, fileName);
    }

    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Report getDashboardWidgetReport(String widget, Date begin, Date end) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)widget, (String)"widget");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkArgument((begin.getCalendar().getTime().compareTo(end.getCalendar().getTime()) <= 0 ? 1 : 0) != 0, (String)"begin must be before end", (Object[])new Object[0]);
        return WidgetRegistry.valueOf(WidgetRegistry.class, widget.toUpperCase()).getWidget(this.taskArchive).getReport(begin.asDateTime(), end.asDateTime());
    }

    public List<ConfigurationItemId> listEnvironments() {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        List environments = this.taskArchive.getAllArchivedEnvironments();
        Collections.sort(environments);
        return environments.stream().map(input -> new ConfigurationItemId(input, Type.valueOf((String)"udm.Environment"))).collect(Collectors.toList());
    }

    public void setTaskArchive(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setDownloadResource(DownloadResource downloadResource) {
        this.downloadResource = downloadResource;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }
}

