/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.typesafe.config.ConfigException;
import com.xebialabs.deployit.configuration.XldProductConfiguration;
import com.xebialabs.deployit.core.api.XlDeployConfigurationService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class XlDeployConfigurationResource
implements XlDeployConfigurationService {
    private static final String GUI_TOASTR_ERROR_TIMEOUT = "gui.toastr.error.timeout-ms";
    private static final String GUI_TOASTR_INFO_TIMEOUT = "gui.toastr.info.timeout-ms";
    private static final String GUI_TOASTR_SUCCESS_TIMEOUT = "gui.toastr.success.timeout-ms";
    private static final String GUI_TOASTR_WARNING_TIMEOUT = "gui.toastr.warning.timeout-ms";
    private static final String GUI_LANDING_PAGE = "gui.landing-page";
    private static final String GUI_TASK_STATUS_POLL_INTERVAL = "gui.task.status.poll-interval-ms";
    private static final int DEFAULT_GUI_TOASTR_TIMEOUT = 10000;
    private static final int DEFAULT_GUI_TOASTR_ERROR_TIMEOUT = 0;
    private static final int DEFAULT_GUI_TASK_STATUS_POLL_INTERVAL = 1000;
    private static final String DEFAULT_GUI_LANDING_PAGE = "explorer";
    private XldProductConfiguration xlConfiguration;

    @Autowired
    public XlDeployConfigurationResource(XldProductConfiguration xlConfiguration) {
        this.xlConfiguration = xlConfiguration;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(GUI_TOASTR_ERROR_TIMEOUT, Integer.toString(this.getConfigInt(GUI_TOASTR_ERROR_TIMEOUT, 0)));
        properties.put(GUI_TOASTR_INFO_TIMEOUT, Integer.toString(this.getConfigInt(GUI_TOASTR_INFO_TIMEOUT, 10000)));
        properties.put(GUI_TOASTR_SUCCESS_TIMEOUT, Integer.toString(this.getConfigInt(GUI_TOASTR_SUCCESS_TIMEOUT, 10000)));
        properties.put(GUI_TOASTR_WARNING_TIMEOUT, Integer.toString(this.getConfigInt(GUI_TOASTR_WARNING_TIMEOUT, 10000)));
        properties.put(GUI_LANDING_PAGE, this.getConfigString(GUI_LANDING_PAGE, DEFAULT_GUI_LANDING_PAGE));
        properties.put(GUI_TASK_STATUS_POLL_INTERVAL, Integer.toString(this.getConfigInt(GUI_TASK_STATUS_POLL_INTERVAL, 1000)));
        return properties;
    }

    private int getConfigInt(String key, int defaultValue) {
        try {
            return this.xlConfiguration.configuration().getInt(this.prefixKey(key));
        }
        catch (ConfigException.Missing | ConfigException.WrongType ex) {
            return defaultValue;
        }
    }

    private String getConfigString(String key, String defaultValue) {
        try {
            return this.xlConfiguration.configuration().getString(this.prefixKey(key));
        }
        catch (ConfigException.Missing | ConfigException.WrongType ex) {
            return defaultValue;
        }
    }

    private String prefixKey(String key) {
        return "xl." + key;
    }
}

