/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.reports.mapper.ReportToCsvMapper;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUtils {
    private static final Logger log = LoggerFactory.getLogger(ReportUtils.class);
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMdd");
    static final PeriodFormatter HH_MM_SS = new PeriodFormatterBuilder().minimumPrintedDigits(2).printZeroAlways().appendHours().appendSeparator(":").appendMinutes().appendSeparator(":").appendSeconds().toFormatter();

    private ReportUtils() {
    }

    static final String formatToHoursMinsSecs(long millis) {
        Period period = new Duration(millis).toPeriod();
        return HH_MM_SS.print((ReadablePeriod)period);
    }

    public static Stream<String> toCsv(Set<String> fields, Stream<ReportLine> report) {
        return new ReportToCsvMapper(report, fields).getCsv();
    }

    public static List<DateTime> getMonthsOfInterval(DateTime begin, DateTime end) {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        DateTime current = begin;
        while (current.isBefore((ReadableInstant)end) || current.isEqual((ReadableInstant)begin)) {
            result.add(current);
            current = current.plusMonths(1);
        }
        return result;
    }

    public static String createDownloadToken(DownloadResource downloadResource, Stream<ReportLine> reportLines, String fileName) {
        return ReportUtils.createDownloadToken(downloadResource, null, reportLines, fileName);
    }

    public static String createDownloadToken(DownloadResource downloadResource, Set<String> firstRowFields, Stream<ReportLine> reportLines, String fileName) {
        try {
            File to = new File(WorkdirHolder.get().getPath(), fileName);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(to), Charset.defaultCharset()));
                 Stream<String> s = ReportUtils.toCsv(firstRowFields, reportLines);){
                s.forEachOrdered(line -> {
                    try {
                        writer.write((String)line);
                        writer.write(10);
                    }
                    catch (IOException io) {
                        throw new RuntimeException(io);
                    }
                });
            }
            return downloadResource.register(to, "text/csv");
        }
        catch (Exception re) {
            log.error("Oops!", (Throwable)re);
            WorkdirHolder.get().delete();
            throw new IllegalStateException(re);
        }
    }

    public static String createDownloadToken(DownloadResource downloadResource, Report report, String fileName) {
        return ReportUtils.createDownloadToken(downloadResource, report.getLines().stream(), fileName);
    }
}

