package com.xebialabs.deployit.core.api;

import ai.digital.deploy.sql.model.ActiveUserSession;
import ai.digital.deploy.sql.model.UserSessionsOverview;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;

@Path("/session")
@Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
@Consumes({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
public interface SessionService {

    @GET
    @Path("active")
    List<ActiveUserSession> getActiveSessions(
            @QueryParam("principalPattern") String principalPattern,
            @BeanParam Paging paging,
            @QueryParam("order") Ordering order
    );

    @GET
    @Path("overview")
    UserSessionsOverview getSessionsOverview();
}
