package com.xebialabs.deployit.core.api;

import ai.digital.deploy.sql.model.AddUserCredentials;
import ai.digital.deploy.sql.model.IdDto;
import ai.digital.deploy.sql.model.UpdateUserCredentials;
import ai.digital.deploy.sql.model.UserCredentialsView;
import org.springframework.web.bind.annotation.RequestBody;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import java.util.Set;

@Path("user/credentials")
@Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
public interface XldUserCredentialsService {
    @GET
    @Path("{username}")
    Set<UserCredentialsView> listUserCredentials(@PathParam("username") String username);

    @GET
    @Path("{username}/default")
    UserCredentialsView getDefaultUserCredentials(@PathParam("username") String username);

    @POST
    @Path("{username}")
    IdDto<Long> saveUserCredentials(@PathParam("username") String username, @RequestBody AddUserCredentials credentials);

    @PUT
    @Path("{username}")
    IdDto<Long> updateUserCredentials(@PathParam("username") String username, @RequestBody UpdateUserCredentials credentials);

}
