/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.security.User;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.security.dto.PasswordValidationResult;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import java.util.List;

/**
 * Manages users in XL Deploy's.
 * 1. Create and Update [fullName, email and password] internal users.
 * 2. Update [fullName and email] external user [fullName and email].
 *
 * */
@Path("/security/user")
@Consumes({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
@Produces({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
@PublicApi
public interface DeployUserService  extends UserService {

    /**
     * Update existing user [internal/external].
     * @permission security#edit
     * @param username
     * @param user: {"password":"","username":"","userProfile":{"email":"","fullName":"","loginAllowed":true}}
     * @return
     */
    @PUT
    @Path("{username}/update")
    void updateUser(@PathParam("username") String username, User user);

    /**
     * List all users [internal/external]
     * @permission security#edit or security#view
     * returns list of users with the given username, fullName and email.
     * */
    @GET
    @Path("/list")
    List<User> listAllUserProfiles(
            @QueryParam("username") String username,
            @QueryParam("fullName") String fullName,
            @QueryParam("email") String email,
            @BeanParam Paging paging,
            @QueryParam("order") Ordering order);

}
