/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.controltask;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.deployment.planner.ExecutablePlan;
import com.xebialabs.deployit.deployment.planner.PhasedPlan;
import com.xebialabs.deployit.deployment.planner.PlanPhase;
import com.xebialabs.deployit.deployment.planner.Plans$;
import com.xebialabs.deployit.deployment.planner.Satellites$;
import com.xebialabs.deployit.deployment.planner.SerialPlan;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.engine.spi.event.TaskCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskStartedEvent;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.OnTaskFailurePolicy;
import com.xebialabs.deployit.plugin.api.udm.OnTaskSuccessPolicy;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItemWithPolicies;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.service.controltask.ControlTaskService;
import com.xebialabs.deployit.service.controltask.InvalidControlException;
import com.xebialabs.deployit.service.externalproperties.ExternalPropertiesResolver;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\n\u0015\u0001}A\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\ti\u0001\u0011\t\u0011)A\u0005]!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u00038\u0011!q\u0004A!b\u0001\n\u0003y\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011!\u0003!Q1A\u0005\u0002%C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\u0006\u001d\u0002!\ta\u0014\u0005\u0006O\u0002!\t\u0005\u001b\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\t\u0019\b\u0001C!\u0003kBq!a \u0001\t\u0003\n\t\t\u0003\u0005\u0002\u0010\u0002!\t\u0001FAI\u0011!\t9\u000e\u0001Q\u0005\n\u0005e\u0007\u0002CA{\u0001\u0001&I!a>\t\u0011\t\u0015\u0001\u0001)C\u0005\u0005\u000fA\u0001B!\u0002\u0001A\u0013%!q\u0002\u0002\u0017\u0007>tGO]8m)\u0006\u001c8nU3sm&\u001cW-S7qY*\u0011QCF\u0001\fG>tGO]8mi\u0006\u001c8N\u0003\u0002\u00181\u000591/\u001a:wS\u000e,'BA\r\u001b\u0003!!W\r\u001d7ps&$(BA\u000e\u001d\u0003%AXMY5bY\u0006\u00147OC\u0001\u001e\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001\u0005\u000b\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019y%M[3diB\u0011\u0011FK\u0007\u0002)%\u00111\u0006\u0006\u0002\u0013\u0007>tGO]8m)\u0006\u001c8nU3sm&\u001cW-A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016,\u0012A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0003ca\t!B]3q_NLGo\u001c:z\u0013\t\u0019\u0004GA\tSKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\f!C]3q_NLGo\u001c:z'\u0016\u0014h/[2fA\u0005QR\r\u001f;fe:\fG\u000e\u0015:pa\u0016\u0014H/[3t%\u0016\u001cx\u000e\u001c<feV\tq\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;-\u0005\u0011R\r\u001f;fe:\fG\u000e\u001d:pa\u0016\u0014H/[3t\u0013\ta\u0014H\u0001\u000eFqR,'O\\1m!J|\u0007/\u001a:uS\u0016\u001c(+Z:pYZ,'/A\u000efqR,'O\\1m!J|\u0007/\u001a:uS\u0016\u001c(+Z:pYZ,'\u000fI\u0001\u0007K:<\u0017N\\3\u0016\u0003\u0001\u0003\"!Q#\u000e\u0003\tS!a\u0011#\u0002\rQ\f7o[3s\u0015\tq\u0004$\u0003\u0002G\u0005\n\u0019B+Y:l\u000bb,7-\u001e;j_:,enZ5oK\u00069QM\\4j]\u0016\u0004\u0013AD<pe.$\u0015N\u001d$bGR|'/_\u000b\u0002\u0015B\u0011qfS\u0005\u0003\u0019B\u0012abV8sW\u0012K'OR1di>\u0014\u00180A\bx_J\\G)\u001b:GC\u000e$xN]=!\u0003\u0019a\u0014N\\5u}Q)\u0001+U1dKB\u0011\u0011\u0006\u0001\u0005\u0006Y%\u0001\rA\f\u0015\u0003#N\u0003\"\u0001V0\u000e\u0003US!AV,\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002Y3\u00069a-Y2u_JL(B\u0001.\\\u0003\u0015\u0011W-\u00198t\u0015\taV,A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005q\u0016aA8sO&\u0011\u0001-\u0016\u0002\n\u0003V$xn^5sK\u0012DQ!N\u0005A\u0002]B#!Y*\t\u000byJ\u0001\u0019\u0001!)\u0005\r\u001c\u0006\"\u0002%\n\u0001\u0004Q\u0005FA3T\u0003\u001d\u0001(/\u001a9be\u0016$B![9\u0002\u0002A\u0011!n\\\u0007\u0002W*\u0011A.\\\u0001\u0004IR|'B\u00018E\u0003\r\t\u0007/[\u0005\u0003a.\u0014qaQ8oiJ|G\u000eC\u0003s\u0015\u0001\u00071/A\u0006d_:$(o\u001c7OC6,\u0007C\u0001;~\u001d\t)8\u0010\u0005\u0002ws6\tqO\u0003\u0002y=\u00051AH]8pizR\u0011A_\u0001\u0006g\u000e\fG.Y\u0005\u0003yf\fa\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011A0\u001f\u0005\u0007\u0003\u0007Q\u0001\u0019A:\u0002\u0005%$\u0017AD2sK\u0006$X\rV1tWN\u0003Xm\u0019\u000b\r\u0003\u0013\ty!!\u0007\u00020\u0005U\u0013q\f\t\u0004\u0003\u0006-\u0011bAA\u0007\u0005\n\tB+Y:l'B,7-\u001b4jG\u0006$\u0018n\u001c8\t\u000f\u0005E1\u00021\u0001\u0002\u0014\u00059qo\u001c:l\t&\u0014\bcA\u0018\u0002\u0016%\u0019\u0011q\u0003\u0019\u0003\u000f]{'o\u001b#je\"9\u00111D\u0006A\u0002\u0005u\u0011AA2j!\u0011\ty\"a\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t1!\u001e3n\u0015\rq\u0017q\u0005\u0006\u0004\u0003SA\u0012A\u00029mk\u001eLg.\u0003\u0003\u0002.\u0005\u0005\"!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\"9\u0011\u0011G\u0006A\u0002\u0005M\u0012aD2p]R\u0014x\u000e\u001c+bg.t\u0015-\\3\u0011\t\u0005U\u0012q\n\b\u0005\u0003o\tYE\u0004\u0003\u0002:\u0005%c\u0002BA\u001e\u0003\u000frA!!\u0010\u0002F9!\u0011qHA\"\u001d\r1\u0018\u0011I\u0005\u0002;%\u00111\u0004H\u0005\u00033iI!A\u0010\r\n\u0005\r#\u0015bAA'\u0005\u00069\u0001/Y2lC\u001e,\u0017\u0002BA)\u0003'\u0012a\u0001V1tW&#'bAA'\u0005\"9\u0011qK\u0006A\u0002\u0005e\u0013A\u00029be\u0006l7\u000f\u0005\u0003\u0002 \u0005m\u0013\u0002BA/\u0003C\u0011!\u0002U1sC6,G/\u001a:t\u0011\u001d\t\tg\u0003a\u0001\u0003G\nQa\\<oKJ\u0004B!!\u001a\u0002p5\u0011\u0011q\r\u0006\u0005\u0003S\nY'\u0001\u0003d_J,'bAA77\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002r\u0005\u001d$AD!vi\",g\u000e^5dCRLwN\\\u0001\u0007GJ,\u0017\r^3\u0015\u000fM\f9(a\u001f\u0002~!1\u0011\u0011\u0010\u0007A\u0002%\fqaY8oiJ|G\u000eC\u0004\u0002b1\u0001\r!a\u0019\t\u000f\u0005EA\u00021\u0001\u0002\u0014\u0005)1\u000f^1siR!\u00111QAF!\u0011\t))a\"\u000e\u0003eL1!!#z\u0005\u0011)f.\u001b;\t\r\u00055U\u00021\u0001t\u0003\u0019!\u0018m]6JI\u0006\u0011\"-^5mI\u0016CXmY;uS>t\u0007\u000b\\1o)!\t\u0019*a)\u0002&\u0006\u001d\u0006\u0003BAK\u0003?k!!a&\u000b\t\u0005e\u00151T\u0001\ba2\fgN\\3s\u0015\r\ti\nG\u0001\u000bI\u0016\u0004Hn\\=nK:$\u0018\u0002BAQ\u0003/\u0013a\"\u0012=fGV$\u0018M\u00197f!2\fg\u000eC\u0004\u0002\u001c9\u0001\r!!\b\t\r\u0005Eb\u00021\u0001t\u0011\u001d\tIK\u0004a\u0001\u0003W\u000bQa\u001d;faN\u0004b!!,\u00026\u0006mf\u0002BAX\u0003gs1A^AY\u0013\u0005Q\u0018bAA's&!\u0011qWA]\u0005\u0011a\u0015n\u001d;\u000b\u0007\u00055\u0013\u0010\u0005\u0003\u0002>\u0006\rWBAA`\u0015\u0011\t\t-!\n\u0002\t\u0019dwn^\u0005\u0005\u0003\u000b\fyL\u0001\u0003Ti\u0016\u0004\bf\u0002\b\u0002J\u0006=\u0017\u0011\u001b\t\u0004C\u0005-\u0017bAAgE\t\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003'\f#!!6\u0002\u0007\u0005dG.A\btCR,G\u000e\\5uK>37\u000b^3q)\u0011\tY.!=\u0011\r\u0005\u0015\u0015Q\\Aq\u0013\r\ty.\u001f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\r\u0018Q^\u0007\u0003\u0003KTA!a:\u0002j\u0006I1/\u0019;fY2LG/\u001a\u0006\u0004\u0003WT\u0012A\u0003=ma2\fGOZ8s[&!\u0011q^As\u0005%\u0019\u0016\r^3mY&$X\rC\u0004\u0002t>\u0001\r!a/\u0002\tM$X\r]\u0001\rCN\u0004\u0006.Y:fIBc\u0017M\u001c\u000b\u0007\u0003s\fyP!\u0001\u0011\t\u0005U\u00151`\u0005\u0005\u0003{\f9J\u0001\u0006QQ\u0006\u001cX\r\u001a)mC:Da!!\r\u0011\u0001\u0004\u0019\bb\u0002B\u0002!\u0001\u0007\u00111S\u0001\u0005a2\fg.\u0001\beKN\u001c'/\u001b9uS>tgi\u001c:\u0015\u000fM\u0014IAa\u0003\u0003\u000e!9\u00111D\tA\u0002\u0005u\u0001BBA\u0019#\u0001\u00071\u000fC\u0004\u0002hF\u0001\r!a7\u0015\u000bM\u0014\tBa\u0005\t\u000f\u0005m!\u00031\u0001\u0002\u001e!1\u0011\u0011\u0007\nA\u0002MD3\u0001\u0001B\f!\u0011\u0011IBa\b\u000e\u0005\tm!b\u0001B\u000f7\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t\u0005\"1\u0004\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class ControlTaskServiceImpl
implements ControlTaskService {
    private final RepositoryService repositoryService;
    private final ExternalPropertiesResolver externalPropertiesResolver;
    private final TaskExecutionEngine engine;
    private final WorkDirFactory workDirFactory;

    @Override
    public void createAndStart(String controlName, String id, Authentication owner, WorkDir workDir) {
        ControlTaskService.super.createAndStart(controlName, id, owner, workDir);
    }

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public ExternalPropertiesResolver externalPropertiesResolver() {
        return this.externalPropertiesResolver;
    }

    public TaskExecutionEngine engine() {
        return this.engine;
    }

    public WorkDirFactory workDirFactory() {
        return this.workDirFactory;
    }

    @Override
    public Control prepare(String controlName, String id) {
        ConfigurationItem configurationItem = this.repositoryService().read(id);
        this.externalPropertiesResolver().resolveExternalProperties(new ConfigurationItem[]{configurationItem});
        MethodDescriptor controlTask = (MethodDescriptor)Option$.MODULE$.apply((Object)configurationItem.getType().getDescriptor().getControlTask(controlName)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new InvalidControlException("Control [%s] could  not be found on type [%s]", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{controlName, configurationItem.getType()}));
        });
        None$ params = controlTask.getParameterObjectType() != null ? Option$.MODULE$.apply((Object)controlTask.getParameterObjectType().getDescriptor().newInstance("parameters")) : None$.MODULE$;
        return new Control(configurationItem, controlName, (Parameters)params.orNull(Predef$.MODULE$.$conforms()));
    }

    @Override
    public TaskSpecification createTaskSpec(WorkDir workDir, ConfigurationItem ci, String controlTaskName, Parameters params, Authentication owner) {
        Tuple2 tuple2;
        MethodDescriptor method = DescriptorRegistry.getDescriptor((Type)ci.getType()).getControlTask(controlTaskName);
        Checks.checkArgument((method != null ? 1 : 0) != 0, (String)"ConfigurationItem %s of type %s does not have a control task named %s.", (Object[])new Object[]{ci.getId(), ci.getType(), controlTaskName});
        java.util.List steps = (java.util.List)method.invoke(ci, params);
        ConfigurationItem configurationItem = ci;
        if (configurationItem instanceof BaseConfigurationItemWithPolicies) {
            BaseConfigurationItemWithPolicies baseConfigurationItemWithPolicies = (BaseConfigurationItemWithPolicies)configurationItem;
            tuple2 = new Tuple2((Object)baseConfigurationItemWithPolicies.getOnSuccessPolicy(), (Object)baseConfigurationItemWithPolicies.getOnFailurePolicy());
        } else {
            tuple2 = new Tuple2((Object)OnTaskSuccessPolicy.NOOP, (Object)OnTaskFailurePolicy.NOOP);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        OnTaskSuccessPolicy onSuccessPolicy = (OnTaskSuccessPolicy)tuple22._1();
        OnTaskFailurePolicy onFailurePolicy = (OnTaskFailurePolicy)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)onSuccessPolicy, (Object)onFailurePolicy);
        Tuple2 tuple24 = tuple23;
        OnTaskSuccessPolicy onSuccessPolicy2 = (OnTaskSuccessPolicy)tuple24._1();
        OnTaskFailurePolicy onFailurePolicy2 = (OnTaskFailurePolicy)tuple24._2();
        String desc = this.descriptionFor(ci, controlTaskName);
        PhasedPlan plan = this.asPhasedPlan(controlTaskName, this.buildExecutionPlan(ci, controlTaskName, (List<Step>)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(steps).toList()));
        PhasedPlan planForSatellites = Satellites$.MODULE$.prepareForSatelliteExecution(plan);
        PhaseContainer phaseContainer = Plans$.MODULE$.toBlockBuilder(planForSatellites).build();
        TaskSpecification taskSpec = new TaskSpecification(desc, owner, workDir, phaseContainer, onSuccessPolicy2, onFailurePolicy2);
        taskSpec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        ConfigurationItem currentCi = this.repositoryService().read(ci.getId());
        taskSpec.getMetadata().putAll(ImplicitConversions$.MODULE$.map$u0020AsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskType"), (Object)TaskType.CONTROL.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskName"), (Object)controlTaskName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskLabel"), (Object)method.getLabel()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controlTaskTargetCI"), (Object)ci.getId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controlTaskTargetInternalCI"), (Object)currentCi.get$internalId().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controlTaskTargetSecureCI"), Option$.MODULE$.apply((Object)currentCi.get$securedCi()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).orNull(Predef$.MODULE$.$conforms()))}))));
        return taskSpec;
    }

    @Override
    public String create(Control control, Authentication owner, WorkDir workDir) {
        ConfigurationItem ci = control.getConfigurationItem();
        String controlTaskName = control.getControlName();
        Parameters params = control.getParameters();
        TaskSpecification taskSpec = this.createTaskSpec(workDir, ci, controlTaskName, params, owner);
        String taskId = this.engine().register(taskSpec);
        EventBusHolder.publish((Object)new TaskCreatedEvent(taskId, controlTaskName, ci.getId()));
        return taskId;
    }

    @Override
    public void start(String taskId) {
        this.engine().execute(taskId);
        EventBusHolder.publish((Object)new TaskStartedEvent(taskId));
    }

    /*
     * Unable to fully structure code
     */
    public ExecutablePlan buildExecutionPlan(ConfigurationItem ci, String controlTaskName, List<Step> steps) {
        block4: {
            block3: {
                var6_4 = steps;
                if (Nil$.MODULE$.equals(var6_4)) {
                    throw new IllegalStateException(new StringBuilder(39).append("Control task ").append(controlTaskName).append(" on ").append(ci.getId()).append(" resulted in no steps.").toString());
                }
                if (!(var6_4 instanceof .colon.colon)) break block3;
                var7_5 = (.colon.colon)var6_4;
                head = (Step)var7_5.head();
                var10_7 = new Tuple2(this.satelliteOfStep(head), (Object)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Step[]{head})));
                aggregator = Nil$.MODULE$.$colon$colon((Object)var10_7);
                folded = (List)((LinearSeqOptimized)steps.tail()).foldLeft((Object)aggregator, (Function2)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildExecutionPlan$1(com.xebialabs.deployit.service.controltask.ControlTaskServiceImpl scala.collection.immutable.List com.xebialabs.deployit.plugin.api.flow.Step ), (Lscala/collection/immutable/List;Lcom/xebialabs/deployit/plugin/api/flow/Step;)Lscala/collection/immutable/List;)((ControlTaskServiceImpl)this));
                builders = ((List)folded.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildExecutionPlan$2(com.xebialabs.deployit.service.controltask.ControlTaskServiceImpl com.xebialabs.deployit.plugin.api.udm.ConfigurationItem java.lang.String scala.Tuple2 ), (Lscala/Tuple2;)Lcom/xebialabs/deployit/deployment/planner/StepPlan;)((ControlTaskServiceImpl)this, (ConfigurationItem)ci, (String)controlTaskName), List$.MODULE$.canBuildFrom())).reverse();
                var13_11 = builders;
                if (!(var13_11 instanceof .colon.colon)) ** GOTO lbl-1000
                var14_12 = (.colon.colon)var13_11;
                hd = (StepPlan)var14_12.head();
                var16_14 = var14_12.tl$access$1();
                if (Nil$.MODULE$.equals(var16_14)) {
                    var5_15 = hd;
                } else lbl-1000:
                // 2 sources

                {
                    var5_15 = new SerialPlan(this.descriptionFor(ci, controlTaskName), ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)var13_11), null);
                }
                break block4;
            }
            throw new MatchError(var6_4);
        }
        var4_16 = var5_15;
        return var4_16;
    }

    private Option<Satellite> satelliteOfStep(Step step) {
        return Option$.MODULE$.apply((Object)step).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Step, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                SatelliteAware satelliteAware;
                A1 A1 = x1;
                Object object = A1 instanceof SatelliteAware && (satelliteAware = (SatelliteAware)A1).getSatellite() != null ? satelliteAware.getSatellite() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Step x1) {
                SatelliteAware satelliteAware;
                Step step = x1;
                boolean bl = step instanceof SatelliteAware && (satelliteAware = (SatelliteAware)step).getSatellite() != null;
                return bl;
            }
        });
    }

    private PhasedPlan asPhasedPlan(String controlTaskName, ExecutablePlan plan) {
        PlanPhase phase = new PlanPhase(plan, new StringBuilder(25).append("Execute the ").append(controlTaskName).append(" control task").toString(), ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)Nil$.MODULE$), false);
        return new PhasedPlan(ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)new .colon.colon((Object)phase, (List)Nil$.MODULE$)), ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)Nil$.MODULE$));
    }

    private String descriptionFor(ConfigurationItem ci, String controlTaskName, Option<Satellite> satellite) {
        String string;
        Option<Satellite> option = satellite;
        if (option instanceof Some) {
            Some some = (Some)option;
            Satellite x = (Satellite)some.value();
            string = new StringBuilder(15).append(this.descriptionFor(ci, controlTaskName)).append(" (executed on ").append(x).append(")").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = this.descriptionFor(ci, controlTaskName);
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private String descriptionFor(ConfigurationItem ci, String controlTaskName) {
        return new StringBuilder(20).append("Control task [").append(controlTaskName).append("] for ").append(ci.getId()).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ List $anonfun$buildExecutionPlan$1(ControlTaskServiceImpl $this, List x0$1, Step x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            List acc = (List)tuple2._1();
            Step step = (Step)tuple2._2();
            Object object = ((Tuple2)acc.head())._1();
            Option<Satellite> option = $this.satelliteOfStep(step);
            if (!(object != null ? !object.equals(option) : option != null)) {
                ((BufferLike)((Tuple2)acc.head())._2()).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Step[]{step}));
                return acc;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        List acc = (List)tuple2._1();
        Step step = (Step)tuple2._2();
        Tuple2 tuple22 = new Tuple2($this.satelliteOfStep(step), (Object)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Step[]{step})));
        return acc.$colon$colon((Object)tuple22);
    }

    public static final /* synthetic */ StepPlan $anonfun$buildExecutionPlan$2(ControlTaskServiceImpl $this, ConfigurationItem ci$1, String controlTaskName$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option sat = (Option)tuple2._1();
        ArrayBuffer ss = (ArrayBuffer)tuple2._2();
        StepPlan stepPlan = new StepPlan($this.descriptionFor(ci$1, controlTaskName$1, (Option<Satellite>)sat), (Collection)ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)ss.toList()), ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)Nil$.MODULE$), (Satellite)sat.orNull(Predef$.MODULE$.$conforms()));
        return stepPlan;
    }

    public ControlTaskServiceImpl(@Autowired RepositoryService repositoryService, @Autowired ExternalPropertiesResolver externalPropertiesResolver, @Autowired TaskExecutionEngine engine, @Autowired WorkDirFactory workDirFactory) {
        this.repositoryService = repositoryService;
        this.externalPropertiesResolver = externalPropertiesResolver;
        this.engine = engine;
        this.workDirFactory = workDirFactory;
    }
}

