/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.discovery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.StepBlock;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.jdk.javaapi.CollectionConverters;

public class DiscoveryContext
implements TaskInspectionContext {
    private Task task;
    private Map<String, ConfigurationItem> discovered = Maps.newHashMap();
    private Map<String, ConfigurationItem> inspected = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryContext.class);

    public void registerTask(Task task) {
        this.task = task;
        for (ConfigurationItem configurationItem : Lists.newArrayList(this.discovered.values())) {
            Inspector.inspect((ConfigurationItem)configurationItem, (InspectionContext)this);
        }
    }

    public void discovered(ConfigurationItem item) {
        Preconditions.checkArgument((item.getId() != null ? 1 : 0) != 0, (Object)"Discovered configuration item must have an id set.");
        this.discovered.put(item.getId(), item);
    }

    public Map<String, ConfigurationItem> getDiscovered() {
        return this.discovered;
    }

    public void inspected(ConfigurationItem item) {
        if (this.discovered.remove(item.getId()) == null) {
            logger.warn("{} has been inspected without being discovered", (Object)item);
        }
        this.inspected.put(item.getId(), item);
    }

    public Map<String, ConfigurationItem> getInspected() {
        return this.inspected;
    }

    public void addStep(Step step) {
        Preconditions.checkState((this.task != null ? 1 : 0) != 0, (Object)"Task is not set.");
        logger.info("Adding discovery step {}", (Object)step);
        StepBlock block = (StepBlock)this.task.getBlock().getBlock(BlockPath.apply((String)"1_1")).getOrElse(null);
        block.steps().append(CollectionConverters.asScala((List)Lists.newArrayList((Object[])new StepState[]{new TaskStep(step)})).toSeq());
        logger.info("Block is in [{}] state", (Object)block.getState());
    }
}

