/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.discovery;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.google.common.base.Strings;
import com.xebialabs.deployit.engine.tasker.BlockBuilders$;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.service.discovery.DiscoveryContext;
import com.xebialabs.deployit.service.discovery.DiscoveryMessages;
import com.xebialabs.deployit.service.discovery.DiscoveryResult;
import com.xebialabs.deployit.service.discovery.DiscoveryResultsRetriever$;
import com.xebialabs.deployit.service.discovery.DiscoveryTrigger;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000514Aa\u0003\u0007\u0001/!Aa\u0004\u0001BC\u0002\u0013\u0005q\u0004\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003!\u0011!I\u0003A!b\u0001\n\u0003Q\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u0011=\u0002!\u0011!Q\u0001\nABQa\r\u0001\u0005\u0002QBqA\u000f\u0001C\u0002\u0013%!\u0006\u0003\u0004<\u0001\u0001\u0006Ia\u000b\u0005\u0006y\u0001!\t!\u0010\u0005\u00065\u0002!\ta\u0017\u0002\u0011\t&\u001c8m\u001c<fef\u001cVM\u001d<jG\u0016T!!\u0004\b\u0002\u0013\u0011L7oY8wKJL(BA\b\u0011\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0005\n\u0002\u0011\u0011,\u0007\u000f\\8zSRT!a\u0005\u000b\u0002\u0013a,'-[1mC\n\u001c(\"A\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-\u0001\u0004tsN$X-\\\u000b\u0002AA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0006C\u000e$xN\u001d\u0006\u0002K\u0005!\u0011m[6b\u0013\t9#EA\u0006BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000eI\u0001\u000eo>\u00148.\u001a:NC:\fw-\u001a:\u0016\u0003-\u0002\"!\t\u0017\n\u00055\u0012#\u0001C!di>\u0014(+\u001a4\u0002\u001d]|'o[3s\u001b\u0006t\u0017mZ3sA\u0005\u0019\u0012N\u001c)s_\u000e,7o\u001d+bg.,enZ5oKB\u0011\u0011$M\u0005\u0003ei\u0011qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0005k]B\u0014\b\u0005\u00027\u00015\tA\u0002C\u0003\u001f\r\u0001\u0007\u0001\u0005C\u0003*\r\u0001\u00071\u0006C\u00030\r\u0001\u0007\u0001'A\reSN\u001cwN^3ssJ+7/\u001e7ugJ+GO]5fm\u0016\u0014\u0018A\u00073jg\u000e|g/\u001a:z%\u0016\u001cX\u000f\u001c;t%\u0016$(/[3wKJ\u0004\u0013\u0001\u00059sKB\f'/\u001a#jg\u000e|g/\u001a:z)\rqdI\u0015\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000ba\u0001^1tW\u0016\u0014(BA\"\u0011\u0003\u0019)gnZ5oK&\u0011Q\t\u0011\u0002\u0012)\u0006\u001c8n\u00159fG&4\u0017nY1uS>t\u0007\"B$\n\u0001\u0004A\u0015AA2j!\tI\u0005+D\u0001K\u0015\tYE*A\u0002vI6T!!\u0014(\u0002\u0007\u0005\u0004\u0018N\u0003\u0002P!\u00051\u0001\u000f\\;hS:L!!\u0015&\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W\u000eC\u0003T\u0013\u0001\u0007A+A\u0004x_J\\G)\u001b:\u0011\u0005UCV\"\u0001,\u000b\u0005]\u0003\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011L\u0016\u0002\b/>\u00148\u000eR5s\u0003M9W\r\u001e#jg\u000e|g/\u001a:z%\u0016\u001cX\u000f\u001c;t)\tav\f\u0005\u00027;&\u0011a\f\u0004\u0002\u0010\t&\u001c8m\u001c<fef\u0014Vm];mi\")\u0001M\u0003a\u0001C\u00061A/Y:l\u0013\u0012\u0004\"AY5\u000f\u0005\r<\u0007C\u00013\u001b\u001b\u0005)'B\u00014\u0017\u0003\u0019a$o\\8u}%\u0011\u0001NG\u0001\u0007!J,G-\u001a4\n\u0005)\\'AB*ue&twM\u0003\u0002i5\u0001")
public class DiscoveryService {
    private final ActorSystem system;
    private final ActorRef workerManager;
    private final ActorRef discoveryResultsRetriever;

    public ActorSystem system() {
        return this.system;
    }

    public ActorRef workerManager() {
        return this.workerManager;
    }

    private ActorRef discoveryResultsRetriever() {
        return this.discoveryResultsRetriever;
    }

    public TaskSpecification prepareDiscovery(ConfigurationItem ci, WorkDir workDir) {
        DiscoveryContext inspectionContext = new DiscoveryContext();
        inspectionContext.discovered(ci);
        String description = new StringBuilder(14).append("Inspection of ").append(ci.getId()).toString();
        PhaseContainer stepBlock = BlockBuilders$.MODULE$.steps(description, (Option)None$.MODULE$, (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)).build();
        TaskSpecification spec = new TaskSpecification(description, Permissions.getAuthentication(), workDir, stepBlock, (TaskInspectionContext)inspectionContext, false);
        spec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        spec.getListeners().add(new DiscoveryTrigger(inspectionContext));
        TaskMetadata.putMetadata((TaskSpecification)spec, (String)"taskType", (String)TaskType.INSPECTION.name());
        return spec;
    }

    public DiscoveryResult getDiscoveryResults(String taskId) {
        Option<DiscoveryResult> option;
        Timeout timeout = Timeout$.MODULE$.apply(10L, TimeUnit.SECONDS);
        try {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.discoveryResultsRetriever());
            DiscoveryMessages.RetrieveResults x$1 = new DiscoveryMessages.RetrieveResults(taskId);
            Timeout x$2 = timeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            option = ((DiscoveryMessages.DiscoveryResultsFound)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)timeout.duration())).discoveryResult();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Could not find any results associated with the id [%s]", (Object[])new Object[]{taskId}));
        }
        Option<DiscoveryResult> discoveryResult = option;
        return (DiscoveryResult)discoveryResult.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Could not find any results associated with the id [%s]", (Object[])new Object[]{taskId}));
        });
    }

    public DiscoveryService(ActorSystem system, ActorRef workerManager, boolean inProcessTaskEngine) {
        this.system = system;
        this.workerManager = workerManager;
        this.discoveryResultsRetriever = system.actorOf(DiscoveryResultsRetriever$.MODULE$.props(workerManager, inProcessTaskEngine), DiscoveryResultsRetriever$.MODULE$.name());
    }
}

