/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.reader.ManifestReader;
import com.xebialabs.deployit.util.TFiles;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlManifestReader
implements ManifestReader {
    private Element element;

    @VisibleForTesting
    public XmlManifestReader() {
    }

    public XmlManifestReader(ImportSource source) {
        File packageFile = source.getFile();
        this.element = this.readXmlManifest(packageFile);
    }

    private Element readXmlManifest(File packageFile) {
        TFile manifest = new TFile(packageFile, "deployit-manifest.xml");
        try {
            Element element;
            TFileInputStream is = new TFileInputStream((File)manifest);
            try {
                element = this.buildManifestRoot((InputStream)is);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ImporterException(e, "Could not read manifest", new Object[0]);
                }
            }
            is.close();
            return element;
        }
        finally {
            TFiles.umountQuietly((TFile)manifest);
            TFiles.umountQuietly((TFile)new TFile(packageFile));
        }
    }

    Element buildManifestRoot(InputStream is) throws IOException {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    throw new IllegalArgumentException("External Entity is not allowed in the manifest file");
                }
            });
            return saxBuilder.build(is).getRootElement();
        }
        catch (JDOMException e) {
            throw new ImporterException(e, "Could not read manifest file, invalid xml.", new Object[0]);
        }
    }

    @Override
    public void readPackageData(PackageInfo packageInfo, ImportingContext context) {
        XmlManifestReader.check(!Strings.isBlank((String)this.element.getAttributeValue("application")), "Missing or empty required attribute 'application' in XML Manifest for [%s]", packageInfo.getSource().getFile().getName());
        XmlManifestReader.check(!Strings.isBlank((String)this.element.getAttributeValue("version")), "Missing or empty required attribute 'version' in XML Manifest for [%s]", packageInfo.getSource().getFile().getName());
        packageInfo.setApplicationName(this.element.getAttributeValue("application"));
        packageInfo.setApplicationVersion(this.element.getAttributeValue("version"));
        packageInfo.setApplicationRoot(this.versionReader().distributionType().getDescriptor().getRootName());
    }

    private static void check(boolean bool, String template, Object ... args) {
        if (!bool) {
            throw new ImporterException(template, args);
        }
    }

    @Override
    public ManifestReader.ManifestCiReader versionReader() {
        return new XmlManifestCiReader(this.element);
    }

    public static class XmlManifestCiReader
    implements ManifestReader.ManifestCiReader {
        private Element element;

        public XmlManifestCiReader(Element element) {
            this.element = element;
        }

        @Override
        public Type type() {
            return Type.valueOf((String)this.element.getName());
        }

        @Override
        public Type distributionType() {
            return this.getDistributionPropertyDescriptor().getReferencedType();
        }

        private PropertyDescriptor getDistributionPropertyDescriptor() {
            Descriptor versionDescriptor = this.type().getDescriptor();
            Optional<PropertyDescriptor> parentHolder = versionDescriptor.getPropertyDescriptors().stream().filter(pd -> pd.getKind() == PropertyKind.CI && pd.isAsContainment()).findFirst();
            return parentHolder.orElseThrow(() -> new IllegalStateException("Cannot find distribution type"));
        }

        @Override
        public String name() {
            if (Strings.isBlank((String)this.element.getAttributeValue("name"))) {
                throw new ImporterException("Missing or empty required attribute 'name' for CI '%s' in XML Manifest", this.element.getName());
            }
            return this.element.getAttributeValue("name");
        }

        @Override
        public String file() {
            return this.element.getAttributeValue("file");
        }

        @Override
        public boolean hasProperty(String name) {
            return this.element.getChild(name) != null;
        }

        @Override
        public List<String> allProperties() {
            return Lists.newArrayList((Iterable)Lists.transform((List)this.element.getChildren(), input -> input.getName()));
        }

        @Override
        public String propertyAsString(String name) {
            this.checkOneElement(name);
            return this.element.getChildTextTrim(name);
        }

        private void checkOneElement(String name) {
            XmlManifestReader.check(this.element.getChildren(name).size() == 1, "More than 1 element named '%s' found for CI '%s[%s]' in XML Manifest", name, this.element.getAttributeValue("name"), this.element.getName());
        }

        @Override
        public String propertyAsCiRef(String name) {
            this.checkOneElement(name);
            return this.element.getChild(name).getAttributeValue("ref");
        }

        @Override
        public List<String> propertyAsStringCollection(String name) {
            this.checkOneElement(name);
            ArrayList strings = Lists.newArrayList();
            for (Element value : this.element.getChild(name).getChildren("value")) {
                strings.add(value.getTextTrim());
            }
            String textValue = this.element.getChild(name).getTextTrim();
            if (strings.isEmpty() && !textValue.isEmpty()) {
                strings.add(textValue);
            }
            return strings;
        }

        @Override
        public List<String> propertyAsCiRefCollection(String name) {
            this.checkOneElement(name);
            ArrayList refs = Lists.newArrayList();
            for (Element ci : this.element.getChild(name).getChildren("ci")) {
                refs.add(ci.getAttributeValue("ref"));
            }
            return refs;
        }

        @Override
        public Map<String, String> propertyAsMapStringString(String name) {
            this.checkOneElement(name);
            HashMap map = Maps.newHashMap();
            for (Element entry : this.element.getChild(name).getChildren("entry")) {
                map.put(entry.getAttributeValue("key"), entry.getTextTrim());
            }
            return map;
        }

        @Override
        public List<ManifestReader.ManifestCiReader> propertyAsNestedCis(String name) {
            this.checkOneElement(name);
            List children = this.element.getChild(name).getChildren();
            return Lists.newArrayList((Iterable)Lists.transform((List)children, input -> new XmlManifestCiReader((Element)input)));
        }
    }
}

