package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.deployment.ResolvedPlaceholder;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.service.deployment.DeployedApplicationFactory.IncorrectDeployedException;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;
import java.util.Set;

class BasicDeployedGenerator implements DeployedGenerator {

    private final Logger logger = LoggerFactory.getLogger(BasicDeployedGenerator.class);

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        Type deployedType = deploymentContext.getTypeSupplier().getType(deployable, container);
        GeneratedDeployeds generatedDeployeds = new GeneratedDeployeds();
        if (deployedType != null) {
            generatedDeployeds.addDeployed(basicDeployed(deploymentContext, deployable, container, deployedType));
        }
        return generatedDeployeds;
    }

    private Deployed basicDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container, Type deployedType) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor(deployedType);
        ConsolidatedDictionary dictionary = deploymentContext.dictionaryFilteredByContainer(container);
        Deployed<Deployable, Container> deployed = deployedDesc.newInstance(deployedId(deploymentContext, deployable, container));
        deployed.setDeployable(deployable);
        deployed.setContainer(container);
        try {
            dictionary.resolveDeployedName(deployed);
        } catch (DictionaryValueException e) {
            throw new IncorrectDeployedException(e, "Couldn't generate name for deployed from [%s]", deployable.getName());
        }
        logger.debug("'{}' generated following deployeds [{}]", this.getClass().getName(), deployed.getName());
        final DeployedApplication deployedApplication = deploymentContext.getDeployedApplication();
        final Set<ResolvedPlaceholder> resolvedPlaceholders =
                ResolvedPlaceholderGenerator.generate(deployedApplication, dictionary, container.getId());
        deployedApplication.add$ResolvedPlaceholders(resolvedPlaceholders);
        return deployed;
    }

    private String deployedId(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        boolean deployableNameHasPlaceholders = MustachePlaceholderScanner.hasPlaceholders(deployable.getName());
        Optional<Deployed> existingDeployed =
                deploymentContext.getExistingDeployedSupplier().getExistingDeployedWithContainer(deployable, container);
        if (!existingDeployed.isPresent() || deployableNameHasPlaceholders) {
            return deploymentContext.getDeployedIdGenerator().generatedId(container, deployable);
        } else {
            return existingDeployed.get().getId();
        }
    }

}
