/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.spring;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskExecutionWorker$;
import com.xebialabs.deployit.engine.tasker.TaskFinalizer;
import com.xebialabs.deployit.engine.tasker.TaskFinalizerImpl;
import com.xebialabs.deployit.engine.tasker.TaskQueueService;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.distribution.versioning.ConfigurationHashProvider;
import com.xebialabs.deployit.engine.tasker.log.StepLogFactory;
import com.xebialabs.deployit.engine.tasker.log.StepLogRetriever;
import com.xebialabs.deployit.engine.tasker.query.QueryActor$;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.CrudTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.websockets.RemoteChangeSetEventListener$;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryService;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryWorker$;
import com.xebialabs.deployit.spring.BeanWrapper;
import com.xebialabs.deployit.spring.BeanWrapper$;
import com.xebialabs.deployit.spring.EngineBeanBuilder$;
import com.xebialabs.xlplatform.settings.shared.TaskerSettings;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Configuration
@Lazy
@DependsOn(value={"repositoryServiceHolder", "placeholderRepositoryHolder", "artifactResolver", "commandWhitelistValidator"})
@ScalaSignature(bytes="\u0006\u0005\tme\u0001B\u000f\u001f\u0001\u001dB\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tq\u0001\u0011\t\u0011)A\u0005a!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001dQ\u0006A1A\u0005\nmCaA\u0019\u0001!\u0002\u0013a\u0006\"B2\u0001\t\u0003\"\u0007\"C=\u0001\u0001\u0004\u0005\r\u0011\"\u0001{\u0011%q\b\u00011AA\u0002\u0013\u0005q\u0010\u0003\u0006\u0002\f\u0001\u0001\r\u0011!Q!\nmD\u0011\"a\u0007\u0001\u0005\u0004%\t!!\b\t\u0011\u0005U\u0002\u0001)A\u0005\u0003?A\u0011\"a\u000e\u0001\u0005\u0004%\t!!\u000f\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003wA\u0011\"!\u0012\u0001\u0005\u0004%\t!a\u0012\t\u0011\u0005}\u0003\u0001)A\u0005\u0003\u0013Bq!!\u0019\u0001\t\u0003\t\u0019\u0007\u0003\u00046\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!1\u0001\t\u0003\t\u0019\rC\u0004\u0003B\u0001!\tAa\u0011\t\u000f\t\u001d\u0003\u0001\"\u0003\u0003J\u001d9!1\u000f\u0010\t\u0002\tUdAB\u000f\u001f\u0011\u0003\u00119\b\u0003\u0004E5\u0011\u0005!\u0011\u0010\u0005\b\u0005wRB\u0011\u0001B?\u0005E)enZ5oK\n+\u0017M\u001c\"vS2$WM\u001d\u0006\u0003?\u0001\naa\u001d9sS:<'BA\u0011#\u0003!!W\r\u001d7ps&$(BA\u0012%\u0003%AXMY5bY\u0006\u00147OC\u0001&\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\bCJ\u001c\u0007.\u001b<f+\u0005\u0001\u0004CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0019!\u0018m]6fe*\u0011Q\u0007I\u0001\u0007K:<\u0017N\\3\n\u0005]\u0012$aB!sG\"Lg/Z\u0001\tCJ\u001c\u0007.\u001b<fA\u0005\t\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0016\u0003m\u0002\"\u0001P!\u000e\u0003uR!AP \u0002\u0011M,'O^5dKNT!\u0001\u0011\u001b\u0002\u0007M\u0004\u0018.\u0003\u0002C{\t\t\"+\u001a9pg&$xN]=GC\u000e$xN]=\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019C\u0005\f\u0005\u0002H\u00015\ta\u0004C\u0003/\u000b\u0001\u0007\u0001\u0007\u000b\u0002I\u0015B\u00111JV\u0007\u0002\u0019*\u0011QJT\u0001\u000bC:tw\u000e^1uS>t'BA(Q\u0003\u001d1\u0017m\u0019;pefT!!\u0015*\u0002\u000b\t,\u0017M\\:\u000b\u0005M#\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003U\u000b1a\u001c:h\u0013\t9FJA\u0005BkR|w/\u001b:fI\")\u0011(\u0002a\u0001w!\u0012\u0001LS\u0001\u0007Y><w-\u001a:\u0016\u0003q\u0003\"!\u00181\u000e\u0003yS!a\u0018+\u0002\u000bMdg\r\u000e6\n\u0005\u0005t&A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001a\t\u0003MZt!a\u001a;\u000f\u0005!\u001chBA5s\u001d\tQ\u0017O\u0004\u0002la:\u0011An\\\u0007\u0002[*\u0011aNJ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!a\t\u0013\n\u0005\u0005\u0012\u0013BA\u001b!\u0013\t\u0019D'\u0003\u0002ve\u00059\u0001/Y2lC\u001e,\u0017BA<y\u0005\u0019!\u0016m]6JI*\u0011QOM\u0001\u0014S:\u0004&o\\2fgN$\u0016m]6F]\u001eLg.Z\u000b\u0002wB\u0011\u0011\u0006`\u0005\u0003{*\u0012qAQ8pY\u0016\fg.A\fj]B\u0013xnY3tgR\u000b7o[#oO&tWm\u0018\u0013fcR!\u0011\u0011AA\u0004!\rI\u00131A\u0005\u0004\u0003\u000bQ#\u0001B+oSRD\u0001\"!\u0003\u000b\u0003\u0003\u0005\ra_\u0001\u0004q\u0012\n\u0014\u0001F5o!J|7-Z:t)\u0006\u001c8.\u00128hS:,\u0007\u0005K\u0004\f\u0003\u001f\t)\"a\u0006\u0011\u0007-\u000b\t\"C\u0002\u0002\u00141\u0013QAV1mk\u0016\fQA^1mk\u0016\f#!!\u0007\u0002K\u0011ZH-\u001a9m_ftC/Y:l]%tW\u0006\u001d:pG\u0016\u001c8/L<pe.,'O\u000f;sk\u0016l\u0018\u0001F<sCB\u0004X\rZ,pe.,'/T1oC\u001e,'/\u0006\u0002\u0002 A)q)!\t\u0002&%\u0019\u00111\u0005\u0010\u0003\u0017\t+\u0017M\\,sCB\u0004XM\u001d\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0015\t7\r^8s\u0015\t\ty#\u0001\u0003bW.\f\u0017\u0002BA\u001a\u0003S\u0011\u0001\"Q2u_J\u0014VMZ\u0001\u0016oJ\f\u0007\u000f]3e/>\u00148.\u001a:NC:\fw-\u001a:!\u000359(/\u00199qK\u0012,enZ5oKV\u0011\u00111\b\t\u0006\u000f\u0006\u0005\u0012Q\b\t\u0004c\u0005}\u0012bAA!e\t\u0019B+Y:l\u000bb,7-\u001e;j_:,enZ5oK\u0006qqO]1qa\u0016$WI\\4j]\u0016\u0004\u0013aF<sCB\u0004X\r\u001a#jg\u000e|g/\u001a:z'\u0016\u0014h/[2f+\t\tI\u0005E\u0003H\u0003C\tY\u0005\u0005\u0003\u0002N\u0005mSBAA(\u0015\u0011\t\t&a\u0015\u0002\u0013\u0011L7oY8wKJL(\u0002BA+\u0003/\nqa]3sm&\u001cWMC\u0002\u0002Z\u0001\n!\"\u001b8ta\u0016\u001cG/[8o\u0013\u0011\ti&a\u0014\u0003!\u0011K7oY8wKJL8+\u001a:wS\u000e,\u0017\u0001G<sCB\u0004X\r\u001a#jg\u000e|g/\u001a:z'\u0016\u0014h/[2fA\u0005iqo\u001c:lKJl\u0015M\\1hKJ$\"!a\b)\u0007I\t9\u0007\u0005\u0003\u0002j\u0005ETBAA6\u0015\ri\u0015Q\u000e\u0006\u0004\u0003_\u0012\u0016aB2p]R,\u0007\u0010^\u0005\u0005\u0003g\nYG\u0001\u0003CK\u0006tGCAA\u001eQ\u001d\u0019\u0012\u0011PA\u000b\u0003\u007f\u0002B!!\u001b\u0002|%!\u0011QPA6\u0005%!U\r]3oIN|e\u000e\f\u0002\u0002\u0002\u0006\u0012\u00111Q\u0001\tkB<'/\u00193fe\"\u001a1#a\u001a\u0002!\u0011L7oY8wKJL8+\u001a:wS\u000e,GCAA%Q\r!\u0012qM\u0001\u0012S:LGoV8sW\u0016\u0014X*\u00198bO\u0016\u0014H\u0003CA\u0001\u0003#\u000bY*a,\t\u000f\u0005MU\u00031\u0001\u0002\u0016\u000611/_:uK6\u0004B!a\n\u0002\u0018&!\u0011\u0011TA\u0015\u0005-\t5\r^8s'f\u001cH/Z7\t\u000f\u0005uU\u00031\u0001\u0002 \u0006iB/Y:l\u000bb,7-\u001e;j_:<vN]6feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002\"\u0006-VBAAR\u0015\u0011\t)+a*\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u000b\u0007\u0005%F'A\u0002ba&LA!!,\u0002$\niB+Y:l\u000bb,7-\u001e;j_:<vN]6feJ+\u0007o\\:ji>\u0014\u0018\u0010C\u0004\u00022V\u0001\r!a-\u00023\r|gNZ5hkJ\fG/[8o\u0011\u0006\u001c\b\u000e\u0015:pm&$WM\u001d\t\u0005\u0003k\u000bi,\u0004\u0002\u00028*!\u0011\u0011XA^\u0003)1XM]:j_:Lgn\u001a\u0006\u0004\u0003K\u0013\u0014\u0002BA`\u0003o\u0013\u0011dQ8oM&<WO]1uS>t\u0007*Y:i!J|g/\u001b3fe\u0006Q\u0011N\\5u\u000b:<\u0017N\\3\u0015-\u0005\u0005\u0011QYAd\u0003/\f\tO!\u0001\u0003\u0004\tM!Q\u0004B\u0010\u0005oAq!a%\u0017\u0001\b\t)\nC\u0004\u0002JZ\u0001\u001d!a3\u0002)\u0005\u001cG/\u001b<f)\u0006\u001c8NU3q_NLGo\u001c:z!\u0011\ti-a5\u000e\u0005\u0005='bAAie\u0005Q!/\u001a9pg&$xN]=\n\t\u0005U\u0017q\u001a\u0002\u0015\u0003\u000e$\u0018N^3UCN\\'+\u001a9pg&$xN]=\t\u000f\u0005eg\u0003q\u0001\u0002\\\u0006)\u0002/\u001a8eS:<G+Y:l%\u0016\u0004xn]5u_JL\b\u0003BAg\u0003;LA!a8\u0002P\n)\u0002+\u001a8eS:<G+Y:l%\u0016\u0004xn]5u_JL\bbBAr-\u0001\u000f\u0011Q]\u0001\u0011G>tG/Y5oKJ4\u0015m\u0019;pef\u0004b!a:\u0002r\u0006UXBAAu\u0015\u0011\tY/!<\u0002\r\r|gNZ5h\u0015\r\tyOU\u0001\u0004U6\u001c\u0018\u0002BAz\u0003S\u00141DS7t\u0019&\u001cH/\u001a8fe\u000e{g\u000e^1j]\u0016\u0014h)Y2u_JL\b\u0003BA|\u0003{l!!!?\u000b\t\u0005m\u0018Q^\u0001\tY&\u001cH/\u001a8fe&!\u0011q`A}\u0005}!UMZ1vYRlUm]:bO\u0016d\u0015n\u001d;f]\u0016\u00148i\u001c8uC&tWM\u001d\u0005\b\u0003;3\u00029AAP\u0011\u001d\u0011)A\u0006a\u0002\u0005\u000f\tab\u001d;fa2{wMR1di>\u0014\u0018\u0010\u0005\u0003\u0003\n\t=QB\u0001B\u0006\u0015\r\u0011iAM\u0001\u0004Y><\u0017\u0002\u0002B\t\u0005\u0017\u0011ab\u0015;fa2{wMR1di>\u0014\u0018\u0010C\u0004\u0003\u0016Y\u0001\u001dAa\u0006\u0002!M$X\r\u001d'pOJ+GO]5fm\u0016\u0014\b\u0003\u0002B\u0005\u00053IAAa\u0007\u0003\f\t\u00012\u000b^3q\u0019><'+\u001a;sS\u00164XM\u001d\u0005\b\u0003c3\u00029AAZ\u0011\u001d\u0011\tC\u0006a\u0002\u0005G\ta\u0002^1tW\u0016\u00148+\u001a;uS:<7\u000f\u0005\u0003\u0003&\tMRB\u0001B\u0014\u0015\u0011\u0011ICa\u000b\u0002\rMD\u0017M]3e\u0015\u0011\u0011iCa\f\u0002\u0011M,G\u000f^5oONT1A!\r#\u0003)AH\u000e\u001d7bi\u001a|'/\\\u0005\u0005\u0005k\u00119C\u0001\bUCN\\WM]*fiRLgnZ:\t\u000f\teb\u0003q\u0001\u0003<\u0005\u0001B/Y:l#V,W/Z*feZL7-\u001a\t\u0004c\tu\u0012b\u0001B e\t\u0001B+Y:l#V,W/Z*feZL7-Z\u0001\u0015S:LG\u000fR5tG>4XM]=TKJ4\u0018nY3\u0015\t\u0005\u0005!Q\t\u0005\b\u0003';\u0002\u0019AAK\u0003=\u0011Xm]2iK\u0012,H.\u001a+bg.\u001cHCBA\u0001\u0005\u0017\u0012i\u0005C\u0004\u0002Zb\u0001\r!a7\t\rUB\u0002\u0019AA\u001fQ\u001d\u0001\u0011\u0011PA\u000b\u0005#b\u0003Ba\u0015\u0003X\tm#qL\u0011\u0003\u0005+\nqC]3q_NLGo\u001c:z'\u0016\u0014h/[2f\u0011>dG-\u001a:\"\u0005\te\u0013a\u00079mC\u000e,\u0007n\u001c7eKJ\u0014V\r]8tSR|'/\u001f%pY\u0012,'/\t\u0002\u0003^\u0005\u0001\u0012M\u001d;jM\u0006\u001cGOU3t_24XM]\u0011\u0003\u0005C\n\u0011dY8n[\u0006tGm\u00165ji\u0016d\u0017n\u001d;WC2LG-\u0019;pe\"\u001a\u0001A!\u001a\u0011\t\u0005%$qM\u0005\u0005\u0005S\nYG\u0001\u0003MCjL\bf\u0001\u0001\u0003nA!\u0011\u0011\u000eB8\u0013\u0011\u0011\t(a\u001b\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003E)enZ5oK\n+\u0017M\u001c\"vS2$WM\u001d\t\u0003\u000fj\u0019\"A\u0007\u0015\u0015\u0005\tU\u0014aE2sK\u0006$XmV8sW\u0016\u0014X*\u00198bO\u0016\u0014HCCA\u0013\u0005\u007f\u0012\tIa!\u0003\u0018\"9\u00111\u0013\u000fA\u0002\u0005U\u0005bBAO9\u0001\u0007\u0011q\u0014\u0005\b\u0005\u000bc\u0002\u0019\u0001BD\u0003E\u0019wN\u001c4jOV\u0014\u0018\r^5p]\"\u000b7\u000f\u001b\t\u0005\u0005\u0013\u0013\tJ\u0004\u0003\u0003\f\n5\u0005C\u00017+\u0013\r\u0011yIK\u0001\u0007!J,G-\u001a4\n\t\tM%Q\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t=%\u0006\u0003\u0004\u0003\u001ar\u0001\ra_\u0001\u000fg\"|W\u000f\u001c3O_R\u001c\u0005.\u001e8l\u0001")
public class EngineBeanBuilder {
    private final Archive archive;
    private final RepositoryFactory repositoryAdapter;
    private final Logger logger;
    @Value(value="${deploy.task.in-process-worker:true}")
    private boolean inProcessTaskEngine;
    private final BeanWrapper<ActorRef> wrappedWorkerManager;
    private final BeanWrapper<TaskExecutionEngine> wrappedEngine;
    private final BeanWrapper<DiscoveryService> wrappedDiscoveryService;

    public static ActorRef createWorkerManager(ActorSystem system, TaskExecutionWorkerRepository taskExecutionWorkerRepository, String configurationHash, boolean shouldNotChunk) {
        return EngineBeanBuilder$.MODULE$.createWorkerManager(system, taskExecutionWorkerRepository, configurationHash, shouldNotChunk);
    }

    public Archive archive() {
        return this.archive;
    }

    public RepositoryFactory repositoryAdapter() {
        return this.repositoryAdapter;
    }

    private Logger logger() {
        return this.logger;
    }

    public String toString() {
        return super.toString();
    }

    public boolean inProcessTaskEngine() {
        return this.inProcessTaskEngine;
    }

    public void inProcessTaskEngine_$eq(boolean x$1) {
        this.inProcessTaskEngine = x$1;
    }

    public BeanWrapper<ActorRef> wrappedWorkerManager() {
        return this.wrappedWorkerManager;
    }

    public BeanWrapper<TaskExecutionEngine> wrappedEngine() {
        return this.wrappedEngine;
    }

    public BeanWrapper<DiscoveryService> wrappedDiscoveryService() {
        return this.wrappedDiscoveryService;
    }

    @Bean
    public BeanWrapper<ActorRef> workerManager() {
        return this.wrappedWorkerManager();
    }

    @Bean
    @DependsOn(value={"upgrader"})
    public BeanWrapper<TaskExecutionEngine> engine() {
        return this.wrappedEngine();
    }

    @Bean
    public BeanWrapper<DiscoveryService> discoveryService() {
        return this.wrappedDiscoveryService();
    }

    public void initWorkerManager(ActorSystem system, TaskExecutionWorkerRepository taskExecutionWorkerRepository, ConfigurationHashProvider configurationHashProvider) {
        ActorRef workerManger = EngineBeanBuilder$.MODULE$.createWorkerManager(system, taskExecutionWorkerRepository, configurationHashProvider.configurationHash(), this.inProcessTaskEngine());
        this.wrappedWorkerManager().set((Object)workerManger);
    }

    public void initEngine(ActorSystem system, ActiveTaskRepository activeTaskRepository, PendingTaskRepository pendingTaskRepository, JmsListenerContainerFactory<DefaultMessageListenerContainer> containerFactory, TaskExecutionWorkerRepository taskExecutionWorkerRepository, StepLogFactory stepLogFactory, StepLogRetriever stepLogRetriever, ConfigurationHashProvider configurationHashProvider, TaskerSettings taskerSettings, TaskQueueService taskQueueService) {
        ActorRef actorRef;
        TaskFinalizerImpl taskFinalizer = new TaskFinalizerImpl(system, (CrudTaskRepository)activeTaskRepository, pendingTaskRepository, taskerSettings.askTimeout());
        TaskExecutionEngine engine = new TaskExecutionEngine(activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, taskQueueService, system, (ActorRef)this.workerManager().get(), (TaskFinalizer)taskFinalizer);
        if (this.inProcessTaskEngine()) {
            this.logger().info("An in-process task execution worker will be registered.");
            TaskExecutionWorker$.MODULE$.local(this.repositoryAdapter(), this.archive(), configurationHashProvider, activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, containerFactory, taskerSettings, stepLogFactory, stepLogRetriever, system).recoverTasks();
            DiscoveryWorker$.MODULE$.initialize(system);
            actorRef = BoxedUnit.UNIT;
        } else {
            this.logger().debug("Registering for remote change set events.");
            actorRef = system.actorOf(RemoteChangeSetEventListener$.MODULE$.props(), RemoteChangeSetEventListener$.MODULE$.name());
        }
        system.actorOf(QueryActor$.MODULE$.props(), QueryActor$.MODULE$.name());
        this.rescheduleTasks(pendingTaskRepository, engine);
        this.wrappedEngine().set((Object)engine);
    }

    public void initDiscoveryService(ActorSystem system) {
        this.wrappedDiscoveryService().set((Object)new DiscoveryService(system, (ActorRef)this.workerManager().get(), this.inProcessTaskEngine()));
    }

    private void rescheduleTasks(PendingTaskRepository pendingTaskRepository, TaskExecutionEngine engine) {
        pendingTaskRepository.scheduledTasks().forEach(task -> {
            Throwable ex;
            DateTime scheduledDate = task.getScheduledDate();
            String date = scheduledDate.toDateTimeISO().toString("yyyy-MM-dd'T'HH:mm:ss");
            if (scheduledDate.isBeforeNow()) {
                this.logger().info(new StringBuilder(67).append("Scheduled task [").append(task.getId()).append("] with date [").append(date).append("] has already passed so executing now.").toString());
                engine.execute(task.getId());
                return;
            }
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> engine.schedule(task.getId(), scheduledDate));
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable ex2 = failure.exception();
                if (ex2 instanceof TaskerException) {
                    TaskerException taskerException = (TaskerException)ex2;
                    this.logger().warn(new StringBuilder(73).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically.").toString());
                    this.logger().warn(taskerException.getMessage());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
            if (bl && (ex = failure.exception()) instanceof Exception) {
                Exception exception = (Exception)ex;
                this.logger().warn(new StringBuilder(100).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically. Unexpected error occurred.").toString());
                throw exception;
            }
            if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
            this.logger().info(new StringBuilder(52).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] was rescheduled").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    public EngineBeanBuilder(@Autowired Archive archive, @Autowired RepositoryFactory repositoryAdapter) {
        this.archive = archive;
        this.repositoryAdapter = repositoryAdapter;
        this.logger = LoggerFactory.getLogger(EngineBeanBuilder.class);
        this.wrappedWorkerManager = BeanWrapper$.MODULE$.apply();
        this.wrappedEngine = BeanWrapper$.MODULE$.apply();
        this.wrappedDiscoveryService = BeanWrapper$.MODULE$.apply();
    }
}

