package com.xebialabs.deployit.service.deployment;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.deployment.ResolvedPlaceholder;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyResolverDeployedGenerator extends AbstractChainGenerator {

    private final Logger logger = LoggerFactory.getLogger(PropertyResolverDeployedGenerator.class);

    public PropertyResolverDeployedGenerator(DeployedGenerator processor) {
        super(processor);
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        DeployedPropertySetter deployedPropertySetter = deploymentContext.getBeanSupplier().getBean(DeployedPropertySetter.class);
        GeneratedDeployeds generatedDeployeds = nextGenerator.generateDeployed(deploymentContext, deployable, container);

        generatedDeployeds.getDeployeds().forEach(deployed -> {
            ConsolidatedDictionary dictionary = deploymentContext.dictionaryFilteredByContainer(container);
            deployedPropertySetter.setProperties(
                    deployed,
                    deploymentContext.getExistingDeployedSupplier().getExistingDeployedWithContainer(deployable, container).orElse(null),
                    dictionary);

            String containerId = deployed.getContainer().getId();
            final DeployedApplication deployedApplication = deploymentContext.getDeployedApplication();
            final Set<ResolvedPlaceholder> resolvedPlaceholders =
                    ResolvedPlaceholderGenerator.generate(deployedApplication, dictionary, containerId);
            deployedApplication.add$ResolvedPlaceholders(resolvedPlaceholders);
        });

        logger.debug("'{}' generated following deployeds [{}]", nextGenerator.getClass().getName(), generatedDeployeds);
        return generatedDeployeds;
    }
}
