package com.xebialabs.deployit.service

import java.util

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Deployable}

import scala.jdk.CollectionConverters._

package object importer {

  def getAllArtifacts(item: ConfigurationItem): util.Set[SourceArtifact] =
    getAllArtifacts(new util.HashSet[ConfigurationItem](), item)

  def getAllArtifacts(items: util.List[Deployable]): util.Set[SourceArtifact] =
     getAllArtifacts(new util.HashSet[ConfigurationItem](), items.asScala.toSeq)

  def getAllArtifacts(visited: util.Set[ConfigurationItem], item: ConfigurationItem): util.Set[SourceArtifact] =
    getAllArtifacts(visited, Seq(item))

  def getAllArtifacts(visited: util.Set[ConfigurationItem], list: Seq[ConfigurationItem]): util.Set[SourceArtifact] = {
    list.filter(!visited.contains(_)).foldLeft(new util.HashSet[SourceArtifact]()) {
      (ciSet: util.HashSet[SourceArtifact], ci: ConfigurationItem) =>
        visited.add(ci)
        ci match {
          case sa: SourceArtifact => ciSet.add(sa)
          case _ =>
        }
        ci.getType.getDescriptor.getPropertyDescriptors.forEach(pd => pd.get(ci) match {
          case child: ConfigurationItem if pd.getKind == PropertyKind.CI => ciSet.addAll(getAllArtifacts(visited, child))
          case list: util.List[ConfigurationItem] if pd.getKind == PropertyKind.LIST_OF_CI => ciSet.addAll(getAllArtifacts(visited, list.asScala.toSeq))
          case set: util.Set[ConfigurationItem] if pd.getKind == PropertyKind.SET_OF_CI => ciSet.addAll(getAllArtifacts(visited, set.asScala.toSeq))
          case _ =>
        })
        ciSet
    }
  }

}
