/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import ai.digital.deploy.task.status.queue.TaskPathStatusListener;
import ai.digital.deploy.tasker.common.TaskType;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.deployment.planner.CheckPointManagerListener;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecificationHelper;
import com.xebialabs.deployit.deployment.planner.PhasedPlan;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.deployment.planner.Plans;
import com.xebialabs.deployit.deployment.rules.PlanCreationContextFactory;
import com.xebialabs.deployit.deployment.service.ArtifactTransformerFactory;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecificationWithDependencies;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryAdapterFactory;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.service.deployment.DeploymentOperationCalculator;
import com.xebialabs.deployit.service.deployment.ReferentialIntegrityTrigger;
import com.xebialabs.deployit.task.TaskMetadataModifier;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.xlplatform.config.ConfigurationHolder;
import com.xebialabs.xlplatform.satellite.Satellite;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="deploymentService")
public class DeploymentService {
    @Value(value="${deploy.task.step.on-copy-artifact.enable-retry:true}")
    private String enableRetry;
    private final Planner planner;
    private final RepositoryAdapterFactory repositoryFactory;
    private final PlanCreationContextFactory planCreationContextFactory;
    private final ArtifactTransformerFactory artifactTransformerFactory;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);

    @Autowired
    public DeploymentService(Planner planner, RepositoryAdapterFactory repositoryFactory, PlanCreationContextFactory planCreationContextFactory, ArtifactTransformerFactory artifactTransformerFactory) {
        this.planner = planner;
        this.repositoryFactory = repositoryFactory;
        this.planCreationContextFactory = planCreationContextFactory;
        this.artifactTransformerFactory = artifactTransformerFactory;
    }

    public MultiDeltaSpecification prepareInitialSpecification(Deployment deployment, Map<String, DeployedApplication> existingDepoyedApplications) {
        return MultiDeltaSpecification.withDependencies((DeltaSpecification)this.prepareInitialSpecification(deployment), this.prepareDependencyDeployments(deployment.getGroupedRequiredDeployments(), existingDepoyedApplications));
    }

    private DeltaSpecification prepareInitialSpecification(Deployment deployment) {
        return this.prepareInitialSpecification(DeploymentService.extractDeployedApplicationWithDeployeds(deployment));
    }

    DeltaSpecification prepareInitialSpecification(DeployedApplication deployedApplication) {
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().initial(deployedApplication);
        DeploymentOperationCalculator.calculate(builder, Sets.newHashSet(), deployedApplication.getDeployeds());
        return builder.build();
    }

    public MultiDeltaSpecification prepareUpgradeSpecification(Deployment deployment, Map<String, DeployedApplication> existingDepoyedApplications) {
        return MultiDeltaSpecification.withDependencies((DeltaSpecification)this.prepareUpgradeSpecification(deployment, existingDepoyedApplications.get(deployment.getDeployedApplication().getId())), this.prepareDependencyDeployments(deployment.getGroupedRequiredDeployments(), existingDepoyedApplications));
    }

    private DeltaSpecification prepareUpgradeSpecification(Deployment deployment, DeployedApplication existingDeployedApplication) {
        return this.prepareUpgradeSpecification(DeploymentService.extractDeployedApplicationWithDeployeds(deployment), existingDeployedApplication);
    }

    DeltaSpecification prepareUpgradeSpecification(DeployedApplication newDeployedApplication, DeployedApplication existingDeployedApplication) {
        this.copyTransientProperties(newDeployedApplication, existingDeployedApplication);
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().upgrade(existingDeployedApplication, newDeployedApplication);
        logger.trace("Incoming Deployeds {}", (Object)newDeployedApplication.getDeployeds());
        logger.trace("Existing Deployeds {}", (Object)existingDeployedApplication.getDeployeds());
        if (newDeployedApplication.isForceRedeploy()) {
            DeploymentOperationCalculator.deltaToRedeploy(builder, existingDeployedApplication.getDeployeds(), newDeployedApplication.getDeployeds());
        } else {
            DeploymentOperationCalculator.calculate(builder, existingDeployedApplication.getDeployeds(), newDeployedApplication.getDeployeds());
        }
        return builder.build();
    }

    private List<List<DeltaSpecification>> prepareDependencyDeployments(List<List<Deployment>> groupedRequiredDeployments, Map<String, DeployedApplication> existingDepoyedApplications) {
        ArrayList<List<DeltaSpecification>> groupedDeltaSpecs = new ArrayList<List<DeltaSpecification>>();
        for (List<Deployment> requiredDeploymentGroup : groupedRequiredDeployments) {
            groupedDeltaSpecs.add(requiredDeploymentGroup.stream().map(requiredDeployment -> this.prepareDependencyDeployment((Deployment)requiredDeployment, existingDepoyedApplications)).collect(Collectors.toList()));
        }
        return groupedDeltaSpecs;
    }

    private DeltaSpecification prepareDependencyDeployment(Deployment requiredDeployment, Map<String, DeployedApplication> existingDepoyedApplications) {
        switch (requiredDeployment.getDeploymentType()) {
            case INITIAL: {
                return this.prepareInitialSpecification(requiredDeployment);
            }
            case UPDATE: {
                return this.prepareUpgradeSpecification(requiredDeployment, existingDepoyedApplications.get(requiredDeployment.getDeployedApplication().getId()));
            }
        }
        throw new IllegalArgumentException("Deployment " + requiredDeployment.getId() + " has invalid type " + requiredDeployment.getDeploymentType());
    }

    private static DeployedApplication extractDeployedApplicationWithDeployeds(Deployment deployment) {
        DeployedApplication deployedApp = (DeployedApplication)deployment.getDeployedApplication();
        deployedApp.addDeployeds(DeploymentService.getDeployeds(deployment));
        return deployedApp;
    }

    private static HashSet<Deployed> getDeployeds(Deployment deployment) {
        List deployedEntities = deployment.getDeployeds();
        FluentIterable from = FluentIterable.from((Iterable)deployedEntities);
        Checks.checkArgument((boolean)from.allMatch(Predicates.or((Predicate)Predicates.instanceOf(Deployed.class), (Predicate)Predicates.instanceOf(EmbeddedDeployed.class))), (String)"The Deployment can only contain Deployed or EmbeddedDeployed configuration items", (Object[])new Object[0]);
        return Sets.newHashSet((Iterable)from.filter(Deployed.class));
    }

    private void copyTransientProperties(DeployedApplication newDeployment, DeployedApplication existingDeployment) {
        Descriptor descriptor = newDeployment.getType().getDescriptor();
        logger.debug("Copying transient properties to previous deployed application for {}", (Object)newDeployment.getId());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (!pd.isTransient()) {
                logger.trace("Skipping copy of non-transient property {}", (Object)pd.getFqn());
                continue;
            }
            if (pd.get((ConfigurationItem)newDeployment) == null || pd.get((ConfigurationItem)existingDeployment) != null) {
                logger.trace("Skipping copy of property {} as it is either not set on 'new', or already set on 'existing'", (Object)pd.getFqn());
                continue;
            }
            logger.debug("Copying transient property {} to existing deployment", (Object)pd.getFqn());
            pd.set((ConfigurationItem)existingDeployment, pd.get((ConfigurationItem)newDeployment));
        }
    }

    public MultiDeltaSpecification prepareUndeployment(DeployedApplication deployedApplication) {
        return new MultiDeltaSpecification(this.prepareSingleUndeployment(deployedApplication));
    }

    public MultiDeltaSpecification prepareUndeploymentWithDependencies(Deployment deployment) {
        DeployedApplication deployedApplication = (DeployedApplication)deployment.getDeployedApplication();
        ArrayList<DeltaSpecification> deltaSpecifications = new ArrayList<DeltaSpecification>();
        DeltaSpecification specification = this.prepareSingleUndeployment(deployedApplication);
        deltaSpecifications.add(specification);
        List dependencies = this.dependencyStream(deployment).map(x -> x.stream().map(rd -> this.prepareSingleUndeployment((DeployedApplication)rd.getDeployedApplication())).collect(Collectors.toList())).collect(Collectors.toList());
        dependencies.add(deltaSpecifications);
        return MultiDeltaSpecification.forUndeploy(dependencies, (DeployedApplication)deployedApplication);
    }

    private Stream<List<Deployment>> dependencyStream(Deployment deployment) {
        return deployment.getGroupedRequiredDeployments().stream();
    }

    DeltaSpecification prepareSingleUndeployment(DeployedApplication deployedApplication) {
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().undeploy(deployedApplication);
        DeploymentOperationCalculator.calculate(builder, deployedApplication.getDeployeds(), Sets.newHashSet());
        return builder.build();
    }

    TaskSpecification getTaskSpecification(String deploymentId, DeltaSpecification deltaSpecification, WorkDir currentWorkDir, WorkDir ... workdirsToCleanup) {
        return this.getTaskFullSpecification(deploymentId, new MultiDeltaSpecification(deltaSpecification), currentWorkDir, workdirsToCleanup);
    }

    public TaskSpecification getTaskFullSpecification(String deploymentId, MultiDeltaSpecification spec, WorkDir currentWorkDir, WorkDir ... workdirsToCleanup) {
        TaskSpecification taskSpec = null;
        Operation operation = MultiDeltaSpecificationHelper.commonOperation((List)spec.getAllDeltaSpecifications()).orElse(Operation.NOOP);
        List allDeployedApplications = spec.getAllDeployedApplications();
        DeployedApplication mainDeployedApplication = (DeployedApplication)allDeployedApplications.get(allDeployedApplications.size() - 1);
        switch (operation) {
            case CREATE: {
                taskSpec = this.getTaskSpecification(deploymentId, "Initial deployment of " + MultiDeltaSpecificationHelper.applicationNames((DeltaSpecificationWithDependencies)spec), spec, currentWorkDir, mainDeployedApplication, workdirsToCleanup);
                DeploymentService.addMetadata(taskSpec, mainDeployedApplication, TaskType.INITIAL);
                break;
            }
            case DESTROY: {
                taskSpec = this.getTaskSpecification(deploymentId, "Undeployment of " + MultiDeltaSpecificationHelper.applicationNames((DeltaSpecificationWithDependencies)spec), spec, currentWorkDir, mainDeployedApplication, workdirsToCleanup);
                DeploymentService.addMetadata(taskSpec, mainDeployedApplication, TaskType.UNDEPLOY);
                break;
            }
            case MODIFY: {
                String description = "Update deployment of " + MultiDeltaSpecificationHelper.applicationNames((DeltaSpecificationWithDependencies)spec);
                taskSpec = this.getTaskSpecification(deploymentId, description, spec, currentWorkDir, mainDeployedApplication, workdirsToCleanup);
                DeploymentService.addMetadata(taskSpec, mainDeployedApplication, TaskType.UPGRADE);
                break;
            }
        }
        return taskSpec;
    }

    private TaskSpecification getTaskSpecification(String taskId, String description, MultiDeltaSpecification specification, WorkDir currentWorkDir, DeployedApplication mainDeployedApplication, WorkDir ... workdirsToCleanup) {
        DeploymentService.unsetTokensForRealityPush(specification);
        Repository repository = this.repositoryFactory.create(currentWorkDir);
        PhasedPlan plan = this.planner.plan(specification, this.planCreationContextFactory.createPlanCreationContext(repository, this.artifactTransformerFactory));
        logger.info("Generated plan for task {}:\n{}", (Object)taskId, (Object)plan.writePlan((Writer)new StringWriter()));
        PhaseContainer executionBlock = Plans.toBlockBuilder((PhasedPlan)plan).build();
        boolean isRollback = specification.getAllDeltaSpecifications().stream().allMatch(DeltaSpecification::isRollback);
        TaskSpecification spec = new TaskSpecification(taskId, description, Permissions.getAuthentication(), currentWorkDir, executionBlock, null, true, true, isRollback, mainDeployedApplication.getOnSuccessPolicy(), mainDeployedApplication.getOnFailurePolicy());
        String autoDetectSetting = "deploy.task.artifact-copy-strategy.autodetect";
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (ConfigurationHolder.get() != null) {
            String hasAutoDetect = ConfigurationHolder.get().hasPath(autoDetectSetting) ? Boolean.toString(ConfigurationHolder.get().getBoolean(autoDetectSetting)) : "false";
            configMap.put(autoDetectSetting, hasAutoDetect);
        }
        spec.setConfig(configMap);
        spec.getMetadata().put("enableCopyArtifactRetry", this.enableRetry);
        spec.getListeners().addAll(plan.getListeners());
        ArrayList workDirs = Lists.newArrayList((Object[])workdirsToCleanup);
        workDirs.add(currentWorkDir);
        spec.getListeners().add(new WorkdirCleanerTrigger((List)workDirs));
        spec.getListeners().add(new ReferentialIntegrityTrigger(specification));
        spec.getListeners().add(this.createCheckpointManagerListener(specification, (Plan)plan));
        spec.getListeners().add(new TaskPathStatusListener());
        this.addTaskRefs(specification, spec, mainDeployedApplication);
        return spec;
    }

    private void addTaskRefs(MultiDeltaSpecification specification, TaskSpecification spec, DeployedApplication mainDeployedApplication) {
        Stream<DeployedApplication> dependencies = specification.getAllDeltaSpecifications().stream().filter(spec1 -> !this.isSameApplication(spec1.getDeployedApplication(), mainDeployedApplication)).map(spec1 -> {
            if (spec1.getDeployedApplication() != null) {
                return spec1.getDeployedApplication();
            }
            return spec1.getPreviousDeployedApplication();
        });
        dependencies.map(d -> new TaskPackageDependency(d.getName(), d.getVersion().getVersion())).forEach(td -> spec.getPackageDependencies().add(td));
    }

    protected ExecutionStateListener createCheckpointManagerListener(MultiDeltaSpecification specification, Plan plan) {
        return new CheckPointManagerListener(specification, plan.findCheckpoints());
    }

    private static void unsetTokensForRealityPush(MultiDeltaSpecification fullSpec) {
        for (DeployedApplication deployedApplication : fullSpec.getAllDeployedApplications()) {
            deployedApplication.set$token(null);
        }
        for (Delta delta : fullSpec.getAllDeltas()) {
            Deployed ci = delta.getDeployed();
            DeploymentService.unsetTokenOnCi((ConfigurationItem)ci);
        }
    }

    private boolean isSameApplication(DeployedApplication application1, DeployedApplication application2) {
        return this.applicationId(application1).equals(this.applicationId(application2));
    }

    private String applicationId(DeployedApplication application) {
        return application.getVersion().getApplication().getId();
    }

    private static void unsetTokenOnCi(ConfigurationItem ci) {
        if (ci instanceof BaseConfigurationItem) {
            BaseConfigurationItem bci = (BaseConfigurationItem)ci;
            bci.set$token(null);
            DeploymentService.unsetTokensOnEmbeddeds(bci);
        }
    }

    private static void unsetTokensOnEmbeddeds(BaseConfigurationItem deployed) {
        Collection propertyDescriptors = deployed.getType().getDescriptor().getPropertyDescriptors();
        Collection embeddedProperties = Collections2.filter((Collection)propertyDescriptors, input -> input.isAsContainment() && EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI).contains(input.getKind()) && input.getReferencedType().instanceOf(Type.valueOf(EmbeddedDeployed.class)));
        for (PropertyDescriptor embeddedProperty : embeddedProperties) {
            Collection c = (Collection)embeddedProperty.get((ConfigurationItem)deployed);
            for (ConfigurationItem configurationItem : c) {
                DeploymentService.unsetTokenOnCi(configurationItem);
            }
        }
    }

    private static Set<String> getSatelliteIds(DeployedApplication deployedApp) {
        HashSet<String> satelliteIds = new HashSet<String>();
        for (Deployed deployed : deployedApp.getDeployeds()) {
            Satellite satellite;
            if (!(deployed.getContainer() instanceof Host) || (satellite = ((Host)deployed.getContainer()).getSatellite()) == null) continue;
            satelliteIds.add(satellite.getId());
        }
        return satelliteIds;
    }

    private static String extractSecureId(Integer ciId) {
        return ciId == null ? null : String.valueOf(ciId);
    }

    private static void addMetadata(TaskSpecification spec, DeployedApplication deployedApp, TaskType taskType) {
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"satellite_ids", (String)StringUtils.join(DeploymentService.getSatelliteIds(deployedApp), (char)','));
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"environment_id", (String)deployedApp.getEnvironment().getId());
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"environment_internal_id", (String)String.valueOf(deployedApp.getEnvironment().get$internalId()));
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"environment_secured_ci", (String)DeploymentService.extractSecureId(deployedApp.getEnvironment().get$securedCi()));
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"environment_directory_ref", (String)deployedApp.getEnvironment().get$directoryReference());
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"environment", (String)deployedApp.getEnvironment().getName());
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"version", (String)deployedApp.getVersion().getName());
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"application", (String)deployedApp.getVersion().getApplication().getName());
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"application_internal_id", (String)String.valueOf(deployedApp.getVersion().getApplication().get$internalId()));
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"application_secured_ci", (String)DeploymentService.extractSecureId(deployedApp.getVersion().getApplication().get$securedCi()));
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"application_directory_ref", (String)deployedApp.getVersion().getApplication().get$directoryReference());
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"taskType", (String)taskType.name());
    }
}

