package com.xebialabs.deployit.service.dependency

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, DeployedApplication, DeploymentPackage, Version}
import com.xebialabs.deployit.repository.SearchParameters

import scala.jdk.CollectionConverters._

trait DeployedApplicationInfoLoader extends RepositoryServiceAware {

  def loadDeployedApplications(envId: String): List[DeployedApplicationInfo] = {
    val deployedApplications = repositoryService.listEntities(
      new SearchParameters().setParent(envId).setType(Type.valueOf("udm.DeployedApplication")), 1, false
    ).asScala.toList.asInstanceOf[List[ConfigurationItem]]
    deployedApplications.map {
      case app: DeployedApplication =>
        val versionId = app.getVersion.getId
        val version = repositoryService.read(versionId, 1, null, false).asInstanceOf[Version]
        val deployedApplicationId = app.getId
        val applicationId = if (version.toString.contains("/")) {
          version.toString.substring(0, version.toString.lastIndexOf('/'))
        } else {
          version.getId
        }
        var dependenciesMap =
          Map.empty[String, String]
        version match {
          case dp: DeploymentPackage =>
            dependenciesMap = dp.getApplicationDependencies.asScala.toMap
          case _ =>
        }
        DeployedApplicationInfo(applicationId, deployedApplicationId, versionId, dependenciesMap)
    }
  }

}

case class DeployedApplicationInfo(applicationId: String, deployedApplicationId: String, versionId: String,
                                   applicationDependencies: Map[String, String])
