package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Function;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.udm.*;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;

import java.util.stream.IntStream;

import static java.lang.Integer.parseInt;

public class CardinalDeployedGenerator extends AbstractChainGenerator {
    private String cardinalityFieldName = "cardinality";

    public CardinalDeployedGenerator(DeployedGenerator nextGenerator) {
        super(nextGenerator);
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        if (isProvisioning(deploymentContext.getDeployedApplication()) && supportsCardinality(deployable)) {
            return provisioned(deploymentContext, deployable, container);
        } else {
            return nextGenerator.generateDeployed(deploymentContext, deployable, container);
        }
    }

    private boolean supportsCardinality(Deployable deployable) {
        return deployable instanceof Provisionable;
    }

    private GeneratedDeployeds provisioned(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        GeneratedDeployeds generatedDeployeds = new GeneratedDeployeds();
        final int cardinality = resolveCardinality(deploymentContext, (Provisionable) deployable, container);
        Function<Provisioned, String> id = deployed -> (deployed.getOrdinal() > 1) ? deployed.getId() + "-" + deployed.getOrdinal() : deployed.getId();
        IntStream.range(1, cardinality + 1).forEach(ordinal -> {
            //BasicDeployedGenerator only returns one deployed
            Deployed<Deployable, Container> deployed = nextGenerator.generateDeployed(deploymentContext, deployable, container).getDeployeds().get(0);
            Provisioned provisioned = (Provisioned) deployed;
            provisioned.setOrdinal(ordinal);
            provisioned.setId(id.apply(provisioned));
            generatedDeployeds.addDeployed(deployed);
        });
        return generatedDeployeds;
    }

    private boolean isProvisioning(DeployedApplication deployedApplication) {
        return deployedApplication.getVersion() instanceof ProvisioningPackage;
    }

    private int resolveCardinality(DeploymentContext deploymentContext, Provisionable provisionable, Container container) {
        try {
            Object o = deploymentContext.dictionaryFilteredByContainer(container).resolve(provisionable.getCardinality(), provisionable.getType().getDescriptor().getPropertyDescriptor(cardinalityFieldName));
            return parseInt(((StringValue) o).toPublicFacingValue());
        } catch (DictionaryValueException e) {
            throw new DeployedApplicationFactory.IncorrectDeployedException(e, "Couldn't resolve cardinality property from [%s]", provisionable.getName());
        }
    }

}
