/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.spring;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskExecutionWorker$;
import com.xebialabs.deployit.engine.tasker.TaskFinalizer;
import com.xebialabs.deployit.engine.tasker.TaskFinalizerImpl;
import com.xebialabs.deployit.engine.tasker.TaskQueueService;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.distribution.versioning.ConfigurationHashProvider;
import com.xebialabs.deployit.engine.tasker.log.StepLogFactory;
import com.xebialabs.deployit.engine.tasker.log.StepLogRetriever;
import com.xebialabs.deployit.engine.tasker.query.QueryActor$;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.CrudTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.websockets.RemoteChangeSetEventListener$;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryService;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryWorker$;
import com.xebialabs.deployit.spring.BeanWrapper;
import com.xebialabs.deployit.spring.BeanWrapper$;
import com.xebialabs.deployit.spring.EngineBeanBuilder$;
import com.xebialabs.xlplatform.settings.shared.TaskerSettings;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Configuration
@Lazy
@DependsOn(value={"repositoryServiceHolder", "placeholderRepositoryHolder", "artifactResolver", "commandWhitelistValidator"})
@ScalaSignature(bytes="\u0006\u0005\tEf\u0001\u0002\u0011\"\u0001)B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\tw\u0001\u0011\t\u0011)A\u0005g!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003?\u0011\u00159\u0005\u0001\"\u0001I\u0011\u001di\u0006A1A\u0005\nyCa!\u001a\u0001!\u0002\u0013y\u0006\"\u00024\u0001\t\u0003:\u0007\"\u0003?\u0001\u0001\u0004\u0005\r\u0011\"\u0001~\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%\t!!\u0002\t\u0015\u0005E\u0001\u00011A\u0001B\u0003&a\u0010\u0003\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\u0002uD1\"a\t\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002&!Q\u0011\u0011\u0006\u0001A\u0002\u0003\u0005\u000b\u0015\u0002@\t\u0013\u0005E\u0002A1A\u0005\u0002\u0005M\u0002\u0002CA&\u0001\u0001\u0006I!!\u000e\t\u0013\u00055\u0003A1A\u0005\u0002\u0005=\u0003\u0002CA-\u0001\u0001\u0006I!!\u0015\t\u0013\u0005m\u0003A1A\u0005\u0002\u0005u\u0003\u0002CA;\u0001\u0001\u0006I!a\u0018\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!1\u0001\b\u0001C\u0001\u0003\u0017Cq!!(\u0001\t\u0003\ty\nC\u0004\u0002$\u0002!\t!!*\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\"9!q\u000b\u0001\u0005\u0002\te\u0003b\u0002B/\u0001\u0011%!qL\u0004\b\u0005\u0013\u000b\u0003\u0012\u0001BF\r\u0019\u0001\u0013\u0005#\u0001\u0003\u000e\"1q)\bC\u0001\u0005\u001fCqA!%\u001e\t\u0003\u0011\u0019JA\tF]\u001eLg.\u001a\"fC:\u0014U/\u001b7eKJT!AI\u0012\u0002\rM\u0004(/\u001b8h\u0015\t!S%\u0001\u0005eKBdw._5u\u0015\t1s%A\u0005yK\nL\u0017\r\\1cg*\t\u0001&A\u0002d_6\u001c\u0001a\u0005\u0002\u0001WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\fq!\u0019:dQ&4X-F\u00014!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0004uCN\\WM\u001d\u0006\u0003q\r\na!\u001a8hS:,\u0017B\u0001\u001e6\u0005\u001d\t%o\u00195jm\u0016\f\u0001\"\u0019:dQ&4X\rI\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#\u0001 \u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015\u0001C:feZL7-Z:\u000b\u0005\r;\u0014aA:qS&\u0011Q\t\u0011\u0002\u0012%\u0016\u0004xn]5u_JLh)Y2u_JL\u0018A\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0002\na\u0001P5oSRtDcA%L7B\u0011!\nA\u0007\u0002C!)\u0011'\u0002a\u0001g!\u00121*\u0014\t\u0003\u001dfk\u0011a\u0014\u0006\u0003!F\u000b!\"\u00198o_R\fG/[8o\u0015\t\u00116+A\u0004gC\u000e$xN]=\u000b\u0005Q+\u0016!\u00022fC:\u001c(B\u0001,X\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001-\u0002\u0007=\u0014x-\u0003\u0002[\u001f\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006y\u0015\u0001\rA\u0010\u0015\u000376\u000ba\u0001\\8hO\u0016\u0014X#A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t<\u0016!B:mMRR\u0017B\u00013b\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003!\u0004\"![=\u000f\u0005)<hBA6w\u001d\taWO\u0004\u0002ni:\u0011an\u001d\b\u0003_Jl\u0011\u0001\u001d\u0006\u0003c&\na\u0001\u0010:p_Rt\u0014\"\u0001\u0015\n\u0005\u0019:\u0013B\u0001\u0013&\u0013\tA4%\u0003\u00027o%\u0011\u00010N\u0001\ba\u0006\u001c7.Y4f\u0013\tQ8P\u0001\u0004UCN\\\u0017\n\u001a\u0006\u0003qV\n1#\u001b8Qe>\u001cWm]:UCN\\WI\\4j]\u0016,\u0012A \t\u0003Y}L1!!\u0001.\u0005\u001d\u0011un\u001c7fC:\fq#\u001b8Qe>\u001cWm]:UCN\\WI\\4j]\u0016|F%Z9\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004Y\u0005%\u0011bAA\u0006[\t!QK\\5u\u0011!\tyACA\u0001\u0002\u0004q\u0018a\u0001=%c\u0005!\u0012N\u001c)s_\u000e,7o\u001d+bg.,enZ5oK\u0002BsaCA\u000b\u00037\ti\u0002E\u0002O\u0003/I1!!\u0007P\u0005\u00151\u0016\r\\;f\u0003\u00151\u0018\r\\;fC\t\ty\"A\u0013%w\u0012,\u0007\u000f\\8z]Q\f7o\u001b\u0018j]6\u0002(o\\2fgNlso\u001c:lKJTDO];f{\u0006!B/Y:l%\u0016\u001c\u0018\u000e\\5f]R,e.\u00192mK\u0012\f\u0001\u0004^1tWJ+7/\u001b7jK:$XI\\1cY\u0016$w\fJ3r)\u0011\t9!a\n\t\u0011\u0005=Q\"!AA\u0002y\fQ\u0003^1tWJ+7/\u001b7jK:$XI\\1cY\u0016$\u0007\u0005K\u0004\u000f\u0003+\tY\"!\f\"\u0005\u0005=\u0012A\b\u0013|I\u0016\u0004Hn\\=/i\u0006\u001c8N\f:fg&d\u0017.\u001a8uu\u0019\fGn]3~\u0003Q9(/\u00199qK\u0012<vN]6fe6\u000bg.Y4feV\u0011\u0011Q\u0007\t\u0006\u0015\u0006]\u00121H\u0005\u0004\u0003s\t#a\u0003\"fC:<&/\u00199qKJ\u0004B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0003bGR|'O\u0003\u0002\u0002F\u0005!\u0011m[6b\u0013\u0011\tI%a\u0010\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\fQc\u001e:baB,GmV8sW\u0016\u0014X*\u00198bO\u0016\u0014\b%A\u0007xe\u0006\u0004\b/\u001a3F]\u001eLg.Z\u000b\u0003\u0003#\u0002RASA\u001c\u0003'\u00022\u0001NA+\u0013\r\t9&\u000e\u0002\u0014)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8F]\u001eLg.Z\u0001\u000foJ\f\u0007\u000f]3e\u000b:<\u0017N\\3!\u0003]9(/\u00199qK\u0012$\u0015n]2pm\u0016\u0014\u0018pU3sm&\u001cW-\u0006\u0002\u0002`A)!*a\u000e\u0002bA!\u00111MA9\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!\u00033jg\u000e|g/\u001a:z\u0015\u0011\tY'!\u001c\u0002\u000fM,'O^5dK*\u0019\u0011qN\u0012\u0002\u0015%t7\u000f]3di&|g.\u0003\u0003\u0002t\u0005\u0015$\u0001\u0005#jg\u000e|g/\u001a:z'\u0016\u0014h/[2f\u0003a9(/\u00199qK\u0012$\u0015n]2pm\u0016\u0014\u0018pU3sm&\u001cW\rI\u0001\u000eo>\u00148.\u001a:NC:\fw-\u001a:\u0015\u0005\u0005U\u0002fA\u000b\u0002~A!\u0011qPAD\u001b\t\t\tIC\u0002Q\u0003\u0007S1!!\"V\u0003\u001d\u0019wN\u001c;fqRLA!!#\u0002\u0002\n!!)Z1o)\t\t\t\u0006K\u0004\u0017\u0003\u001f\u000bY\"!&\u0011\t\u0005}\u0014\u0011S\u0005\u0005\u0003'\u000b\tIA\u0005EKB,g\u000eZ:P]2\u0012\u0011qS\u0011\u0003\u00033\u000b\u0001\"\u001e9he\u0006$WM\u001d\u0015\u0004-\u0005u\u0014\u0001\u00053jg\u000e|g/\u001a:z'\u0016\u0014h/[2f)\t\ty\u0006K\u0002\u0018\u0003{\n\u0011#\u001b8ji^{'o[3s\u001b\u0006t\u0017mZ3s)!\t9!a*\u00022\u0006\u0015\u0007bBAU1\u0001\u0007\u00111V\u0001\u0007gf\u001cH/Z7\u0011\t\u0005u\u0012QV\u0005\u0005\u0003_\u000byDA\u0006BGR|'oU=ti\u0016l\u0007bBAZ1\u0001\u0007\u0011QW\u0001\u001ei\u0006\u001c8.\u0012=fGV$\u0018n\u001c8X_J\\WM\u001d*fa>\u001c\u0018\u000e^8ssB!\u0011qWAa\u001b\t\tIL\u0003\u0003\u0002<\u0006u\u0016\u0001\u00043jgR\u0014\u0018NY;uS>t'bAA`o\u0005\u0019\u0011\r]5\n\t\u0005\r\u0017\u0011\u0018\u0002\u001e)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8X_J\\WM\u001d*fa>\u001c\u0018\u000e^8ss\"9\u0011q\u0019\rA\u0002\u0005%\u0017!G2p]\u001aLw-\u001e:bi&|g\u000eS1tQB\u0013xN^5eKJ\u0004B!a3\u0002T6\u0011\u0011Q\u001a\u0006\u0005\u0003\u001f\f\t.\u0001\u0006wKJ\u001c\u0018n\u001c8j]\u001eT1!a/6\u0013\u0011\t).!4\u00033\r{gNZ5hkJ\fG/[8o\u0011\u0006\u001c\b\u000e\u0015:pm&$WM]\u0001\u000bS:LG/\u00128hS:,GCFA\u0004\u00037\fi.!<\u0002x\n]!\u0011\u0004B\u0015\u0005g\u0011)D!\u0014\t\u000f\u0005%\u0016\u0004q\u0001\u0002,\"9\u0011q\\\rA\u0004\u0005\u0005\u0018\u0001F1di&4X\rV1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002d\u0006%XBAAs\u0015\r\t9/N\u0001\u000be\u0016\u0004xn]5u_JL\u0018\u0002BAv\u0003K\u0014A#Q2uSZ,G+Y:l%\u0016\u0004xn]5u_JL\bbBAx3\u0001\u000f\u0011\u0011_\u0001\u0016a\u0016tG-\u001b8h)\u0006\u001c8NU3q_NLGo\u001c:z!\u0011\t\u0019/a=\n\t\u0005U\u0018Q\u001d\u0002\u0016!\u0016tG-\u001b8h)\u0006\u001c8NU3q_NLGo\u001c:z\u0011\u001d\tI0\u0007a\u0002\u0003w\f\u0001cY8oi\u0006Lg.\u001a:GC\u000e$xN]=\u0011\r\u0005u(q\u0001B\u0006\u001b\t\tyP\u0003\u0003\u0003\u0002\t\r\u0011AB2p]\u001aLwMC\u0002\u0003\u0006U\u000b1A[7t\u0013\u0011\u0011I!a@\u00037)k7\u000fT5ti\u0016tWM]\"p]R\f\u0017N\\3s\r\u0006\u001cGo\u001c:z!\u0011\u0011iAa\u0005\u000e\u0005\t=!\u0002\u0002B\t\u0005\u0007\t\u0001\u0002\\5ti\u0016tWM]\u0005\u0005\u0005+\u0011yAA\u0010EK\u001a\fW\u000f\u001c;NKN\u001c\u0018mZ3MSN$XM\\3s\u0007>tG/Y5oKJDq!a-\u001a\u0001\b\t)\fC\u0004\u0003\u001ce\u0001\u001dA!\b\u0002\u001dM$X\r\u001d'pO\u001a\u000b7\r^8ssB!!q\u0004B\u0013\u001b\t\u0011\tCC\u0002\u0003$U\n1\u0001\\8h\u0013\u0011\u00119C!\t\u0003\u001dM#X\r\u001d'pO\u001a\u000b7\r^8ss\"9!1F\rA\u0004\t5\u0012\u0001E:uKBdun\u001a*fiJLWM^3s!\u0011\u0011yBa\f\n\t\tE\"\u0011\u0005\u0002\u0011'R,\u0007\u000fT8h%\u0016$(/[3wKJDq!a2\u001a\u0001\b\tI\rC\u0004\u00038e\u0001\u001dA!\u000f\u0002\u001dQ\f7o[3s'\u0016$H/\u001b8hgB!!1\bB%\u001b\t\u0011iD\u0003\u0003\u0003@\t\u0005\u0013AB:iCJ,GM\u0003\u0003\u0003D\t\u0015\u0013\u0001C:fiRLgnZ:\u000b\u0007\t\u001dS%\u0001\u0006yYBd\u0017\r\u001e4pe6LAAa\u0013\u0003>\tqA+Y:lKJ\u001cV\r\u001e;j]\u001e\u001c\bb\u0002B(3\u0001\u000f!\u0011K\u0001\u0011i\u0006\u001c8.U;fk\u0016\u001cVM\u001d<jG\u0016\u00042\u0001\u000eB*\u0013\r\u0011)&\u000e\u0002\u0011)\u0006\u001c8.U;fk\u0016\u001cVM\u001d<jG\u0016\fA#\u001b8ji\u0012K7oY8wKJL8+\u001a:wS\u000e,G\u0003BA\u0004\u00057Bq!!+\u001b\u0001\u0004\tY+A\bsKN\u001c\u0007.\u001a3vY\u0016$\u0016m]6t)\u0019\t9A!\u0019\u0003d!9\u0011q^\u000eA\u0002\u0005E\bB\u0002\u001d\u001c\u0001\u0004\t\u0019\u0006K\u0004\u0001\u0003\u001f\u000bYBa\u001a-\u0011\t%$Q\u000eB9\u0005k\n#Aa\u001b\u0002/I,\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW\rS8mI\u0016\u0014\u0018E\u0001B8\u0003m\u0001H.Y2fQ>dG-\u001a:SKB|7/\u001b;pefDu\u000e\u001c3fe\u0006\u0012!1O\u0001\u0011CJ$\u0018NZ1diJ+7o\u001c7wKJ\f#Aa\u001e\u00023\r|W.\\1oI^C\u0017\u000e^3mSN$h+\u00197jI\u0006$xN\u001d\u0015\u0004\u0001\tm\u0004\u0003BA@\u0005{JAAa \u0002\u0002\n!A*\u0019>zQ\r\u0001!1\u0011\t\u0005\u0003\u007f\u0012))\u0003\u0003\u0003\b\u0006\u0005%!D\"p]\u001aLw-\u001e:bi&|g.A\tF]\u001eLg.\u001a\"fC:\u0014U/\u001b7eKJ\u0004\"AS\u000f\u0014\u0005uYCC\u0001BF\u0003M\u0019'/Z1uK^{'o[3s\u001b\u0006t\u0017mZ3s))\tYD!&\u0003\u0018\ne%Q\u0016\u0005\b\u0003S{\u0002\u0019AAV\u0011\u001d\t\u0019l\ba\u0001\u0003kCqAa' \u0001\u0004\u0011i*A\td_:4\u0017nZ;sCRLwN\u001c%bg\"\u0004BAa(\u0003(:!!\u0011\u0015BR!\tyW&C\u0002\u0003&6\na\u0001\u0015:fI\u00164\u0017\u0002\u0002BU\u0005W\u0013aa\u0015;sS:<'b\u0001BS[!1!qV\u0010A\u0002y\fab\u001d5pk2$gj\u001c;DQVt7\u000e")
public class EngineBeanBuilder {
    private final Archive archive;
    private final RepositoryFactory repositoryAdapter;
    private final Logger logger;
    @Value(value="${deploy.task.in-process-worker:true}")
    private boolean inProcessTaskEngine;
    @Value(value="${deploy.task.resilient:false}")
    private boolean taskResilientEnabled;
    private final BeanWrapper<ActorRef> wrappedWorkerManager;
    private final BeanWrapper<TaskExecutionEngine> wrappedEngine;
    private final BeanWrapper<DiscoveryService> wrappedDiscoveryService;

    public static ActorRef createWorkerManager(ActorSystem system, TaskExecutionWorkerRepository taskExecutionWorkerRepository, String configurationHash, boolean shouldNotChunk) {
        return EngineBeanBuilder$.MODULE$.createWorkerManager(system, taskExecutionWorkerRepository, configurationHash, shouldNotChunk);
    }

    public Archive archive() {
        return this.archive;
    }

    public RepositoryFactory repositoryAdapter() {
        return this.repositoryAdapter;
    }

    private Logger logger() {
        return this.logger;
    }

    public String toString() {
        return super.toString();
    }

    public boolean inProcessTaskEngine() {
        return this.inProcessTaskEngine;
    }

    public void inProcessTaskEngine_$eq(boolean x$1) {
        this.inProcessTaskEngine = x$1;
    }

    public boolean taskResilientEnabled() {
        return this.taskResilientEnabled;
    }

    public void taskResilientEnabled_$eq(boolean x$1) {
        this.taskResilientEnabled = x$1;
    }

    public BeanWrapper<ActorRef> wrappedWorkerManager() {
        return this.wrappedWorkerManager;
    }

    public BeanWrapper<TaskExecutionEngine> wrappedEngine() {
        return this.wrappedEngine;
    }

    public BeanWrapper<DiscoveryService> wrappedDiscoveryService() {
        return this.wrappedDiscoveryService;
    }

    @Bean
    public BeanWrapper<ActorRef> workerManager() {
        return this.wrappedWorkerManager();
    }

    @Bean
    @DependsOn(value={"upgrader"})
    public BeanWrapper<TaskExecutionEngine> engine() {
        return this.wrappedEngine();
    }

    @Bean
    public BeanWrapper<DiscoveryService> discoveryService() {
        return this.wrappedDiscoveryService();
    }

    public void initWorkerManager(ActorSystem system, TaskExecutionWorkerRepository taskExecutionWorkerRepository, ConfigurationHashProvider configurationHashProvider) {
        ActorRef workerManger = EngineBeanBuilder$.MODULE$.createWorkerManager(system, taskExecutionWorkerRepository, configurationHashProvider.configurationHash(), this.inProcessTaskEngine());
        this.wrappedWorkerManager().set((Object)workerManger);
    }

    public void initEngine(ActorSystem system, ActiveTaskRepository activeTaskRepository, PendingTaskRepository pendingTaskRepository, JmsListenerContainerFactory<DefaultMessageListenerContainer> containerFactory, TaskExecutionWorkerRepository taskExecutionWorkerRepository, StepLogFactory stepLogFactory, StepLogRetriever stepLogRetriever, ConfigurationHashProvider configurationHashProvider, TaskerSettings taskerSettings, TaskQueueService taskQueueService) {
        ActorRef actorRef;
        TaskFinalizerImpl taskFinalizer = new TaskFinalizerImpl(system, (CrudTaskRepository)activeTaskRepository, pendingTaskRepository, taskerSettings.askTimeout());
        TaskExecutionEngine engine = new TaskExecutionEngine(activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, taskQueueService, system, (ActorRef)this.workerManager().get(), (TaskFinalizer)taskFinalizer, this.taskResilientEnabled());
        if (this.inProcessTaskEngine()) {
            this.logger().info("An in-process task execution worker will be registered.");
            TaskExecutionWorker$.MODULE$.local(this.repositoryAdapter(), this.archive(), configurationHashProvider, activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, containerFactory, taskerSettings, stepLogFactory, stepLogRetriever, system).recoverTasks();
            DiscoveryWorker$.MODULE$.initialize(system);
            actorRef = BoxedUnit.UNIT;
        } else {
            this.logger().debug("Registering for remote change set events.");
            actorRef = system.actorOf(RemoteChangeSetEventListener$.MODULE$.props(), RemoteChangeSetEventListener$.MODULE$.name());
        }
        system.actorOf(QueryActor$.MODULE$.props(), QueryActor$.MODULE$.name());
        this.rescheduleTasks(pendingTaskRepository, engine);
        this.wrappedEngine().set((Object)engine);
    }

    public void initDiscoveryService(ActorSystem system) {
        this.wrappedDiscoveryService().set((Object)new DiscoveryService(system, (ActorRef)this.workerManager().get(), this.inProcessTaskEngine()));
    }

    private void rescheduleTasks(PendingTaskRepository pendingTaskRepository, TaskExecutionEngine engine) {
        pendingTaskRepository.scheduledTasks().forEach(task -> {
            Throwable ex;
            DateTime scheduledDate = task.getScheduledDate();
            String date = scheduledDate.toDateTimeISO().toString("yyyy-MM-dd'T'HH:mm:ss");
            if (scheduledDate.isBeforeNow()) {
                this.logger().info(new StringBuilder(67).append("Scheduled task [").append(task.getId()).append("] with date [").append(date).append("] has already passed so executing now.").toString());
                engine.execute(task.getId());
                return;
            }
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> engine.schedule(task.getId(), scheduledDate));
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable ex2 = failure.exception();
                if (ex2 instanceof TaskerException) {
                    TaskerException taskerException = (TaskerException)ex2;
                    this.logger().warn(new StringBuilder(73).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically.").toString());
                    this.logger().warn(taskerException.getMessage());
                    return;
                }
            }
            if (bl && (ex = failure.exception()) instanceof Exception) {
                Exception exception = (Exception)ex;
                this.logger().warn(new StringBuilder(100).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically. Unexpected error occurred.").toString());
                throw exception;
            }
            if (try_ instanceof Success) {
                this.logger().info(new StringBuilder(52).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] was rescheduled").toString());
                return;
            }
            throw new MatchError((Object)try_);
        });
    }

    public EngineBeanBuilder(@Autowired Archive archive, @Autowired RepositoryFactory repositoryAdapter) {
        this.archive = archive;
        this.repositoryAdapter = repositoryAdapter;
        this.logger = LoggerFactory.getLogger(EngineBeanBuilder.class);
        this.wrappedWorkerManager = BeanWrapper$.MODULE$.apply();
        this.wrappedEngine = BeanWrapper$.MODULE$.apply();
        this.wrappedDiscoveryService = BeanWrapper$.MODULE$.apply();
    }
}

