package com.xebialabs.deployit.listener.deployment

import ai.digital.deploy.tasker.common.TaskMetadata
import com.xebialabs.deployit.engine.api.dto._
import com.xebialabs.deployit.engine.spi.execution.{NonRemotableExecutionStateListener, StepExecutionStateEvent, TaskExecutionStateEvent}
import com.xebialabs.xldeploy.status.queue.DeploymentPackageStatusStoreHolder
import grizzled.slf4j.Logging
import org.joda.time.DateTime

class DeploymentStatusListener extends NonRemotableExecutionStateListener with Logging {
  override def stepStateChanged(event: StepExecutionStateEvent): Unit = {
    // empty handler
  }

  override def taskStateChanged(event: TaskExecutionStateEvent): Unit = {
    val task = event.task()
    logger.info(s"Received state change for ${event.task().getId}  from ${event.previousState()} to ${event.currentState()}")
    if (DeploymentStatusUtils.isDeleteEvent(task)) {
      DeploymentPackageStatusStoreHolder.getDeploymentPackageStatusStore.sendDeployedApplicationPackageEvent(
        DeployedApplicationPackage(
          StateOperation.RemoveState,
          DeploymentStatusUtils.extractMetadata(TaskMetadata.APPLICATION)(task),
          DeploymentStatusUtils.extractMetadata(TaskMetadata.APPLICATION_REFERENCE_ID)(task),
          DeploymentStatusUtils.getApplicationPathFromTaskId(task.getId),
          VersionTag(DeploymentStatusUtils.extractMetadata(TaskMetadata.VERSION)(task), ""),
          DeploymentStatusUtils.extractMetadata(TaskMetadata.ENVIRONMENT)(task),
          DeploymentStatusUtils.extractMetadata(TaskMetadata.ENVIRONMENT_REFERENCE_ID)(task),
          ""
        )
      )
    }
    else {
      DeploymentPackageStatusStoreHolder.getDeploymentPackageStatusStore.sendDeploymentPackageStatusEvent(
        ApplicationDeploymentPackageState(
          DeploymentStatusUtils.extractMetadata(TaskMetadata.APPLICATION)(task),
          DeploymentStatusUtils.extractMetadata(TaskMetadata.APPLICATION_REFERENCE_ID)(task),
          DeploymentStatusUtils.resolveTaskApplicationPath(task),
          DeploymentPackageState(
            DeploymentStatusUtils.extractMetadata(TaskMetadata.ENVIRONMENT)(task),
            DeploymentStatusUtils.extractMetadata(TaskMetadata.ENVIRONMENT_REFERENCE_ID)(task),
            "",
            VersionTag(DeploymentStatusUtils.resolveApplicationVersion(task), ""),
            DeploymentStatusUtils.resolveApplicationStatus(task),
            DeploymentStatusUtils.extractMetadata(TaskMetadata.TASK_TYPE)(task),
            task.getOwner,
            Option(task.getStartDate).orElse(Option(task.getScheduledDate)).getOrElse(DateTime.now())
          )
        )
      )
    }
  }
}
