/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.event

import com.xebialabs.deployit.plugin.api.reflect.{DescriptorRegistry, PropertyDescriptor}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

import scala.jdk.CollectionConverters._

object DeployedChangeEventHandler {

  def notifyDeployedPropertiesChange(taskId: String,
                                     deployeds: java.util.List[ConfigurationItem],
                                     existingDeployeds: java.util.List[ConfigurationItem]): Unit = {
    val messages = getDeployedsChangedPropertyMessages(taskId, deployeds.asScala.toList, existingDeployeds.asScala.toList)
    if (messages.nonEmpty) {
      messages.foreach(m => EventBusHolder.publish(new DeployedChangeEvent(taskId, m)))
    }
  }

  def getDeployedsChangedPropertyMessages(taskId: String,
                                          deployeds: List[ConfigurationItem],
                                          existingDeployeds: List[ConfigurationItem]): List[String] = {
    if (existingDeployeds.isEmpty) Nil else {
      val existingDeployedsMap = existingDeployeds.map(deployed => deployed.getId -> deployed).toMap

      def checkIfEqual(deployed: ConfigurationItem)(propertyDescriptor: PropertyDescriptor): Boolean =
        propertyDescriptor.areEqual(deployed, existingDeployedsMap(deployed.getId))

      deployeds.filter(deployed => existingDeployedsMap.contains(deployed.getId)).flatMap(deployed => {
          val pds = DescriptorRegistry.getDescriptor(deployed.getType).getPropertyDescriptors.asScala
          pds.filterNot(checkIfEqual(deployed))
            .map(pd => s"Updated CI property during deployment, task [$taskId] CI [$deployed] property [${pd.getName}] " +
              s"from: [${pd.get(existingDeployedsMap(deployed.getId))}] to: [${if (pd.isPassword) "********" else pd.get(deployed)}]")
        })
    }
  }
}
